/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.enter;

import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegate;
import com.intellij.codeInsight.editorActions.enter.EnterHandlerDelegateAdapter;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageFormatting;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorModificationUtil;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.actionSystem.EditorActionHandler;
import com.intellij.openapi.editor.actions.EditorActionUtil;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.highlighter.HighlighterIterator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettings;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BaseIndentEnterHandler
extends EnterHandlerDelegateAdapter {
    private final Language myLanguage;
    private final TokenSet myIndentTokens;
    private final IElementType myLineCommentType;
    private final String myLineCommentPrefix;
    private final TokenSet myWhitespaceTokens;
    private final boolean myWorksWithFormatter;

    public BaseIndentEnterHandler(Language language, TokenSet indentTokens, IElementType lineCommentType, String lineCommentPrefix, TokenSet whitespaceTokens) {
        this(language, indentTokens, lineCommentType, lineCommentPrefix, whitespaceTokens, false);
    }

    public BaseIndentEnterHandler(Language language, TokenSet indentTokens, IElementType lineCommentType, String lineCommentPrefix, TokenSet whitespaceTokens, boolean worksWithFormatter) {
        this.myLanguage = language;
        this.myIndentTokens = indentTokens;
        this.myLineCommentType = lineCommentType;
        this.myLineCommentPrefix = lineCommentPrefix;
        this.myWhitespaceTokens = whitespaceTokens;
        this.myWorksWithFormatter = worksWithFormatter;
    }

    protected EnterHandlerDelegate.Result shouldSkipWithResult(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull DataContext dataContext) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/enter/BaseIndentEnterHandler", "shouldSkipWithResult"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/enter/BaseIndentEnterHandler", "shouldSkipWithResult"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/codeInsight/editorActions/enter/BaseIndentEnterHandler", "shouldSkipWithResult"));
        }
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (!file2.getViewProvider().getLanguages().contains(this.myLanguage)) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (editor.isViewer()) {
            return EnterHandlerDelegate.Result.Continue;
        }
        Document document = editor.getDocument();
        if (!document.isWritable()) {
            return EnterHandlerDelegate.Result.Continue;
        }
        PsiDocumentManager.getInstance((Project)project2).commitDocument(document);
        int caret = editor.getCaretModel().getOffset();
        if (caret == 0) {
            return EnterHandlerDelegate.Result.DefaultSkipIndent;
        }
        if (caret <= 0) {
            return EnterHandlerDelegate.Result.Continue;
        }
        return null;
    }

    @Override
    public EnterHandlerDelegate.Result preprocessEnter(@NotNull PsiFile file2, @NotNull Editor editor, @NotNull Ref<Integer> caretOffset, @NotNull Ref<Integer> caretAdvance, @NotNull DataContext dataContext, EditorActionHandler originalHandler) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/enter/BaseIndentEnterHandler", "preprocessEnter"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/enter/BaseIndentEnterHandler", "preprocessEnter"));
        }
        if (caretOffset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretOffset", "com/intellij/codeInsight/editorActions/enter/BaseIndentEnterHandler", "preprocessEnter"));
        }
        if (caretAdvance == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caretAdvance", "com/intellij/codeInsight/editorActions/enter/BaseIndentEnterHandler", "preprocessEnter"));
        }
        if (dataContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataContext", "com/intellij/codeInsight/editorActions/enter/BaseIndentEnterHandler", "preprocessEnter"));
        }
        EnterHandlerDelegate.Result res = this.shouldSkipWithResult(file2, editor, dataContext);
        if (res != null) {
            return res;
        }
        Document document = editor.getDocument();
        int caret = editor.getCaretModel().getOffset();
        int lineNumber = document.getLineNumber(caret);
        int lineStartOffset = document.getLineStartOffset(lineNumber);
        int previousLineStartOffset = lineNumber > 0 ? document.getLineStartOffset(lineNumber - 1) : lineStartOffset;
        EditorHighlighter highlighter = ((EditorEx)editor).getHighlighter();
        HighlighterIterator iterator = highlighter.createIterator(caret - 1);
        IElementType type = this.getNonWhitespaceElementType(iterator, lineStartOffset, previousLineStartOffset);
        CharSequence editorCharSequence = document.getCharsSequence();
        CharSequence lineIndent = editorCharSequence.subSequence(lineStartOffset, EditorActionUtil.findFirstNonSpaceOffsetOnTheLine(document, lineNumber));
        if (type == this.myLineCommentType) {
            String restString = editorCharSequence.subSequence(caret, document.getLineEndOffset(lineNumber)).toString();
            if (!StringUtil.isEmptyOrSpaces((String)restString)) {
                String linePrefix = lineIndent + this.myLineCommentPrefix;
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)("\n" + linePrefix));
                editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(lineNumber + 1, linePrefix.length()));
                return EnterHandlerDelegate.Result.Stop;
            }
            if (iterator.getStart() < lineStartOffset) {
                EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)("\n" + lineIndent));
                return EnterHandlerDelegate.Result.Stop;
            }
        }
        if (!this.myWorksWithFormatter && LanguageFormatting.INSTANCE.forLanguage(this.myLanguage) != null) {
            return EnterHandlerDelegate.Result.Continue;
        }
        if (this.myIndentTokens.contains(type)) {
            String newIndent = this.getNewIndent(file2, document, lineIndent);
            EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)("\n" + newIndent));
            return EnterHandlerDelegate.Result.Stop;
        }
        EditorModificationUtil.insertStringAtCaret((Editor)editor, (String)("\n" + lineIndent));
        editor.getCaretModel().moveToLogicalPosition(new LogicalPosition(lineNumber + 1, BaseIndentEnterHandler.calcLogicalLength(editor, lineIndent)));
        return EnterHandlerDelegate.Result.Stop;
    }

    protected String getNewIndent(@NotNull PsiFile file2, @NotNull Document document, @NotNull CharSequence oldIndent) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/enter/BaseIndentEnterHandler", "getNewIndent"));
        }
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/codeInsight/editorActions/enter/BaseIndentEnterHandler", "getNewIndent"));
        }
        if (oldIndent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "oldIndent", "com/intellij/codeInsight/editorActions/enter/BaseIndentEnterHandler", "getNewIndent"));
        }
        CharSequence nonEmptyIndent = oldIndent;
        CharSequence editorCharSequence = document.getCharsSequence();
        int nLines = document.getLineCount();
        for (int line = 0; line < nLines && nonEmptyIndent.length() == 0; ++line) {
            int indentEnd;
            int lineStart = document.getLineStartOffset(line);
            if (lineStart >= (indentEnd = EditorActionUtil.findFirstNonSpaceOffsetOnTheLine(document, line))) continue;
            nonEmptyIndent = editorCharSequence.subSequence(lineStart, indentEnd);
        }
        boolean usesSpacesForIndentation = nonEmptyIndent.length() > 0 && nonEmptyIndent.charAt(nonEmptyIndent.length() - 1) == ' ';
        boolean firstIndent = nonEmptyIndent.length() == 0;
        CodeStyleSettings currentSettings = CodeStyleSettingsManager.getSettings((Project)file2.getProject());
        CommonCodeStyleSettings.IndentOptions indentOptions = currentSettings.getIndentOptions(file2.getFileType());
        if (firstIndent && indentOptions.USE_TAB_CHARACTER || !firstIndent && !usesSpacesForIndentation) {
            int nTabsToIndent = indentOptions.INDENT_SIZE / indentOptions.TAB_SIZE;
            if (indentOptions.INDENT_SIZE % indentOptions.TAB_SIZE != 0) {
                ++nTabsToIndent;
            }
            return oldIndent + StringUtil.repeatSymbol((char)'\t', (int)nTabsToIndent);
        }
        return oldIndent + StringUtil.repeatSymbol((char)' ', (int)indentOptions.INDENT_SIZE);
    }

    private static int calcLogicalLength(Editor editor, CharSequence lineIndent) {
        int result = 0;
        for (int i = 0; i < lineIndent.length(); ++i) {
            if (lineIndent.charAt(i) == '\t') {
                result += EditorUtil.getTabSize(editor);
                continue;
            }
            ++result;
        }
        return result;
    }

    @Nullable
    protected IElementType getNonWhitespaceElementType(HighlighterIterator iterator, int currentLineStartOffset, int prevLineStartOffset) {
        while (!iterator.atEnd() && iterator.getEnd() >= currentLineStartOffset && iterator.getStart() >= prevLineStartOffset) {
            IElementType tokenType = iterator.getTokenType();
            if (!this.myWhitespaceTokens.contains(tokenType)) {
                return tokenType;
            }
            iterator.retreat();
        }
        return null;
    }
}

