/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.moveLeftRight;

import com.intellij.codeInsight.editorActions.moveLeftRight.MoveElementLeftRightHandler;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Caret;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.actionSystem.EditorWriteActionHandler;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.Range;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MoveElementLeftRightActionHandler
extends EditorWriteActionHandler {
    private static final Comparator<PsiElement> BY_OFFSET = new Comparator<PsiElement>(){

        @Override
        public int compare(PsiElement o1, PsiElement o2) {
            return o1.getTextOffset() - o2.getTextOffset();
        }
    };
    private final boolean myIsLeft;

    public MoveElementLeftRightActionHandler(boolean isLeft) {
        super(true);
        this.myIsLeft = isLeft;
    }

    protected boolean isEnabledForCaret(@NotNull Editor editor, @NotNull Caret caret, DataContext dataContext) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/codeInsight/editorActions/moveLeftRight/MoveElementLeftRightActionHandler", "isEnabledForCaret"));
        }
        if (caret == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "caret", "com/intellij/codeInsight/editorActions/moveLeftRight/MoveElementLeftRightActionHandler", "isEnabledForCaret"));
        }
        Project project2 = editor.getProject();
        if (project2 == null) {
            return false;
        }
        Document document = editor.getDocument();
        if (!(document instanceof DocumentEx)) {
            return false;
        }
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project2);
        psiDocumentManager.commitDocument(document);
        PsiFile file2 = psiDocumentManager.getPsiFile(document);
        if (file2 == null || !file2.isValid()) {
            return false;
        }
        PsiElement[] elementList = MoveElementLeftRightActionHandler.getElementList(file2, caret.getSelectionStart(), caret.getSelectionEnd());
        return elementList != null;
    }

    @Nullable
    private static PsiElement[] getElementList(@NotNull PsiFile file2, int rangeStart, int rangeEnd) {
        PsiElement endElement;
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/codeInsight/editorActions/moveLeftRight/MoveElementLeftRightActionHandler", "getElementList"));
        }
        PsiElement startElement = file2.findElementAt(rangeStart);
        if (startElement == null) {
            return null;
        }
        PsiElement psiElement = endElement = rangeEnd > rangeStart ? file2.findElementAt(rangeEnd - 1) : startElement;
        if (endElement == null) {
            return null;
        }
        for (PsiElement element = PsiTreeUtil.findCommonParent((PsiElement)startElement, (PsiElement)endElement); element != null; element = element.getParent()) {
            List handlers = MoveElementLeftRightHandler.EXTENSION.allForLanguage(element.getLanguage());
            for (MoveElementLeftRightHandler handler2 : handlers) {
                PsiElement[] elementList = handler2.getMovableSubElements(element);
                if (elementList.length <= 1) continue;
                Arrays.sort(elementList, BY_OFFSET);
                PsiElement first = elementList[0];
                PsiElement last = elementList[elementList.length - 1];
                if (rangeStart < first.getTextRange().getStartOffset() || rangeEnd > last.getTextRange().getEndOffset() || rangeStart < first.getTextRange().getEndOffset() && rangeEnd > last.getTextRange().getStartOffset()) continue;
                return elementList;
            }
        }
        return null;
    }

    public void executeWriteAction(Editor editor, @Nullable Caret caret, DataContext dataContext) {
        int caretShift;
        assert (caret != null);
        DocumentEx document = (DocumentEx)editor.getDocument();
        Project project2 = editor.getProject();
        assert (project2 != null);
        PsiDocumentManager psiDocumentManager = PsiDocumentManager.getInstance((Project)project2);
        PsiFile file2 = psiDocumentManager.getPsiFile((Document)document);
        assert (file2 != null);
        int selectionStart = caret.getSelectionStart();
        int selectionEnd = caret.getSelectionEnd();
        assert (selectionStart <= selectionEnd);
        PsiElement[] elementList = MoveElementLeftRightActionHandler.getElementList(file2, selectionStart, selectionEnd);
        assert (elementList != null);
        Range<Integer> elementRange = this.findRangeOfElementsToMove(elementList, selectionStart, selectionEnd);
        if (elementRange == null) {
            return;
        }
        int toMoveStart = elementList[(Integer)elementRange.getFrom()].getTextRange().getStartOffset();
        int toMoveEnd = elementList[(Integer)elementRange.getTo()].getTextRange().getEndOffset();
        int otherIndex = this.myIsLeft ? (Integer)elementRange.getFrom() - 1 : (Integer)elementRange.getTo() + 1;
        int otherStart = elementList[otherIndex].getTextRange().getStartOffset();
        int otherEnd = elementList[otherIndex].getTextRange().getEndOffset();
        selectionStart = MoveElementLeftRightActionHandler.trim(selectionStart, toMoveStart, toMoveEnd);
        selectionEnd = MoveElementLeftRightActionHandler.trim(selectionEnd, toMoveStart, toMoveEnd);
        int caretOffset = MoveElementLeftRightActionHandler.trim(caret.getOffset(), toMoveStart, toMoveEnd);
        if (toMoveStart < otherStart) {
            document.moveText(toMoveStart, toMoveEnd, otherStart);
            document.moveText(otherStart, otherEnd, toMoveStart);
            caretShift = otherEnd - toMoveEnd;
        } else {
            document.moveText(otherStart, otherEnd, toMoveStart);
            document.moveText(toMoveStart, toMoveEnd, otherStart);
            caretShift = otherStart - toMoveStart;
        }
        caret.moveToOffset(caretOffset + caretShift);
        caret.setSelection(selectionStart + caretShift, selectionEnd + caretShift);
    }

    @Nullable
    private Range<Integer> findRangeOfElementsToMove(@NotNull PsiElement[] elements, int startOffset, int endOffset) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/codeInsight/editorActions/moveLeftRight/MoveElementLeftRightActionHandler", "findRangeOfElementsToMove"));
        }
        int startIndex = elements.length;
        int endIndex = -1;
        if (startOffset == endOffset) {
            for (int i = 0; i < elements.length; ++i) {
                if (!elements[i].getTextRange().containsOffset(startOffset)) continue;
                startIndex = endIndex = i;
                break;
            }
        } else {
            int i = 0;
            while (i < elements.length) {
                PsiElement psiElement = elements[i];
                TextRange range = psiElement.getTextRange();
                if (i < startIndex && startOffset < range.getEndOffset()) {
                    startIndex = i;
                }
                if (endOffset > range.getStartOffset()) {
                    endIndex = i++;
                    continue;
                }
                break;
            }
        }
        return startIndex > endIndex || (this.myIsLeft ? startIndex == 0 : endIndex == elements.length - 1) ? null : new Range((Comparable)Integer.valueOf(startIndex), (Comparable)Integer.valueOf(endIndex));
    }

    private static int trim(int offset, int rangeStart, int rangeEnd) {
        return Math.max(rangeStart, Math.min(rangeEnd, offset));
    }
}

