/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.smartEnter;

import com.intellij.codeInsight.editorActions.smartEnter.Fixer;
import com.intellij.codeInsight.editorActions.smartEnter.JavaSmartEnterProcessor;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiStatement;
import com.intellij.util.IncorrectOperationException;

public class MissingIfBranchesFixer
implements Fixer {
    @Override
    public void apply(Editor editor, JavaSmartEnterProcessor processor2, PsiElement psiElement) throws IncorrectOperationException {
        PsiStatement thenBranch;
        if (!(psiElement instanceof PsiIfStatement)) {
            return;
        }
        PsiIfStatement ifStatement = (PsiIfStatement)psiElement;
        Document doc = editor.getDocument();
        PsiStatement elseBranch = ifStatement.getElseBranch();
        PsiKeyword elseElement = ifStatement.getElseElement();
        if (elseElement != null && (elseBranch == null || !(elseBranch instanceof PsiBlockStatement) && MissingIfBranchesFixer.startLine(doc, (PsiElement)elseBranch) > MissingIfBranchesFixer.startLine(doc, (PsiElement)elseElement))) {
            doc.insertString(elseElement.getTextRange().getEndOffset(), (CharSequence)"{}");
        }
        if ((thenBranch = ifStatement.getThenBranch()) instanceof PsiBlockStatement) {
            return;
        }
        boolean transformingOneLiner = false;
        if (thenBranch != null && MissingIfBranchesFixer.startLine(doc, (PsiElement)thenBranch) == MissingIfBranchesFixer.startLine(doc, (PsiElement)ifStatement)) {
            if (ifStatement.getCondition() != null) {
                return;
            }
            transformingOneLiner = true;
        }
        PsiJavaToken rParenth = ifStatement.getRParenth();
        assert (rParenth != null);
        if (elseBranch == null && !transformingOneLiner || thenBranch == null) {
            doc.insertString(rParenth.getTextRange().getEndOffset(), (CharSequence)"{}");
        } else {
            doc.insertString(rParenth.getTextRange().getEndOffset(), (CharSequence)"{");
            doc.insertString(thenBranch.getTextRange().getEndOffset() + 1, (CharSequence)"}");
        }
    }

    private static int startLine(Document doc, PsiElement psiElement) {
        return doc.getLineNumber(psiElement.getTextRange().getStartOffset());
    }
}

