/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.wordSelection.BasicSelectioner;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiKeyword;
import com.intellij.psi.PsiStatement;
import java.util.ArrayList;
import java.util.List;

public class IfStatementSelectioner
extends BasicSelectioner {
    @Override
    public boolean canSelect(PsiElement e) {
        return e instanceof PsiIfStatement;
    }

    @Override
    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        result.addAll(IfStatementSelectioner.expandToWholeLine(editorText, e.getTextRange(), false));
        PsiIfStatement statement2 = (PsiIfStatement)e;
        PsiKeyword elseKeyword = statement2.getElseElement();
        if (elseKeyword != null) {
            PsiStatement elseThen;
            PsiIfStatement elseIf;
            PsiKeyword element;
            TextRange thenRange;
            PsiStatement then2 = statement2.getThenBranch();
            if (then2 != null && (thenRange = new TextRange(statement2.getTextRange().getStartOffset(), then2.getTextRange().getEndOffset())).contains(cursorOffset)) {
                result.addAll(IfStatementSelectioner.expandToWholeLine(editorText, thenRange, false));
            }
            result.addAll(IfStatementSelectioner.expandToWholeLine(editorText, new TextRange(elseKeyword.getTextRange().getStartOffset(), statement2.getTextRange().getEndOffset()), false));
            PsiStatement branch = statement2.getElseBranch();
            if (branch instanceof PsiIfStatement && (element = (elseIf = (PsiIfStatement)branch).getElseElement()) != null && (elseThen = elseIf.getThenBranch()) != null) {
                result.addAll(IfStatementSelectioner.expandToWholeLine(editorText, new TextRange(elseKeyword.getTextRange().getStartOffset(), elseThen.getTextRange().getEndOffset()), false));
            }
        }
        return result;
    }
}

