/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.editorActions.wordSelection;

import com.intellij.codeInsight.editorActions.ExtendWordSelectionHandlerBase;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPlainText;
import java.util.ArrayList;
import java.util.List;

public class PlainTextLineSelectioner
extends ExtendWordSelectionHandlerBase {
    @Override
    public boolean canSelect(PsiElement e) {
        return e instanceof PsiPlainText;
    }

    @Override
    public List<TextRange> select(PsiElement e, CharSequence editorText, int cursorOffset, Editor editor) {
        return PlainTextLineSelectioner.selectPlainTextLine(e, editorText, cursorOffset);
    }

    public static List<TextRange> selectPlainTextLine(PsiElement e, CharSequence editorText, int cursorOffset) {
        int end;
        int start;
        for (start = cursorOffset; start > 0 && editorText.charAt(start - 1) != '\n' && editorText.charAt(start - 1) != '\r'; --start) {
        }
        for (end = cursorOffset; end < editorText.length() && editorText.charAt(end) != '\n' && editorText.charAt(end) != '\r'; ++end) {
        }
        TextRange range = new TextRange(start, end);
        if (!e.getParent().getTextRange().contains(range)) {
            return null;
        }
        ArrayList<TextRange> result = new ArrayList<TextRange>();
        result.add(range);
        return result;
    }
}

