/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.generation.surroundWith;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.generation.surroundWith.JavaExpressionSurrounder;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiBinaryExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;

class JavaWithNullCheckSurrounder
extends JavaExpressionSurrounder {
    JavaWithNullCheckSurrounder() {
    }

    public boolean isApplicable(PsiExpression expr) {
        PsiType type = expr.getType();
        if (type instanceof PsiPrimitiveType) {
            return false;
        }
        if (!expr.isPhysical()) {
            return false;
        }
        if (expr.getParent() instanceof PsiExpressionStatement) {
            return false;
        }
        PsiElement parent = PsiTreeUtil.getParentOfType((PsiElement)expr, PsiExpressionStatement.class);
        if (parent == null) {
            return false;
        }
        PsiElement element = parent.getParent();
        return element instanceof PsiCodeBlock || FileTypeUtils.isInServerPageFile((PsiElement)element) && element instanceof PsiFile;
    }

    public TextRange surroundExpression(Project project2, Editor editor, PsiExpression expr) throws IncorrectOperationException {
        PsiManager manager = expr.getManager();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)manager.getProject()).getElementFactory();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project2);
        String text = "if(a != null){\nst;\n}";
        PsiIfStatement ifStatement = (PsiIfStatement)factory.createStatementFromText(text, null);
        ifStatement = (PsiIfStatement)codeStyleManager.reformat((PsiElement)ifStatement);
        ((PsiBinaryExpression)ifStatement.getCondition()).getLOperand().replace((PsiElement)expr);
        PsiExpressionStatement statement2 = (PsiExpressionStatement)PsiTreeUtil.getParentOfType((PsiElement)expr, PsiExpressionStatement.class);
        String oldText = statement2.getText();
        ifStatement = (PsiIfStatement)statement2.replace((PsiElement)ifStatement);
        PsiCodeBlock block = ((PsiBlockStatement)ifStatement.getThenBranch()).getCodeBlock();
        block = CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(block);
        PsiElement replace = block.getStatements()[0].replace((PsiElement)factory.createStatementFromText(oldText, (PsiElement)block));
        int offset = replace.getTextRange().getEndOffset();
        return new TextRange(offset, offset);
    }

    public String getTemplateDescription() {
        return "if (expr != null) {...}";
    }
}

