/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.nodes;

import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.ZenCodingUtil;
import com.intellij.codeInsight.template.emmet.generators.ZenCodingGenerator;
import com.intellij.codeInsight.template.emmet.nodes.GenerationNode;
import com.intellij.codeInsight.template.emmet.nodes.ZenCodingNode;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateNode
extends ZenCodingNode {
    private final TemplateToken myTemplateToken;
    @Nullable
    private final ZenCodingGenerator myGenerator;

    public TemplateNode(TemplateToken templateToken) {
        this(templateToken, null);
    }

    public TemplateNode(TemplateToken token, @Nullable ZenCodingGenerator generator) {
        this.myTemplateToken = token;
        this.myGenerator = generator;
    }

    public TemplateToken getTemplateToken() {
        return this.myTemplateToken;
    }

    @Override
    @NotNull
    public List<GenerationNode> expand(int numberInIteration, int totalIterations, String surroundedText, CustomTemplateCallback callback, boolean insertSurroundedTextAtTheEnd, GenerationNode parent) {
        TemplateToken templateToken = this.myTemplateToken;
        String templateKey = templateToken.getKey();
        if (this.myGenerator != null && StringUtil.containsChar((String)templateKey, (char)'$') && callback.findApplicableTemplate(templateKey) == null) {
            String newTemplateKey = ZenCodingUtil.replaceMarkers(templateKey, numberInIteration, totalIterations, surroundedText);
            TemplateToken newTemplateToken = new TemplateToken(newTemplateKey, templateToken.getAttributes());
            TemplateImpl template = this.myGenerator.createTemplateByKey(newTemplateKey);
            if (template != null) {
                template.setDeactivated(true);
                newTemplateToken.setTemplate(template, callback);
                templateToken = newTemplateToken;
            }
        }
        GenerationNode node = new GenerationNode(templateToken, numberInIteration, totalIterations, surroundedText, insertSurroundedTextAtTheEnd, parent);
        List<GenerationNode> list = Collections.singletonList(node);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/nodes/TemplateNode", "expand"));
        }
        return list;
    }

    public String toString() {
        String result = this.myTemplateToken.getKey();
        Map<String, String> attributes = this.myTemplateToken.getAttributes();
        if (!attributes.isEmpty()) {
            result = result + ContainerUtil.toString(attributes);
        }
        return "Template(" + result + ")";
    }

    @Override
    public int getApproximateOutputLength(@Nullable CustomTemplateCallback callback) {
        TemplateImpl template = this.myTemplateToken.getTemplate();
        if (template != null) {
            int result = template.getTemplateText().length();
            for (Map.Entry<String, String> attribute : this.myTemplateToken.getAttributes().entrySet()) {
                result += attribute.getKey().length() + attribute.getValue().length() + 4;
            }
            return result;
        }
        return 0;
    }
}

