/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.unwrap;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.unwrap.JavaUnwrapper;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.util.IncorrectOperationException;
import java.util.List;

public class JavaConditionalUnwrapper
extends JavaUnwrapper {
    public JavaConditionalUnwrapper() {
        super(CodeInsightBundle.message((String)"unwrap.conditional", (Object[])new Object[0]));
    }

    @Override
    public boolean isApplicableTo(PsiElement e) {
        return e.getParent() instanceof PsiConditionalExpression;
    }

    @Override
    public PsiElement collectAffectedElements(PsiElement e, List<PsiElement> toExtract) {
        super.collectAffectedElements(e, toExtract);
        return e.getParent();
    }

    @Override
    protected void doUnwrap(PsiElement element, JavaUnwrapper.Context context) throws IncorrectOperationException {
        PsiConditionalExpression cond = (PsiConditionalExpression)element.getParent();
        Object savedBlock = cond.getElseExpression() == element ? element : cond.getThenExpression();
        context.extractElement((PsiElement)savedBlock, (PsiElement)cond);
        if (cond.getParent() instanceof PsiExpressionList) {
            context.delete((PsiElement)cond);
        } else {
            context.deleteExactly((PsiElement)cond);
        }
    }
}

