/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.MethodThrowsFix;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class DeleteThrowsFix
implements LocalQuickFix {
    private final MethodThrowsFix myQuickFix;

    public DeleteThrowsFix(@NotNull PsiMethod method, PsiClassType exceptionClass) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/codeInspection/DeleteThrowsFix", "<init>"));
        }
        this.myQuickFix = new MethodThrowsFix(method, exceptionClass, false, false);
    }

    @NotNull
    public String getName() {
        String string = this.myQuickFix.getText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/DeleteThrowsFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("fix.throws.list.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/DeleteThrowsFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/DeleteThrowsFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/DeleteThrowsFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class);
        if (method == null) {
            return;
        }
        PsiFile psiFile = method.getContainingFile();
        if (this.myQuickFix.isAvailable(project2, psiFile, (PsiElement)method, (PsiElement)method)) {
            this.myQuickFix.invoke(project2, psiFile, (PsiElement)method, (PsiElement)method);
        }
    }
}

