/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.bytecodeAnalysis.asm;

import com.intellij.codeInspection.bytecodeAnalysis.asm.IParametersUsage;
import com.intellij.codeInspection.bytecodeAnalysis.asm.IParamsValue;
import com.intellij.codeInspection.bytecodeAnalysis.asm.LeakingParametersCollector;
import com.intellij.codeInspection.bytecodeAnalysis.asm.LiteAnalyzer;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ParametersUsage;
import com.intellij.codeInspection.bytecodeAnalysis.asm.ParamsValue;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.org.objectweb.asm.tree.AbstractInsnNode;
import org.jetbrains.org.objectweb.asm.tree.InsnList;
import org.jetbrains.org.objectweb.asm.tree.MethodNode;
import org.jetbrains.org.objectweb.asm.tree.analysis.Analyzer;
import org.jetbrains.org.objectweb.asm.tree.analysis.AnalyzerException;
import org.jetbrains.org.objectweb.asm.tree.analysis.Frame;
import org.jetbrains.org.objectweb.asm.tree.analysis.Interpreter;
import org.jetbrains.org.objectweb.asm.tree.analysis.Value;

public class LeakingParameters {
    public final Frame<Value>[] frames;
    public final boolean[] parameters;
    public final boolean[] nullableParameters;

    public LeakingParameters(Frame<Value>[] frames, boolean[] parameters, boolean[] nullableParameters) {
        this.frames = frames;
        this.parameters = parameters;
        this.nullableParameters = nullableParameters;
    }

    @NotNull
    public static LeakingParameters build(String className, MethodNode methodNode, boolean jsr) throws AnalyzerException {
        Frame[] frames = jsr ? new Analyzer((Interpreter)new ParametersUsage(methodNode)).analyze(className, methodNode) : new LiteAnalyzer<ParamsValue>(new ParametersUsage(methodNode)).analyze(className, methodNode);
        InsnList insns = methodNode.instructions;
        LeakingParametersCollector collector = new LeakingParametersCollector(methodNode);
        block3: for (int i = 0; i < frames.length; ++i) {
            AbstractInsnNode insnNode = insns.get(i);
            Frame frame = frames[i];
            if (frame == null) continue;
            switch (insnNode.getType()) {
                case 8: 
                case 14: 
                case 15: {
                    continue block3;
                }
                default: {
                    new Frame(frame).execute(insnNode, (Interpreter)collector);
                }
            }
        }
        boolean[] notNullParameters = collector.leaking;
        boolean[] nullableParameters = collector.nullableLeaking;
        for (int i = 0; i < nullableParameters.length; ++i) {
            int n = i;
            nullableParameters[n] = nullableParameters[n] | notNullParameters[i];
        }
        LeakingParameters leakingParameters = new LeakingParameters(frames, notNullParameters, nullableParameters);
        if (leakingParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/asm/LeakingParameters", "build"));
        }
        return leakingParameters;
    }

    @NotNull
    public static LeakingParameters buildFast(String className, MethodNode methodNode, boolean jsr) throws AnalyzerException {
        IParametersUsage parametersUsage = new IParametersUsage(methodNode);
        Frame[] frames = jsr ? new Analyzer((Interpreter)parametersUsage).analyze(className, methodNode) : new LiteAnalyzer<IParamsValue>(parametersUsage).analyze(className, methodNode);
        int leakingMask = parametersUsage.leaking;
        int nullableLeakingMask = parametersUsage.nullableLeaking;
        boolean[] notNullParameters = new boolean[parametersUsage.arity];
        boolean[] nullableParameters = new boolean[parametersUsage.arity];
        for (int i = 0; i < notNullParameters.length; ++i) {
            notNullParameters[i] = (leakingMask & 1 << i) != 0;
            nullableParameters[i] = ((leakingMask | nullableLeakingMask) & 1 << i) != 0;
        }
        LeakingParameters leakingParameters = new LeakingParameters(frames, notNullParameters, nullableParameters);
        if (leakingParameters == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/bytecodeAnalysis/asm/LeakingParameters", "buildFast"));
        }
        return leakingParameters;
    }
}

