/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.instructions;

import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiReferenceExpression;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FieldReferenceInstruction
extends Instruction {
    private final PsiExpression myExpression;
    @Nullable
    private final String mySyntheticFieldName;

    public FieldReferenceInstruction(@NotNull PsiExpression expression, @Nullable @NonNls String syntheticFieldName) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/codeInspection/dataFlow/instructions/FieldReferenceInstruction", "<init>"));
        }
        this.myExpression = expression;
        this.mySyntheticFieldName = syntheticFieldName;
    }

    @Override
    public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState stateBefore, InstructionVisitor visitor) {
        return visitor.visitFieldReference(this, runner, stateBefore);
    }

    public String toString() {
        return "FIELD_REFERENCE: " + this.myExpression.getText();
    }

    @NotNull
    public PsiExpression getExpression() {
        PsiExpression psiExpression = this.myExpression;
        if (psiExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/instructions/FieldReferenceInstruction", "getExpression"));
        }
        return psiExpression;
    }

    @Nullable
    public PsiExpression getElementToAssert() {
        if (this.mySyntheticFieldName != null) {
            return this.myExpression;
        }
        return this.myExpression instanceof PsiArrayAccessExpression ? ((PsiArrayAccessExpression)this.myExpression).getArrayExpression() : ((PsiReferenceExpression)this.myExpression).getQualifierExpression();
    }
}

