/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.java18StreamApi;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.java18StreamApi.PseudoLambdaReplaceTemplate;
import com.intellij.codeInspection.java18StreamApi.StaticPseudoFunctionalStyleMethodOptions;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.util.PsiUtil;
import java.util.Collection;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StaticPseudoFunctionalStyleMethodInspection
extends BaseJavaBatchLocalInspectionTool {
    private static final Logger LOG = Logger.getInstance(StaticPseudoFunctionalStyleMethodInspection.class);
    private final StaticPseudoFunctionalStyleMethodOptions myOptions = new StaticPseudoFunctionalStyleMethodOptions();

    public void readSettings(@NotNull Element node) throws InvalidDataException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodInspection", "readSettings"));
        }
        this.myOptions.readExternal(node);
    }

    public void writeSettings(@NotNull Element node) throws WriteExternalException {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "node", "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodInspection", "writeSettings"));
        }
        this.myOptions.writeExternal(node);
    }

    @Nullable
    public JComponent createOptionsPanel() {
        return this.myOptions.createPanel();
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodInspection", "buildVisitor"));
        }
        if (!PsiUtil.isLanguageLevel8OrHigher((PsiElement)holder.getFile())) {
            PsiElementVisitor psiElementVisitor = PsiElementVisitor.EMPTY_VISITOR;
            if (psiElementVisitor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodInspection", "buildVisitor"));
            }
            return psiElementVisitor;
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethodCallExpression(PsiMethodCallExpression methodCallExpression) {
                String qName = methodCallExpression.getMethodExpression().getQualifiedName();
                if (qName == null) {
                    return;
                }
                qName = StringUtil.getShortName((String)qName);
                Collection<StaticPseudoFunctionalStyleMethodOptions.PipelineElement> handlerInfos = StaticPseudoFunctionalStyleMethodInspection.this.myOptions.findElementsByMethodName(qName);
                if (handlerInfos.isEmpty()) {
                    return;
                }
                PsiMethod method = methodCallExpression.resolveMethod();
                if (method == null) {
                    return;
                }
                PsiClass aClass = method.getContainingClass();
                if (aClass == null) {
                    return;
                }
                String classQualifiedName = aClass.getQualifiedName();
                if (classQualifiedName == null) {
                    return;
                }
                StaticPseudoFunctionalStyleMethodOptions.PipelineElement suitableHandler = null;
                for (StaticPseudoFunctionalStyleMethodOptions.PipelineElement h : handlerInfos) {
                    if (!h.getHandlerClass().equals(classQualifiedName)) continue;
                    suitableHandler = h;
                    break;
                }
                if (suitableHandler == null) {
                    return;
                }
                PseudoLambdaReplaceTemplate.ValidationInfo validationInfo = suitableHandler.getTemplate().validate(methodCallExpression);
                if (validationInfo != null) {
                    holder.registerProblem((PsiElement)methodCallExpression.getMethodExpression(), "Pseudo functional style code", new LocalQuickFix[]{new ReplacePseudoLambdaWithLambda(suitableHandler)});
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    public static class ReplacePseudoLambdaWithLambda
    implements LocalQuickFix {
        private final StaticPseudoFunctionalStyleMethodOptions.PipelineElement myHandler;

        private ReplacePseudoLambdaWithLambda(StaticPseudoFunctionalStyleMethodOptions.PipelineElement handler2) {
            this.myHandler = handler2;
        }

        @Nls
        @NotNull
        public String getName() {
            String string = this.getFamilyName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodInspection$ReplacePseudoLambdaWithLambda", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            if ("Replace with Java Stream API pipeline" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodInspection$ReplacePseudoLambdaWithLambda", "getFamilyName"));
            }
            return "Replace with Java Stream API pipeline";
        }

        public void applyFix(@NotNull Project project2, @NotNull ProblemDescriptor descriptor) {
            PsiElement parent;
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodInspection$ReplacePseudoLambdaWithLambda", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/java18StreamApi/StaticPseudoFunctionalStyleMethodInspection$ReplacePseudoLambdaWithLambda", "applyFix"));
            }
            PsiElement psiElement = descriptor.getPsiElement();
            if (!FileModificationService.getInstance().preparePsiElementsForWrite(new PsiElement[]{psiElement})) {
                return;
            }
            if (psiElement instanceof PsiReferenceExpression && (parent = psiElement.getParent()) instanceof PsiMethodCallExpression) {
                this.myHandler.getTemplate().convertToStream((PsiMethodCallExpression)parent, null, false);
            }
        }
    }
}

