/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.progress;

import com.intellij.compiler.CompilerManagerImpl;
import com.intellij.compiler.impl.CompilerErrorTreeView;
import com.intellij.ide.errorTreeView.NewErrorTreeViewPanel;
import com.intellij.ide.errorTreeView.impl.ErrorTreeViewConfiguration;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.progress.EmptyProgressIndicator;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.AbstractProgressIndicatorExBase;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.AppIconScheme;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.openapi.wm.ex.ProgressIndicatorEx;
import com.intellij.pom.Navigatable;
import com.intellij.problems.WolfTheProblemSolver;
import com.intellij.ui.AppIcon;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.ui.content.MessageView;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Window;
import java.util.ArrayList;
import java.util.StringTokenizer;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompilerTask
extends Task.Backgroundable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.progress.CompilerProgressIndicator");
    private static final Key<Object> CONTENT_ID_KEY = Key.create((String)"CONTENT_ID");
    private static final Key<Object> SESSION_ID_KEY = Key.create((String)"SESSION_ID");
    private static final String APP_ICON_ID = "compiler";
    @NotNull
    private final Object myContentId;
    @NotNull
    private Object mySessionId;
    private NewErrorTreeViewPanel myErrorTreeView;
    private final Object myMessageViewLock;
    private final String myContentName;
    private final boolean myHeadlessMode;
    private final boolean myForceAsyncExecution;
    private final boolean myWaitForPreviousSession;
    private int myErrorCount;
    private int myWarningCount;
    private boolean myMessagesAutoActivated;
    private volatile ProgressIndicator myIndicator;
    private Runnable myCompileWork;
    private final AtomicBoolean myMessageViewWasPrepared;
    private Runnable myRestartWork;
    private final boolean myCompilationStartedAutomatically;
    private CloseListener myCloseListener;

    @Deprecated
    public CompilerTask(@NotNull Project project2, String contentName, boolean headlessMode, boolean forceAsync, boolean waitForPreviousSession) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/progress/CompilerTask", "<init>"));
        }
        this(project2, contentName, headlessMode, forceAsync, waitForPreviousSession, false);
    }

    public CompilerTask(@NotNull Project project2, String contentName, boolean headlessMode, boolean forceAsync, boolean waitForPreviousSession, boolean compilationStartedAutomatically) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/compiler/progress/CompilerTask", "<init>"));
        }
        super(project2, contentName);
        this.mySessionId = this.myContentId = new IDObject("content_id");
        this.myMessageViewLock = new Object();
        this.myErrorCount = 0;
        this.myWarningCount = 0;
        this.myMessagesAutoActivated = false;
        this.myIndicator = new EmptyProgressIndicator();
        this.myMessageViewWasPrepared = new AtomicBoolean(false);
        this.myContentName = contentName;
        this.myHeadlessMode = headlessMode;
        this.myForceAsyncExecution = forceAsync;
        this.myWaitForPreviousSession = waitForPreviousSession;
        this.myCompilationStartedAutomatically = compilationStartedAutomatically;
    }

    @NotNull
    public Object getSessionId() {
        Object object = this.mySessionId;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/progress/CompilerTask", "getSessionId"));
        }
        return object;
    }

    public void setSessionId(@NotNull Object sessionId) {
        if (sessionId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sessionId", "com/intellij/compiler/progress/CompilerTask", "setSessionId"));
        }
        this.mySessionId = sessionId;
    }

    @NotNull
    public Object getContentId() {
        Object object = this.myContentId;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/progress/CompilerTask", "getContentId"));
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCloseAction(final Runnable onClose) {
        Object object = this.myMessageViewLock;
        synchronized (object) {
            if (this.myErrorTreeView != null) {
                Disposer.register((Disposable)this.myErrorTreeView, (Disposable)new Disposable(){

                    public void dispose() {
                        onClose.run();
                    }
                });
                return;
            }
        }
        onClose.run();
    }

    public String getProcessId() {
        return "compilation";
    }

    public boolean shouldStartInBackground() {
        return true;
    }

    public ProgressIndicator getIndicator() {
        return this.myIndicator;
    }

    @Nullable
    public Task.NotificationInfo getNotificationInfo() {
        return new Task.NotificationInfo(this.myErrorCount > 0 ? "Compiler (errors)" : "Compiler (success)", "Compilation Finished", this.myErrorCount + " Errors, " + this.myWarningCount + " Warnings", true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run(@NotNull ProgressIndicator indicator) {
        if (indicator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/compiler/progress/CompilerTask", "run"));
        }
        this.myIndicator = indicator;
        ProjectManager projectManager = ProjectManager.getInstance();
        this.myCloseListener = new CloseListener();
        projectManager.addProjectManagerListener(this.myProject, (ProjectManagerListener)this.myCloseListener);
        Semaphore semaphore = ((CompilerManagerImpl)CompilerManager.getInstance((Project)this.myProject)).getCompilationSemaphore();
        boolean acquired = false;
        while (true) {
            try {
                if (acquired) break;
                acquired = semaphore.tryAcquire(300L, TimeUnit.MILLISECONDS);
                if (acquired || this.myWaitForPreviousSession) continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
                break;
            }
            catch (ProcessCanceledException processCanceledException) {
                try {
                    indicator.stop();
                    projectManager.removeProjectManagerListener(this.myProject, (ProjectManagerListener)this.myCloseListener);
                    return;
                }
                finally {
                    if (acquired) {
                        semaphore.release();
                    }
                }
                catch (Throwable throwable) {
                    try {
                        indicator.stop();
                        projectManager.removeProjectManagerListener(this.myProject, (ProjectManagerListener)this.myCloseListener);
                        throw throwable;
                    }
                    finally {
                        if (acquired) {
                            semaphore.release();
                        }
                    }
                }
            }
            try {
                indicator.stop();
                projectManager.removeProjectManagerListener(this.myProject, (ProjectManagerListener)this.myCloseListener);
                return;
            }
            finally {
                if (acquired) {
                    semaphore.release();
                }
            }
            {
                if (!indicator.isCanceled()) continue;
            }
            break;
        }
        if (!this.isHeadless()) {
            this.addIndicatorDelegate();
        }
        this.myCompileWork.run();
        try {
            indicator.stop();
            projectManager.removeProjectManagerListener(this.myProject, (ProjectManagerListener)this.myCloseListener);
            return;
        }
        finally {
            if (acquired) {
                semaphore.release();
            }
        }
    }

    private void prepareMessageView() {
        if (!this.myIndicator.isRunning()) {
            return;
        }
        if (this.myMessageViewWasPrepared.getAndSet(true)) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Project project2 = CompilerTask.this.myProject;
                if (project2 == null || project2.isDisposed()) {
                    return;
                }
                Object object = CompilerTask.this.myMessageViewLock;
                synchronized (object) {
                    if (CompilerTask.this.myErrorTreeView == null) {
                        CompilerTask.this.removeAllContents(project2, null);
                    }
                }
            }
        });
    }

    private void addIndicatorDelegate() {
        ProgressIndicator indicator = this.myIndicator;
        if (!(indicator instanceof ProgressIndicatorEx)) {
            return;
        }
        ((ProgressIndicatorEx)indicator).addStateDelegate(new AbstractProgressIndicatorExBase(){

            @Override
            public void cancel() {
                super.cancel();
                this.selectFirstMessage();
                this.stopAppIconProgress();
            }

            @Override
            public void stop() {
                super.stop();
                if (!this.isCanceled()) {
                    this.selectFirstMessage();
                }
                this.stopAppIconProgress();
            }

            private void selectFirstMessage() {
                if (!CompilerTask.this.isHeadlessMode()) {
                    SwingUtilities.invokeLater(new Runnable(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        @Override
                        public void run() {
                            if (CompilerTask.this.myProject != null && CompilerTask.this.myProject.isDisposed()) {
                                return;
                            }
                            Object object = CompilerTask.this.myMessageViewLock;
                            synchronized (object) {
                                if (CompilerTask.this.myErrorTreeView != null) {
                                    CompilerTask.this.myErrorTreeView.selectFirstMessage();
                                }
                            }
                        }
                    });
                }
            }

            private void stopAppIconProgress() {
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        if (CompilerTask.this.myProject != null && CompilerTask.this.myProject.isDisposed()) {
                            return;
                        }
                        AppIcon appIcon = AppIcon.getInstance();
                        if (appIcon.hideProgress(CompilerTask.this.myProject, CompilerTask.APP_ICON_ID)) {
                            if (CompilerTask.this.myErrorCount > 0) {
                                appIcon.setErrorBadge(CompilerTask.this.myProject, String.valueOf(CompilerTask.this.myErrorCount));
                                appIcon.requestAttention(CompilerTask.this.myProject, true);
                            } else if (!CompilerTask.this.myCompilationStartedAutomatically) {
                                appIcon.setOkBadge(CompilerTask.this.myProject, true);
                                appIcon.requestAttention(CompilerTask.this.myProject, false);
                            }
                        }
                    }
                });
            }

            @Override
            public void setText(String text) {
                super.setText(text);
                CompilerTask.this.updateProgressText();
            }

            @Override
            public void setText2(String text) {
                super.setText2(text);
                CompilerTask.this.updateProgressText();
            }

            @Override
            public void setFraction(final double fraction) {
                super.setFraction(fraction);
                CompilerTask.this.updateProgressText();
                UIUtil.invokeLaterIfNeeded((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AppIcon.getInstance().setProgress(CompilerTask.this.myProject, CompilerTask.APP_ICON_ID, AppIconScheme.Progress.BUILD, fraction, true);
                    }
                });
            }

            @Override
            protected void onProgressChange() {
                CompilerTask.this.prepareMessageView();
            }
        });
    }

    public void cancel() {
        if (!this.myIndicator.isCanceled()) {
            this.myIndicator.cancel();
        }
    }

    public void addMessage(final CompilerMessage message) {
        this.prepareMessageView();
        CompilerMessageCategory messageCategory = message.getCategory();
        if (CompilerMessageCategory.WARNING.equals((Object)messageCategory)) {
            ++this.myWarningCount;
        } else if (CompilerMessageCategory.ERROR.equals((Object)messageCategory)) {
            ++this.myErrorCount;
            this.informWolf(message);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            this.openMessageView();
            this.doAddMessage(message);
        } else {
            Window window = this.getWindow();
            ModalityState modalityState = window != null ? ModalityState.stateForComponent((Component)window) : ModalityState.NON_MODAL;
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (CompilerTask.this.myProject != null && !CompilerTask.this.myProject.isDisposed()) {
                        CompilerTask.this.openMessageView();
                        CompilerTask.this.doAddMessage(message);
                    }
                }
            }, modalityState);
        }
    }

    private void informWolf(CompilerMessage message) {
        WolfTheProblemSolver wolf = WolfTheProblemSolver.getInstance((Project)this.myProject);
        VirtualFile file2 = CompilerTask.getVirtualFile(message);
        wolf.queue(file2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doAddMessage(CompilerMessage message) {
        Object object = this.myMessageViewLock;
        synchronized (object) {
            if (this.myErrorTreeView != null) {
                boolean shouldAutoActivate;
                Navigatable navigatable = message.getNavigatable();
                VirtualFile file2 = message.getVirtualFile();
                CompilerMessageCategory category = message.getCategory();
                int type = CompilerTask.translateCategory(category);
                String[] text = CompilerTask.convertMessage(message);
                if (navigatable != null) {
                    String groupName = file2 != null ? file2.getPresentableUrl() : category.getPresentableText();
                    this.myErrorTreeView.addMessage(type, text, groupName, navigatable, message.getExportTextPrefix(), message.getRenderTextPrefix(), (Object)message.getVirtualFile());
                } else {
                    this.myErrorTreeView.addMessage(type, text, file2, -1, -1, message.getVirtualFile());
                }
                boolean bl = shouldAutoActivate = !this.myMessagesAutoActivated && (CompilerMessageCategory.ERROR.equals((Object)category) || CompilerMessageCategory.WARNING.equals((Object)category) && !ErrorTreeViewConfiguration.getInstance(this.myProject).isHideWarnings());
                if (shouldAutoActivate) {
                    this.myMessagesAutoActivated = true;
                    this.activateMessageView();
                }
            }
        }
    }

    private static String[] convertMessage(CompilerMessage message) {
        String text = message.getMessage();
        if (!text.contains("\n")) {
            return new String[]{text};
        }
        ArrayList<String> lines = new ArrayList<String>();
        StringTokenizer tokenizer = new StringTokenizer(text, "\n", false);
        while (tokenizer.hasMoreTokens()) {
            lines.add(tokenizer.nextToken());
        }
        return ArrayUtil.toStringArray(lines);
    }

    public static int translateCategory(CompilerMessageCategory category) {
        if (CompilerMessageCategory.ERROR.equals((Object)category)) {
            return 4;
        }
        if (CompilerMessageCategory.WARNING.equals((Object)category)) {
            return 5;
        }
        if (CompilerMessageCategory.STATISTICS.equals((Object)category)) {
            return 2;
        }
        if (CompilerMessageCategory.INFORMATION.equals((Object)category)) {
            return 3;
        }
        LOG.error("Unknown message category: " + category);
        return 0;
    }

    public void start(Runnable compileWork, Runnable restartWork) {
        this.myCompileWork = compileWork;
        this.myRestartWork = restartWork;
        this.queue();
    }

    private void updateProgressText() {
        if (this.isHeadlessMode()) {
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void openMessageView() {
        JComponent component;
        if (this.isHeadlessMode()) {
            return;
        }
        if (this.myIndicator.isCanceled()) {
            return;
        }
        Object object = this.myMessageViewLock;
        synchronized (object) {
            if (this.myErrorTreeView != null) {
                return;
            }
            this.myErrorTreeView = new CompilerErrorTreeView(this.myProject, this.myRestartWork);
            this.myErrorTreeView.setProcessController(new NewErrorTreeViewPanel.ProcessController(){

                @Override
                public void stopProcess() {
                    CompilerTask.this.cancel();
                }

                @Override
                public boolean isProcessStopped() {
                    return !CompilerTask.this.myIndicator.isRunning();
                }
            });
            component = this.myErrorTreeView.getComponent();
        }
        MessageView messageView = MessageView.SERVICE.getInstance(this.myProject);
        Content content = ContentFactory.SERVICE.getInstance().createContent(component, this.myContentName, true);
        CONTENT_ID_KEY.set((UserDataHolder)content, this.myContentId);
        SESSION_ID_KEY.set((UserDataHolder)content, this.mySessionId);
        messageView.getContentManager().addContent(content);
        this.myCloseListener.setContent(content, messageView.getContentManager());
        this.removeAllContents(this.myProject, content);
        messageView.getContentManager().setSelectedContent(content);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showCompilerContent() {
        Object object = this.myMessageViewLock;
        synchronized (object) {
            if (this.myErrorTreeView != null) {
                CompilerTask.showCompilerContent(this.myProject, this.myContentId);
            }
        }
    }

    public static boolean showCompilerContent(Project project2, Object contentId) {
        MessageView messageView = MessageView.SERVICE.getInstance(project2);
        for (Content content : messageView.getContentManager().getContents()) {
            if (CONTENT_ID_KEY.get((UserDataHolder)content) != contentId) continue;
            messageView.getContentManager().setSelectedContent(content);
            return true;
        }
        return false;
    }

    private void removeAllContents(Project project2, Content notRemove) {
        Content[] contents;
        if (project2.isDisposed()) {
            return;
        }
        MessageView messageView = MessageView.SERVICE.getInstance(project2);
        for (Content content : contents = messageView.getContentManager().getContents()) {
            boolean toRemove;
            if (content.isPinned() || content == notRemove) continue;
            boolean bl = toRemove = CONTENT_ID_KEY.get((UserDataHolder)content) == this.myContentId;
            if (!toRemove) {
                Object contentSessionId = SESSION_ID_KEY.get((UserDataHolder)content);
                boolean bl2 = toRemove = contentSessionId != null && contentSessionId != this.mySessionId;
            }
            if (!toRemove) continue;
            messageView.getContentManager().removeContent(content, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void activateMessageView() {
        Object object = this.myMessageViewLock;
        synchronized (object) {
            ToolWindow tw;
            if (this.myErrorTreeView != null && this.myProject != null && (tw = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(ToolWindowId.MESSAGES_WINDOW)) != null) {
                tw.activate(null, false);
            }
        }
    }

    public Window getWindow() {
        return null;
    }

    public boolean isHeadless() {
        return this.myHeadlessMode && !this.myForceAsyncExecution;
    }

    private boolean isHeadlessMode() {
        return this.myHeadlessMode;
    }

    private static VirtualFile getVirtualFile(CompilerMessage message) {
        Navigatable navigatable;
        VirtualFile virtualFile = message.getVirtualFile();
        if (virtualFile == null && (navigatable = message.getNavigatable()) instanceof OpenFileDescriptor) {
            virtualFile = ((OpenFileDescriptor)navigatable).getFile();
        }
        return virtualFile;
    }

    public static TextRange getTextRange(CompilerMessage message) {
        Navigatable navigatable = message.getNavigatable();
        if (navigatable instanceof OpenFileDescriptor) {
            int offset = ((OpenFileDescriptor)navigatable).getOffset();
            return new TextRange(offset, offset);
        }
        return TextRange.EMPTY_RANGE;
    }

    public static final class IDObject {
        private final String myDisplayName;

        public IDObject(@NotNull String displayName) {
            if (displayName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "displayName", "com/intellij/compiler/progress/CompilerTask$IDObject", "<init>"));
            }
            this.myDisplayName = displayName;
        }

        public String toString() {
            return this.myDisplayName;
        }
    }

    private class CloseListener
    extends ContentManagerAdapter
    implements ProjectManagerListener {
        private Content myContent;
        private ContentManager myContentManager;
        private boolean myIsApplicationExitingOrProjectClosing = false;
        private boolean myUserAcceptedCancel = false;

        private CloseListener() {
        }

        public boolean canCloseProject(Project project2) {
            if (project2 != null && project2.equals(CompilerTask.this.myProject)) {
                CompilerTask.this.cancel();
            }
            return true;
        }

        public void setContent(Content content, ContentManager contentManager) {
            this.myContent = content;
            this.myContentManager = contentManager;
            contentManager.addContentManagerListener((ContentManagerListener)this);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void contentRemoved(ContentManagerEvent event) {
            if (event.getContent() == this.myContent) {
                Object object = CompilerTask.this.myMessageViewLock;
                synchronized (object) {
                    if (CompilerTask.this.myErrorTreeView != null) {
                        Disposer.dispose((Disposable)CompilerTask.this.myErrorTreeView);
                        CompilerTask.this.myErrorTreeView = null;
                        if (CompilerTask.this.myIndicator.isRunning()) {
                            CompilerTask.this.cancel();
                        }
                        if (AppIcon.getInstance().hideProgress(CompilerTask.this.myProject, CompilerTask.APP_ICON_ID)) {
                            AppIcon.getInstance().setErrorBadge(CompilerTask.this.myProject, null);
                        }
                    }
                }
                this.myContentManager.removeContentManagerListener((ContentManagerListener)this);
                this.myContent.release();
                this.myContent = null;
            }
        }

        public void contentRemoveQuery(ContentManagerEvent event) {
            if (event.getContent() == this.myContent && !CompilerTask.this.myIndicator.isCanceled() && this.shouldAskUser()) {
                int result = Messages.showOkCancelDialog((Project)CompilerTask.this.myProject, (String)CompilerBundle.message((String)"warning.compiler.running.on.toolwindow.close", (Object[])new Object[0]), (String)CompilerBundle.message((String)"compiler.running.dialog.title", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon());
                if (result != 0) {
                    event.consume();
                }
                this.myUserAcceptedCancel = true;
            }
        }

        private boolean shouldAskUser() {
            return !this.myUserAcceptedCancel && !this.myIsApplicationExitingOrProjectClosing && CompilerTask.this.myIndicator.isRunning();
        }

        public void projectOpened(Project project2) {
        }

        public void projectClosed(Project project2) {
            if (project2.equals(CompilerTask.this.myProject) && this.myContent != null) {
                this.myContentManager.removeContent(this.myContent, true);
            }
        }

        public void projectClosing(Project project2) {
            if (project2.equals(CompilerTask.this.myProject)) {
                this.myIsApplicationExitingOrProjectClosing = true;
            }
        }
    }
}

