/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.SourcePositionProvider;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;

public class EditSourceAction
extends DebuggerAction {
    public void actionPerformed(AnActionEvent e) {
        DebuggerContextImpl debuggerContext;
        DebugProcessImpl process;
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        if (project2 == null) {
            return;
        }
        final DebuggerTreeNodeImpl selectedNode = EditSourceAction.getSelectedNode(e.getDataContext());
        if (selectedNode != null && (process = (debuggerContext = EditSourceAction.getDebuggerContext(e.getDataContext())).getDebugProcess()) != null) {
            process.getManagerThread().schedule(new DebuggerContextCommandImpl(debuggerContext){

                @Override
                public void threadAction() {
                    SourcePosition sourcePosition = EditSourceAction.getSourcePosition(selectedNode, debuggerContext);
                    if (sourcePosition != null) {
                        sourcePosition.navigate(true);
                    }
                }
            });
        }
    }

    private static SourcePosition getSourcePosition(DebuggerTreeNodeImpl selectedNode, DebuggerContextImpl debuggerContext) {
        final DebuggerContextImpl context = debuggerContext;
        if (selectedNode == null || context == null) {
            return null;
        }
        final Project project2 = selectedNode.getProject();
        DebuggerSession debuggerSession = context.getDebuggerSession();
        if (debuggerSession == null) {
            return null;
        }
        NodeDescriptorImpl nodeDescriptor = selectedNode.getDescriptor();
        if (nodeDescriptor instanceof WatchItemDescriptor) {
            Modifier modifier = ((WatchItemDescriptor)nodeDescriptor).getModifier();
            if (modifier == null) {
                return null;
            }
            nodeDescriptor = (NodeDescriptorImpl)modifier.getInspectItem(project2);
        }
        final NodeDescriptorImpl nodeDescriptor1 = nodeDescriptor;
        return (SourcePosition)ApplicationManager.getApplication().runReadAction((Computable)new Computable<SourcePosition>(){

            public SourcePosition compute() {
                return SourcePositionProvider.getSourcePosition(nodeDescriptor1, project2, context);
            }
        });
    }

    public void update(AnActionEvent e) {
        final Project project2 = (Project)CommonDataKeys.PROJECT.getData(e.getDataContext());
        final DebuggerContextImpl debuggerContext = EditSourceAction.getDebuggerContext(e.getDataContext());
        final DebuggerTreeNodeImpl node = EditSourceAction.getSelectedNode(e.getDataContext());
        final Presentation presentation = e.getPresentation();
        if (debuggerContext.getDebugProcess() != null) {
            presentation.setEnabled(true);
            debuggerContext.getDebugProcess().getManagerThread().schedule(new DebuggerContextCommandImpl(debuggerContext){

                @Override
                public void threadAction() {
                    SourcePosition position = EditSourceAction.getSourcePosition(node, debuggerContext);
                    if (position == null) {
                        DebuggerInvocationUtil.swingInvokeLater(project2, new Runnable(){

                            @Override
                            public void run() {
                                presentation.setEnabled(false);
                            }
                        });
                    }
                }
            });
        } else {
            presentation.setEnabled(false);
        }
        e.getPresentation().setText(ActionManager.getInstance().getAction("EditSource").getTemplatePresentation().getText());
    }
}

