/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.actions.PopFrameAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaStackFrame;
import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.idea.ActionsBundle;
import com.intellij.openapi.actionSystem.ActionPlaces;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.intellij.xdebugger.impl.ui.XDebuggerExpressionEditor;
import com.sun.jdi.Method;
import com.sun.jdi.Value;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForceEarlyReturnAction
extends DebuggerAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/actions/ForceEarlyReturnAction", "actionPerformed"));
        }
        final Project project2 = e.getProject();
        final JavaStackFrame stackFrame = PopFrameAction.getStackFrame(e);
        if (stackFrame == null || project2 == null) {
            return;
        }
        DebuggerContextImpl debuggerContext = DebuggerAction.getDebuggerContext(e.getDataContext());
        final DebugProcessImpl debugProcess = debuggerContext.getDebugProcess();
        if (debugProcess == null) {
            return;
        }
        final StackFrameProxyImpl proxy = stackFrame.getStackFrameProxy();
        final ThreadReferenceProxyImpl thread = proxy.threadProxy();
        debugProcess.getManagerThread().schedule(new DebuggerContextCommandImpl(debuggerContext, thread){

            @Override
            public void threadAction() {
                Method method;
                try {
                    method = proxy.location().method();
                }
                catch (EvaluateException e) {
                    ForceEarlyReturnAction.showError(project2, DebuggerBundle.message((String)"error.early.return", (Object[])new Object[]{e.getLocalizedMessage()}));
                    return;
                }
                if ("void".equals(method.returnTypeName())) {
                    ForceEarlyReturnAction.forceEarlyReturnWithFinally(thread.getVirtualMachine().mirrorOfVoid(), stackFrame, debugProcess, null);
                } else {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            new ReturnExpressionDialog(project2, debugProcess.getXdebugProcess().getEditorsProvider(), debugProcess, stackFrame).show();
                        }
                    });
                }
            }
        });
    }

    private static void forceEarlyReturnWithFinally(final Value value, final JavaStackFrame frame, final DebugProcessImpl debugProcess, final @Nullable DialogWrapper dialog) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (PopFrameAction.evaluateFinallyBlocks(debugProcess.getProject(), UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"Debugger.ForceEarlyReturn")), frame, new XDebuggerEvaluator.XEvaluationCallback(){

                    public void evaluated(@NotNull XValue result) {
                        if (result == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/debugger/actions/ForceEarlyReturnAction$2$1", "evaluated"));
                        }
                        ForceEarlyReturnAction.forceEarlyReturn(value, frame.getDescriptor().getFrameProxy().threadProxy(), debugProcess, dialog);
                    }

                    public void errorOccurred(@NotNull String errorMessage) {
                        if (errorMessage == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/debugger/actions/ForceEarlyReturnAction$2$1", "errorOccurred"));
                        }
                        ForceEarlyReturnAction.showError(debugProcess.getProject(), DebuggerBundle.message((String)"error.executing.finally", (Object[])new Object[]{errorMessage}));
                    }
                })) {
                    return;
                }
                ForceEarlyReturnAction.forceEarlyReturn(value, frame.getDescriptor().getFrameProxy().threadProxy(), debugProcess, dialog);
            }
        });
    }

    private static void forceEarlyReturn(final Value value, final ThreadReferenceProxyImpl thread, final DebugProcessImpl debugProcess, final @Nullable DialogWrapper dialog) {
        debugProcess.getManagerThread().schedule(new DebuggerCommandImpl(){

            @Override
            protected void action() throws Exception {
                try {
                    thread.forceEarlyReturn(value);
                }
                catch (Exception e) {
                    ForceEarlyReturnAction.showError(debugProcess.getProject(), DebuggerBundle.message((String)"error.early.return", (Object[])new Object[]{e.getLocalizedMessage()}));
                    return;
                }
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (dialog != null) {
                            dialog.close(0);
                        }
                        debugProcess.getSession().stepInto(true, null);
                    }
                });
            }
        });
    }

    private static void evaluateAndReturn(final Project project2, final JavaStackFrame stackFrame, final DebugProcessImpl debugProcess, XExpression expression, final DialogWrapper dialog) {
        XDebuggerEvaluator evaluator = stackFrame.getEvaluator();
        if (evaluator != null) {
            evaluator.evaluate(expression, new XDebuggerEvaluator.XEvaluationCallback(){

                public void evaluated(@NotNull XValue result) {
                    if (result == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/debugger/actions/ForceEarlyReturnAction$4", "evaluated"));
                    }
                    if (result instanceof JavaValue) {
                        ForceEarlyReturnAction.forceEarlyReturnWithFinally(((JavaValue)result).getDescriptor().getValue(), stackFrame, debugProcess, dialog);
                    }
                }

                public void errorOccurred(@NotNull String errorMessage) {
                    if (errorMessage == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "errorMessage", "com/intellij/debugger/actions/ForceEarlyReturnAction$4", "errorOccurred"));
                    }
                    ForceEarlyReturnAction.showError(project2, DebuggerBundle.message((String)"error.unable.to.evaluate.expression", (Object[])new Object[0]) + ": " + errorMessage);
                }
            }, stackFrame.getSourcePosition());
        } else {
            ForceEarlyReturnAction.showError(project2, XDebuggerBundle.message((String)"xdebugger.evaluate.stack.frame.has.not.evaluator", (Object[])new Object[0]));
        }
    }

    private static void showError(final Project project2, final String message) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                Messages.showMessageDialog((Project)project2, (String)message, (String)UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"Debugger.ForceEarlyReturn")), (Icon)Messages.getErrorIcon());
            }
        }, ModalityState.any());
    }

    public void update(@NotNull AnActionEvent e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/debugger/actions/ForceEarlyReturnAction", "update"));
        }
        boolean enable = false;
        JavaStackFrame stackFrame = PopFrameAction.getStackFrame(e);
        if (stackFrame != null && stackFrame.getDescriptor().getUiIndex() == 0) {
            enable = stackFrame.getStackFrameProxy().getVirtualMachine().canForceEarlyReturn();
        }
        if (ActionPlaces.isMainMenuOrActionSearch((String)e.getPlace()) || "DebuggerToolbar".equals(e.getPlace())) {
            e.getPresentation().setEnabled(enable);
        } else {
            e.getPresentation().setVisible(enable);
        }
    }

    private static class ReturnExpressionDialog
    extends DialogWrapper {
        private final Project myProject;
        private final XDebuggerEditorsProvider myEditorsProvider;
        private final DebugProcessImpl myProcess;
        private final JavaStackFrame myFrame;
        private final XDebuggerExpressionEditor myEditor;

        public ReturnExpressionDialog(@NotNull Project project2, XDebuggerEditorsProvider provider, DebugProcessImpl process, JavaStackFrame frame) {
            if (project2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/actions/ForceEarlyReturnAction$ReturnExpressionDialog", "<init>"));
            }
            super(project2);
            this.myProject = project2;
            this.myEditorsProvider = provider;
            this.myProcess = process;
            this.myFrame = frame;
            this.myEditor = new XDebuggerExpressionEditor(this.myProject, this.myEditorsProvider, "forceReturnValue", this.myFrame.getSourcePosition(), XExpressionImpl.EMPTY_EXPRESSION, false);
            this.setTitle("Return Value");
            this.init();
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return this.myEditor.getComponent();
        }

        @Nullable
        public JComponent getPreferredFocusedComponent() {
            return this.myEditor.getPreferredFocusedComponent();
        }

        protected void doOKAction() {
            ForceEarlyReturnAction.evaluateAndReturn(this.myProject, this.myFrame, this.myProcess, this.myEditor.getExpression(), this);
        }
    }
}

