/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.ui.StateRestoringCheckBox;
import com.intellij.ui.components.panels.VerticalBox;
import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;

class DebuggerLaunchingConfigurable
implements ConfigurableUi<DebuggerSettings> {
    private JRadioButton myRbSocket;
    private JRadioButton myRbShmem;
    private StateRestoringCheckBox myCbForceClassicVM;
    private JCheckBox myCbDisableJIT;
    private JCheckBox myCbShowAlternativeSource;

    DebuggerLaunchingConfigurable() {
    }

    public void reset(@NotNull DebuggerSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/debugger/settings/DebuggerLaunchingConfigurable", "reset"));
        }
        if (!SystemInfo.isWindows) {
            this.myRbSocket.setSelected(true);
            this.myRbShmem.setEnabled(false);
        } else {
            if (settings.DEBUGGER_TRANSPORT == 1) {
                this.myRbShmem.setSelected(true);
            } else {
                this.myRbSocket.setSelected(true);
            }
            this.myRbShmem.setEnabled(true);
        }
        this.myCbForceClassicVM.setSelected(settings.FORCE_CLASSIC_VM);
        this.myCbDisableJIT.setSelected(settings.DISABLE_JIT);
        this.myCbShowAlternativeSource.setSelected(settings.SHOW_ALTERNATIVE_SOURCE);
    }

    public void apply(@NotNull DebuggerSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/debugger/settings/DebuggerLaunchingConfigurable", "apply"));
        }
        this.getSettingsTo(settings);
    }

    private void getSettingsTo(DebuggerSettings settings) {
        settings.DEBUGGER_TRANSPORT = this.myRbShmem.isSelected() ? 1 : 0;
        settings.FORCE_CLASSIC_VM = this.myCbForceClassicVM.isSelectedWhenSelectable();
        settings.DISABLE_JIT = this.myCbDisableJIT.isSelected();
        settings.SHOW_ALTERNATIVE_SOURCE = this.myCbShowAlternativeSource.isSelected();
    }

    public boolean isModified(@NotNull DebuggerSettings currentSettings) {
        if (currentSettings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "currentSettings", "com/intellij/debugger/settings/DebuggerLaunchingConfigurable", "isModified"));
        }
        DebuggerSettings debuggerSettings = currentSettings.clone();
        this.getSettingsTo(debuggerSettings);
        return !debuggerSettings.equals(currentSettings);
    }

    @NotNull
    public JComponent getComponent() {
        this.myCbForceClassicVM = new StateRestoringCheckBox(DebuggerBundle.message((String)"label.debugger.launching.configurable.force.classic.vm", (Object[])new Object[0]));
        this.myCbDisableJIT = new JCheckBox(DebuggerBundle.message((String)"label.debugger.launching.configurable.disable.jit", (Object[])new Object[0]));
        this.myCbShowAlternativeSource = new JCheckBox(DebuggerBundle.message((String)"label.debugger.general.configurable.show.alternative.source", (Object[])new Object[0]));
        this.myRbSocket = new JRadioButton(DebuggerBundle.message((String)"label.debugger.launching.configurable.socket", (Object[])new Object[0]));
        this.myRbShmem = new JRadioButton(DebuggerBundle.message((String)"label.debugger.launching.configurable.shmem", (Object[])new Object[0]));
        ButtonGroup gr = new ButtonGroup();
        gr.add(this.myRbSocket);
        gr.add(this.myRbShmem);
        Box box = Box.createHorizontalBox();
        box.add(this.myRbSocket);
        box.add(this.myRbShmem);
        JPanel transportPanel = new JPanel(new BorderLayout());
        transportPanel.add((Component)new JLabel(DebuggerBundle.message((String)"label.debugger.launching.configurable.debugger.transport", (Object[])new Object[0])), "West");
        transportPanel.add((Component)box, "Center");
        VerticalBox panel = new VerticalBox();
        panel.setOpaque(false);
        panel.add((Component)transportPanel);
        panel.add((Component)this.myCbForceClassicVM);
        panel.add((Component)this.myCbDisableJIT);
        panel.add((Component)this.myCbShowAlternativeSource);
        JPanel result = new JPanel(new BorderLayout());
        result.add((Component)panel, "North");
        JPanel jPanel = result;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/settings/DebuggerLaunchingConfigurable", "getComponent"));
        }
        return jPanel;
    }
}

