/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.EditorTextProvider;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.ui.DebuggerTreeCreatorImpl;
import com.intellij.debugger.ui.impl.DebuggerTreeRenderer;
import com.intellij.debugger.ui.impl.InspectDebuggerTree;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JVMElementFactory;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xdebugger.impl.evaluate.quick.common.AbstractValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import com.sun.jdi.Method;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Value;
import java.awt.Point;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.Nullable;

public class ValueHint
extends AbstractValueHint {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.debugger.ui.ValueHint");
    private PsiElement myCurrentExpression = null;
    private Value myValueToShow = null;

    private ValueHint(Project project2, Editor editor, Point point, ValueHintType type, PsiElement selectedExpression, TextRange textRange) {
        super(project2, editor, point, type, textRange);
        this.myCurrentExpression = selectedExpression;
    }

    public static ValueHint createValueHint(Project project2, Editor editor, Point point, ValueHintType type) {
        Trinity<PsiElement, TextRange, Value> trinity = ValueHint.getSelectedExpression(project2, editor, point, type);
        ValueHint hint = new ValueHint(project2, editor, point, type, (PsiElement)trinity.getFirst(), (TextRange)trinity.getSecond());
        hint.myValueToShow = (Value)trinity.getThird();
        return hint;
    }

    @Override
    protected boolean canShowHint() {
        return this.myCurrentExpression != null;
    }

    @Nullable
    private ExpressionEvaluator getExpressionEvaluator(DebuggerContextImpl debuggerContext) throws EvaluateException {
        if (this.myCurrentExpression instanceof PsiExpression) {
            return EvaluatorBuilderImpl.getInstance().build(this.myCurrentExpression, debuggerContext.getSourcePosition());
        }
        TextWithImportsImpl textWithImports = new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, this.myCurrentExpression.getText());
        CodeFragmentFactory factory = DebuggerUtilsEx.findAppropriateCodeFragmentFactory(textWithImports, this.myCurrentExpression);
        JavaCodeFragment codeFragment = factory.createCodeFragment((TextWithImports)textWithImports, this.myCurrentExpression.getContext(), this.getProject());
        codeFragment.forceResolveScope(GlobalSearchScope.allScope((Project)this.getProject()));
        return factory.getEvaluatorBuilder().build((PsiElement)codeFragment, debuggerContext.getSourcePosition());
    }

    @Override
    protected void evaluateAndShowHint() {
        final DebuggerContextImpl debuggerContext = DebuggerManagerEx.getInstanceEx(this.getProject()).getContext();
        DebuggerSession debuggerSession = debuggerContext.getDebuggerSession();
        if (debuggerSession == null || !debuggerSession.isPaused()) {
            return;
        }
        try {
            final ExpressionEvaluator evaluator = this.getExpressionEvaluator(debuggerContext);
            if (evaluator == null) {
                return;
            }
            debuggerContext.getDebugProcess().getManagerThread().schedule(new DebuggerContextCommandImpl(debuggerContext){

                @Override
                public PrioritizedTask.Priority getPriority() {
                    return PrioritizedTask.Priority.HIGH;
                }

                @Override
                public void threadAction() {
                    try {
                        EvaluationContextImpl evaluationContext = debuggerContext.createEvaluationContext();
                        String expressionText = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                            public String compute() {
                                return ValueHint.this.myCurrentExpression.getText();
                            }
                        });
                        TextWithImportsImpl text = new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, expressionText);
                        final Value value = ValueHint.this.myValueToShow != null ? ValueHint.this.myValueToShow : evaluator.evaluate((EvaluationContext)evaluationContext);
                        final WatchItemDescriptor descriptor = new WatchItemDescriptor(ValueHint.this.getProject(), (TextWithImports)text, value);
                        if (!ValueHint.isActiveTooltipApplicable(value) || ValueHint.this.getType() == ValueHintType.MOUSE_OVER_HINT) {
                            if (ValueHint.this.getType() == ValueHintType.MOUSE_OVER_HINT) {
                                descriptor.setRenderer(DebugProcessImpl.getDefaultRenderer(value));
                            }
                            descriptor.updateRepresentation(evaluationContext, new DescriptorLabelListener(){

                                @Override
                                public void labelChanged() {
                                    if (ValueHint.this.getCurrentRange() != null && (ValueHint.this.getType() != ValueHintType.MOUSE_OVER_HINT || descriptor.isValueValid())) {
                                        SimpleColoredText simpleColoredText = DebuggerTreeRenderer.getDescriptorText(debuggerContext, descriptor, true);
                                        if (ValueHint.isActiveTooltipApplicable(value)) {
                                            simpleColoredText.append(" (" + DebuggerBundle.message((String)"active.tooltip.suggestion", (Object[])new Object[0]) + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                                        }
                                        ValueHint.this.showHint(simpleColoredText, descriptor);
                                    }
                                }
                            });
                        } else {
                            ValueHint.this.createAndShowTree(expressionText, descriptor);
                        }
                    }
                    catch (EvaluateException e) {
                        LOG.debug((Throwable)e);
                    }
                }
            });
        }
        catch (EvaluateException e) {
            LOG.debug((Throwable)e);
        }
    }

    private void createAndShowTree(final String expressionText, final NodeDescriptorImpl descriptor) {
        final DebuggerTreeCreatorImpl creator = new DebuggerTreeCreatorImpl(this.getProject());
        DebuggerInvocationUtil.invokeLater(this.getProject(), new Runnable(){

            @Override
            public void run() {
                ValueHint.this.showTreePopup(creator, Pair.create((Object)descriptor, (Object)expressionText));
            }
        });
    }

    private static boolean isActiveTooltipApplicable(Value value) {
        return value != null && !(value instanceof PrimitiveValue);
    }

    private void showHint(final SimpleColoredText text, final WatchItemDescriptor descriptor) {
        DebuggerInvocationUtil.invokeLater(this.getProject(), new Runnable(){

            @Override
            public void run() {
                if (!ValueHint.this.isHintHidden()) {
                    JComponent component = !ValueHint.isActiveTooltipApplicable(descriptor.getValue()) ? HintUtil.createInformationLabel(text) : ValueHint.this.createExpandableHintComponent(text, new Runnable(){

                        @Override
                        public void run() {
                            DebuggerContextImpl debuggerContext = DebuggerManagerEx.getInstanceEx(ValueHint.this.getProject()).getContext();
                            final DebugProcessImpl debugProcess = debuggerContext.getDebugProcess();
                            debugProcess.getManagerThread().schedule(new DebuggerContextCommandImpl(debuggerContext){

                                @Override
                                public void threadAction() {
                                    descriptor.setRenderer(debugProcess.getAutoRenderer(descriptor));
                                    String expressionText = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                                        public String compute() {
                                            return ValueHint.this.myCurrentExpression.getText();
                                        }
                                    });
                                    ValueHint.this.createAndShowTree(expressionText, descriptor);
                                }
                            });
                        }
                    });
                    if (!ValueHint.this.showHint(component)) {
                        return;
                    }
                    if (ValueHint.this.getType() == ValueHintType.MOUSE_CLICK_HINT) {
                        HintUtil.createInformationLabel(text).requestFocusInWindow();
                    }
                }
            }
        });
    }

    public static InspectDebuggerTree createInspectTree(NodeDescriptorImpl descriptor, Project project2) {
        final InspectDebuggerTree tree = new InspectDebuggerTree(project2);
        final AnAction setValueAction = ActionManager.getInstance().getAction("Debugger.SetValue");
        setValueAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(113, 0)), (JComponent)((Object)tree));
        Disposer.register((Disposable)tree, (Disposable)new Disposable(){

            public void dispose() {
                setValueAction.unregisterCustomShortcutSet((JComponent)((Object)tree));
            }
        });
        tree.setInspectDescriptor(descriptor);
        DebuggerContextImpl context = DebuggerManagerEx.getInstanceEx(project2).getContext();
        tree.rebuild(context);
        return tree;
    }

    @Nullable
    private static Pair<PsiElement, TextRange> findExpression(PsiElement element, boolean allowMethodCalls) {
        EditorTextProvider textProvider = (EditorTextProvider)EditorTextProvider.EP.forLanguage(element.getLanguage());
        if (textProvider != null) {
            return textProvider.findExpression(element, allowMethodCalls);
        }
        return null;
    }

    private static Trinity<PsiElement, TextRange, Value> getSelectedExpression(final Project project2, final Editor editor, final Point point, final ValueHintType type) {
        final Ref selectedExpression = Ref.create(null);
        final Ref currentRange = Ref.create(null);
        final Ref preCalculatedValue = Ref.create(null);
        PsiDocumentManager.getInstance((Project)project2).commitAndRunReadAction(new Runnable(){

            @Override
            public void run() {
                int offset = AbstractValueHint.calculateOffset(editor, point);
                PsiFile psiFile = PsiDocumentManager.getInstance((Project)project2).getPsiFile(editor.getDocument());
                if (psiFile == null || !psiFile.isValid()) {
                    return;
                }
                int selectionStart = editor.getSelectionModel().getSelectionStart();
                int selectionEnd = editor.getSelectionModel().getSelectionEnd();
                if ((type == ValueHintType.MOUSE_CLICK_HINT || type == ValueHintType.MOUSE_ALT_OVER_HINT) && selectionStart <= offset && offset <= selectionEnd) {
                    PsiElement ctx = selectionStart > 0 ? psiFile.findElementAt(selectionStart - 1) : psiFile.findElementAt(selectionStart);
                    try {
                        String text = editor.getSelectionModel().getSelectedText();
                        if (text != null && ctx != null) {
                            JVMElementFactory factory = JVMElementFactories.getFactory((Language)ctx.getLanguage(), (Project)project2);
                            if (factory == null) {
                                return;
                            }
                            selectedExpression.set((Object)factory.createExpressionFromText(text, ctx));
                            currentRange.set((Object)new TextRange(editor.getSelectionModel().getSelectionStart(), editor.getSelectionModel().getSelectionEnd()));
                        }
                    }
                    catch (IncorrectOperationException text) {
                        // empty catch block
                    }
                }
                if (currentRange.get() == null) {
                    PsiMethodCallExpression methodCallExpression;
                    PsiMethod psiMethod;
                    Pair expressionPair;
                    Method method;
                    Pair<Method, Value> lastExecuted;
                    DebuggerSession debuggerSession;
                    PsiElement elementAtCursor = psiFile.findElementAt(offset);
                    if (elementAtCursor == null) {
                        return;
                    }
                    Pair pair = ValueHint.findExpression(elementAtCursor, type == ValueHintType.MOUSE_CLICK_HINT || type == ValueHintType.MOUSE_ALT_OVER_HINT);
                    if (pair == null && type == ValueHintType.MOUSE_OVER_HINT && (debuggerSession = DebuggerManagerEx.getInstanceEx(project2).getContext().getDebuggerSession()) != null && debuggerSession.isPaused() && (lastExecuted = debuggerSession.getProcess().getLastExecutedMethod()) != null && (method = (Method)lastExecuted.getFirst()) != null && (expressionPair = ValueHint.findExpression(elementAtCursor, true)) != null && expressionPair.getFirst() instanceof PsiMethodCallExpression && (psiMethod = (methodCallExpression = (PsiMethodCallExpression)expressionPair.getFirst()).resolveMethod()) != null) {
                        JVMName jvmSignature = JVMNameUtil.getJVMSignature(psiMethod);
                        try {
                            if (method.name().equals(psiMethod.getName()) && method.signature().equals(jvmSignature.getName(debuggerSession.getProcess()))) {
                                pair = expressionPair;
                                preCalculatedValue.set(lastExecuted.getSecond());
                            }
                        }
                        catch (EvaluateException evaluateException) {
                            // empty catch block
                        }
                    }
                    if (pair == null) {
                        return;
                    }
                    selectedExpression.set(pair.getFirst());
                    currentRange.set(pair.getSecond());
                }
            }
        });
        return Trinity.create((Object)selectedExpression.get(), (Object)currentRange.get(), (Object)preCalculatedValue.get());
    }
}

