/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ChildrenBuilder;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.NodeRendererImpl;
import com.intellij.psi.PsiExpression;
import com.sun.jdi.LongType;
import com.sun.jdi.LongValue;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import java.sql.Timestamp;

public class TimestampRenderer
extends NodeRendererImpl {
    @Override
    public String calcLabel(ValueDescriptor descriptor, EvaluationContext evaluationContext, DescriptorLabelListener listener2) throws EvaluateException {
        Value value = descriptor.getValue();
        if (value == null) {
            return "null";
        }
        if (value instanceof LongValue) {
            return new Timestamp(((LongValue)value).longValue()).toString();
        }
        return null;
    }

    @Override
    public void buildChildren(Value value, ChildrenBuilder builder, EvaluationContext evaluationContext) {
    }

    public PsiExpression getChildValueExpression(DebuggerTreeNode node, DebuggerContext context) throws EvaluateException {
        return null;
    }

    @Override
    public boolean isExpandable(Value value, EvaluationContext evaluationContext, NodeDescriptor parentDescriptor) {
        return false;
    }

    @Override
    public String getName() {
        return "Timestamp";
    }

    @Override
    public String getUniqueId() {
        return "TimestampRenderer";
    }

    @Override
    public boolean isApplicable(Type t) {
        return t instanceof LongType;
    }
}

