/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.tree.render;

import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.managerThread.SuspendContextCommand;
import com.sun.jdi.Value;

public abstract class ToStringCommand
implements SuspendContextCommand {
    private final EvaluationContext myEvaluationContext;
    private final Value myValue;
    private boolean myIsEvaluated = false;

    protected ToStringCommand(EvaluationContext evaluationContext, Value value) {
        this.myEvaluationContext = evaluationContext;
        this.myValue = value;
    }

    public void action() {
        if (this.myIsEvaluated) {
            return;
        }
        try {
            String valueAsString = DebuggerUtils.getValueAsString((EvaluationContext)this.myEvaluationContext, (Value)this.myValue);
            this.evaluationResult(valueAsString);
        }
        catch (EvaluateException ex) {
            this.evaluationError(ex.getMessage());
        }
    }

    public void commandCancelled() {
    }

    public void setEvaluated() {
        this.myIsEvaluated = true;
    }

    public SuspendContext getSuspendContext() {
        return this.myEvaluationContext.getSuspendContext();
    }

    public abstract void evaluationResult(String var1);

    public abstract void evaluationError(String var1);

    public Value getValue() {
        return this.myValue;
    }

    public EvaluationContext getEvaluationContext() {
        return this.myEvaluationContext;
    }
}

