/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.designSurface.selection;

import com.intellij.designer.designSurface.ComponentDecorator;
import com.intellij.designer.designSurface.DecorationLayer;
import com.intellij.designer.designSurface.tools.InputTool;
import com.intellij.designer.model.RadComponent;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;

public abstract class ResizePoint
extends ComponentDecorator {
    private static final int DEFAULT_SIZE = 5;
    private final Color myColor;
    private final Color myBorder;

    public ResizePoint() {
        this(Color.GREEN, Color.BLACK);
    }

    public ResizePoint(Color color, Color border) {
        this.myColor = color;
        this.myBorder = border;
    }

    @Override
    public InputTool findTargetTool(DecorationLayer layer, RadComponent component, int x, int y) {
        Point location = this.getLocation(layer, component);
        Rectangle bounds = new Rectangle(location.x, location.y, this.getSize(), this.getSize());
        int neighborhood = this.getNeighborhoodSize();
        if (neighborhood > 0) {
            bounds.grow(neighborhood, neighborhood);
        }
        if (bounds.contains(x, y)) {
            return this.createTool(component);
        }
        return null;
    }

    @Override
    protected void paint(DecorationLayer layer, Graphics2D g, RadComponent component) {
        Point location = this.getLocation(layer, component);
        g.setColor(this.myColor);
        g.fillRect(location.x, location.y, this.getSize(), this.getSize());
        g.setColor(this.myBorder);
        g.drawRect(location.x, location.y, this.getSize(), this.getSize());
    }

    public abstract Object getType();

    protected abstract InputTool createTool(RadComponent var1);

    protected abstract Point getLocation(DecorationLayer var1, RadComponent var2);

    protected int getSize() {
        return 5;
    }

    protected int getNeighborhoodSize() {
        return 0;
    }
}

