/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.propertyTable;

import com.intellij.designer.model.ErrorInfo;
import com.intellij.designer.model.PropertiesContainer;
import com.intellij.designer.model.Property;
import com.intellij.designer.model.PropertyContext;
import com.intellij.designer.propertyTable.PropertyEditor;
import com.intellij.designer.propertyTable.PropertyEditorListener;
import com.intellij.designer.propertyTable.PropertyRenderer;
import com.intellij.designer.propertyTable.renderers.LabelPropertyRenderer;
import com.intellij.ide.ui.search.SearchUtil;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ex.IdeFocusTraversalPolicy;
import com.intellij.ui.Cell;
import com.intellij.ui.ColoredTableCellRenderer;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.table.JBTable;
import com.intellij.util.PairFunction;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.AbstractCellEditor;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.plaf.TableUI;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PropertyTable
extends JBTable {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.designer.propertyTable.PropertyTable");
    private static final Comparator<String> GROUP_COMPARATOR = new Comparator<String>(){

        @Override
        public int compare(String o1, String o2) {
            return StringUtil.compare((String)o1, (String)o2, (boolean)true);
        }
    };
    private static final Comparator<Property> PROPERTY_COMPARATOR = new Comparator<Property>(){

        @Override
        public int compare(Property o1, Property o2) {
            return StringUtil.compare((String)o1.getName(), (String)o2.getName(), (boolean)true);
        }
    };
    private boolean mySorted;
    private boolean myShowGroups;
    private boolean myShowExpertProperties;
    private String[] myColumnNames = new String[]{"Property", "Value"};
    private final TableSpeedSearch mySpeedSearch;
    private final AbstractTableModel myModel = new PropertyTableModel();
    protected List<PropertiesContainer> myContainers = Collections.emptyList();
    protected List<Property> myProperties = Collections.emptyList();
    protected final Set<String> myExpandedProperties = new HashSet<String>();
    private boolean mySkipUpdate;
    private boolean myStoppingEditing;
    private final TableCellRenderer myCellRenderer = new PropertyCellRenderer();
    private final PropertyCellEditor myCellEditor = new PropertyCellEditor();
    private final PropertyEditorListener myPropertyEditorListener = new PropertyCellEditorListener();

    public PropertyTable() {
        this.setModel(this.myModel);
        this.setSelectionMode(0);
        this.setShowColumns(false);
        this.setAutoResizeMode(3);
        this.setShowVerticalLines(false);
        this.setIntercellSpacing(new Dimension(0, 1));
        this.setGridColor(UIUtil.getSlightlyDarkerColor((Color)this.getBackground()));
        this.setColumnSelectionAllowed(false);
        this.setCellSelectionEnabled(false);
        this.setRowSelectionAllowed(true);
        this.addMouseListener(new MouseTableListener());
        this.mySpeedSearch = new TableSpeedSearch((JTable)((Object)this), (PairFunction)new PairFunction<Object, Cell, String>(){

            public String fun(Object object, Cell cell) {
                if (cell.column != 0) {
                    return null;
                }
                if (object instanceof GroupProperty) {
                    return null;
                }
                return ((Property)object).getName();
            }
        }){

            @Override
            protected void selectElement(Object element, String selectedText) {
                super.selectElement(element, selectedText);
                PropertyTable.this.repaint(PropertyTable.this.getVisibleRect());
            }
        };
        this.mySpeedSearch.setComparator(new SpeedSearchComparator(false, false));
    }

    public void setColumnNames(String ... columnNames) {
        if (columnNames.length != 2) {
            throw new IllegalArgumentException("Invalid number of columns. Expected 2, got " + columnNames.length);
        }
        this.myColumnNames = columnNames;
        TableColumnModel mmodel = this.getColumnModel();
        for (int i = 0; i < columnNames.length; ++i) {
            mmodel.getColumn(i).setHeaderValue(columnNames[i]);
        }
    }

    public void setSorted(boolean sorted) {
        this.mySorted = sorted;
        this.update();
    }

    public boolean isSorted() {
        return this.mySorted;
    }

    public void setShowGroups(boolean showGroups) {
        this.myShowGroups = showGroups;
        this.update();
    }

    public boolean isShowGroups() {
        return this.myShowGroups;
    }

    public void showExpert(boolean showExpert) {
        this.myShowExpertProperties = showExpert;
        this.update();
    }

    public boolean isShowExpertProperties() {
        return this.myShowExpertProperties;
    }

    public void setUI(TableUI ui) {
        super.setUI(ui);
        ActionMap actionMap = this.getActionMap();
        this.setFocusTraversalKeys(0, KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(0));
        this.setFocusTraversalKeys(1, KeyboardFocusManager.getCurrentKeyboardFocusManager().getDefaultFocusTraversalKeys(1));
        InputMap focusedInputMap = this.getInputMap(0);
        InputMap ancestorInputMap = this.getInputMap(1);
        actionMap.put("selectPreviousRow", new MySelectNextPreviousRowAction(false));
        actionMap.put("selectNextRow", new MySelectNextPreviousRowAction(true));
        actionMap.put("startEditing", new MyStartEditingAction());
        focusedInputMap.put(KeyStroke.getKeyStroke(113, 0), "startEditing");
        ancestorInputMap.remove(KeyStroke.getKeyStroke(113, 0));
        actionMap.put("smartEnter", new MyEnterAction());
        focusedInputMap.put(KeyStroke.getKeyStroke(10, 0), "smartEnter");
        ancestorInputMap.remove(KeyStroke.getKeyStroke(10, 0));
        focusedInputMap.put(KeyStroke.getKeyStroke(27, 0), "cancel");
        ancestorInputMap.put(KeyStroke.getKeyStroke(27, 0), "cancel");
        actionMap.put("restoreDefault", new MyRestoreDefaultAction());
        focusedInputMap.put(KeyStroke.getKeyStroke(127, 0), "restoreDefault");
        ancestorInputMap.put(KeyStroke.getKeyStroke(127, 0), "restoreDefault");
        focusedInputMap.put(KeyStroke.getKeyStroke(8, 0), "restoreDefault");
        ancestorInputMap.put(KeyStroke.getKeyStroke(8, 0), "restoreDefault");
        actionMap.put("expandCurrent", new MyExpandCurrentAction(true, false));
        focusedInputMap.put(KeyStroke.getKeyStroke(107, 0), "expandCurrent");
        ancestorInputMap.remove(KeyStroke.getKeyStroke(107, 0));
        actionMap.put("expandCurrentRight", new MyExpandCurrentAction(true, true));
        focusedInputMap.put(KeyStroke.getKeyStroke(39, 0), "expandCurrentRight");
        ancestorInputMap.remove(KeyStroke.getKeyStroke(39, 0));
        focusedInputMap.put(KeyStroke.getKeyStroke(227, 0), "expandCurrentRight");
        ancestorInputMap.remove(KeyStroke.getKeyStroke(227, 0));
        actionMap.put("collapseCurrent", new MyExpandCurrentAction(false, false));
        focusedInputMap.put(KeyStroke.getKeyStroke(109, 0), "collapseCurrent");
        ancestorInputMap.remove(KeyStroke.getKeyStroke(109, 0));
        actionMap.put("collapseCurrentLeft", new MyExpandCurrentAction(false, true));
        focusedInputMap.put(KeyStroke.getKeyStroke(37, 0), "collapseCurrentLeft");
        ancestorInputMap.remove(KeyStroke.getKeyStroke(37, 0));
        focusedInputMap.put(KeyStroke.getKeyStroke(226, 0), "collapseCurrentLeft");
        ancestorInputMap.remove(KeyStroke.getKeyStroke(226, 0));
    }

    public TableCellRenderer getCellRenderer(int row, int column) {
        return this.myCellRenderer;
    }

    public void restoreDefaultValue() {
        final Property property = this.getSelectionProperty();
        if (property != null) {
            if (this.isEditing()) {
                this.cellEditor.stopCellEditing();
            }
            this.doRestoreDefault(new ThrowableRunnable<Exception>(){

                public void run() throws Exception {
                    for (PropertiesContainer component : PropertyTable.this.myContainers) {
                        if (property.isDefaultRecursively(component)) continue;
                        property.setDefaultValue(component);
                    }
                }
            });
            this.repaint();
        }
    }

    protected abstract boolean doRestoreDefault(ThrowableRunnable<Exception> var1);

    @Nullable
    public ErrorInfo getErrorInfoForRow(int row) {
        if (this.myContainers.size() != 1) {
            return null;
        }
        Property property = this.myProperties.get(row);
        if (property.getParent() != null) {
            return null;
        }
        for (ErrorInfo errorInfo : this.getErrors(this.myContainers.get(0))) {
            if (!property.getName().equals(errorInfo.getPropertyName())) continue;
            return errorInfo;
        }
        return null;
    }

    protected abstract List<ErrorInfo> getErrors(@NotNull PropertiesContainer var1);

    public String getToolTipText(MouseEvent event) {
        int row = this.rowAtPoint(event.getPoint());
        if (row != -1 && !this.myProperties.isEmpty()) {
            String tooltip;
            ErrorInfo errorInfo = this.getErrorInfoForRow(row);
            if (errorInfo != null) {
                return errorInfo.getName();
            }
            if (this.columnAtPoint(event.getPoint()) == 0 && (tooltip = this.myProperties.get(row).getTooltip()) != null) {
                return tooltip;
            }
        }
        return super.getToolTipText(event);
    }

    @Nullable
    protected PropertyContext getPropertyContext() {
        return null;
    }

    public void update() {
        this.update(this.myContainers, null);
    }

    public void update(@NotNull List<? extends PropertiesContainer> containers, @Nullable Property initialSelection) {
        if (containers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containers", "com/intellij/designer/propertyTable/PropertyTable", "update"));
        }
        this.update(containers, initialSelection, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(@NotNull List<? extends PropertiesContainer> containers, @Nullable Property initialSelection, boolean finishEditing) {
        if (containers == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "containers", "com/intellij/designer/propertyTable/PropertyTable", "update"));
        }
        if (finishEditing) {
            this.finishEditing();
        }
        if (this.mySkipUpdate) {
            return;
        }
        this.mySkipUpdate = true;
        try {
            if (finishEditing && this.isEditing()) {
                this.cellEditor.stopCellEditing();
            }
            Property selection = initialSelection != null ? initialSelection : this.getSelectionProperty();
            this.myContainers = new ArrayList<PropertiesContainer>(containers);
            this.fillProperties();
            this.myModel.fireTableDataChanged();
            this.restoreSelection(selection);
        }
        finally {
            this.mySkipUpdate = false;
        }
    }

    private void sortPropertiesAndCreateGroups(List<Property> rootProperties) {
        if (!this.mySorted && !this.myShowGroups) {
            return;
        }
        Collections.sort(rootProperties, new Comparator<Property>(){

            @Override
            public int compare(Property o1, Property o2) {
                int result;
                if (o1.getParent() != null || o2.getParent() != null) {
                    if (o1.getParent() == o2) {
                        return -1;
                    }
                    if (o2.getParent() == o1) {
                        return 1;
                    }
                    return 0;
                }
                if (PropertyTable.this.myShowGroups && (result = PropertyTable.this.getGroupComparator().compare(o1.getGroup(), o2.getGroup())) != 0) {
                    return result;
                }
                return PropertyTable.this.mySorted ? PropertyTable.this.getPropertyComparator().compare(o1, o2) : 0;
            }
        });
        if (this.myShowGroups) {
            for (int i = 0; i < rootProperties.size() - 1; ++i) {
                String prevGroup;
                Property prev = i == 0 ? null : rootProperties.get(i - 1);
                Property each = rootProperties.get(i);
                String eachGroup = each.getGroup();
                String string = prevGroup = prev == null ? null : prev.getGroup();
                if (prevGroup == null && eachGroup == null || StringUtil.equalsIgnoreCase((CharSequence)eachGroup, (CharSequence)prevGroup)) continue;
                rootProperties.add(i, new GroupProperty(each.getGroup()));
                ++i;
            }
        }
    }

    @NotNull
    protected Comparator<String> getGroupComparator() {
        Comparator<String> comparator2 = GROUP_COMPARATOR;
        if (comparator2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/propertyTable/PropertyTable", "getGroupComparator"));
        }
        return comparator2;
    }

    @NotNull
    protected Comparator<Property> getPropertyComparator() {
        Comparator<Property> comparator2 = PROPERTY_COMPARATOR;
        if (comparator2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/propertyTable/PropertyTable", "getPropertyComparator"));
        }
        return comparator2;
    }

    protected List<Property> getProperties(PropertiesContainer component) {
        return component.getProperties();
    }

    private void restoreSelection(Property selection) {
        int index;
        int i;
        ArrayList<Property> propertyPath = new ArrayList<Property>(2);
        while (selection != null) {
            propertyPath.add(0, selection);
            selection = selection.getParent();
        }
        int indexToSelect = -1;
        int size = propertyPath.size();
        for (i = 0; i < size && (index = PropertyTable.findFullPathProperty(this.myProperties, (Property)propertyPath.get(i))) != -1; ++i) {
            if (i == size - 1) {
                indexToSelect = index;
                continue;
            }
            this.expand(index);
        }
        if (indexToSelect != -1) {
            this.getSelectionModel().setSelectionInterval(indexToSelect, indexToSelect);
        } else if (this.getRowCount() > 0) {
            indexToSelect = 0;
            for (i = 0; i < this.myProperties.size(); ++i) {
                if (this.myProperties.get(i) instanceof GroupProperty) continue;
                indexToSelect = i;
                break;
            }
            this.getSelectionModel().setSelectionInterval(indexToSelect, indexToSelect);
        }
        TableUtil.scrollSelectionToVisible((JTable)((Object)this));
    }

    private void fillProperties() {
        this.myProperties = new ArrayList<Property>();
        int size = this.myContainers.size();
        if (size > 0) {
            ArrayList<Property> rootProperties = new ArrayList<Property>();
            for (Property each : this.getProperties(this.myContainers.get(0))) {
                this.addIfNeeded(this.getCurrentComponent(), each, rootProperties);
            }
            this.sortPropertiesAndCreateGroups(rootProperties);
            for (Property property : rootProperties) {
                this.myProperties.add(property);
                this.addExpandedChildren(this.getCurrentComponent(), property, this.myProperties);
            }
            if (size > 1) {
                Iterator<Property> I = this.myProperties.iterator();
                while (I.hasNext()) {
                    if (I.next().availableFor(this.myContainers)) continue;
                    I.remove();
                }
                for (int i = 1; i < size; ++i) {
                    ArrayList<Property> otherProperties = new ArrayList<Property>();
                    this.fillProperties(this.myContainers.get(i), otherProperties);
                    Iterator<Property> I2 = this.myProperties.iterator();
                    block4: while (I2.hasNext()) {
                        Property addedProperty = I2.next();
                        int index = PropertyTable.findFullPathProperty(otherProperties, addedProperty);
                        if (index == -1) {
                            I2.remove();
                            continue;
                        }
                        Property testProperty = (Property)otherProperties.get(index);
                        if (!addedProperty.getClass().equals(testProperty.getClass())) {
                            I2.remove();
                            continue;
                        }
                        List<Property> addedChildren = this.getChildren(addedProperty);
                        List<Property> testChildren = this.getChildren(testProperty);
                        int addedChildrenSize = addedChildren.size();
                        if (addedChildrenSize != testChildren.size()) {
                            I2.remove();
                            continue;
                        }
                        for (int j = 0; j < addedChildrenSize; ++j) {
                            if (addedChildren.get(j).getName().equals(testChildren.get(j).getName())) continue;
                            I2.remove();
                            continue block4;
                        }
                    }
                }
            }
        }
    }

    private void fillProperties(PropertiesContainer<?> component, List<Property> properties) {
        for (Property each : this.getProperties(component)) {
            if (!this.addIfNeeded(component, each, properties)) continue;
            this.addExpandedChildren(component, each, properties);
        }
    }

    private void addExpandedChildren(PropertiesContainer<?> component, Property property, List<Property> properties) {
        if (this.isExpanded(property)) {
            for (Property child : this.getChildren(property)) {
                if (!this.addIfNeeded(component, child, properties)) continue;
                this.addExpandedChildren(component, child, properties);
            }
        }
    }

    private boolean addIfNeeded(PropertiesContainer<?> component, Property property, List<Property> properties) {
        if (property.isExpert() && !this.myShowExpertProperties) {
            try {
                if (property.isDefaultRecursively(component)) {
                    return false;
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        properties.add(property);
        return true;
    }

    @Nullable
    public static Property findProperty(List<Property> properties, String name) {
        for (Property property : properties) {
            if (!name.equals(property.getName())) continue;
            return property;
        }
        return null;
    }

    public static int findProperty(List<Property> properties, Property property) {
        String name = property.getName();
        int size = properties.size();
        for (int i = 0; i < size; ++i) {
            Property nextProperty = properties.get(i);
            if (!Comparing.equal((String)nextProperty.getGroup(), (String)property.getGroup()) || !name.equals(nextProperty.getName())) continue;
            return i;
        }
        return -1;
    }

    private static int findFullPathProperty(List<Property> properties, Property property) {
        Property parent = property.getParent();
        if (parent == null) {
            return PropertyTable.findProperty(properties, property);
        }
        String name = PropertyTable.getFullPathName(property);
        int size = properties.size();
        for (int i = 0; i < size; ++i) {
            if (!name.equals(PropertyTable.getFullPathName(properties.get(i)))) continue;
            return i;
        }
        return -1;
    }

    private static String getFullPathName(Property property) {
        StringBuilder builder = new StringBuilder();
        while (property != null) {
            builder.insert(0, ".").insert(0, property.getName());
            property = property.getParent();
        }
        return builder.toString();
    }

    public static void moveProperty(List<Property> source, String name, List<Property> destination, int index) {
        Property property = PropertyTable.extractProperty(source, name);
        if (property != null) {
            if (index == -1) {
                destination.add(property);
            } else {
                destination.add(index, property);
            }
        }
    }

    @Nullable
    public static Property extractProperty(List<Property> properties, String name) {
        int size = properties.size();
        for (int i = 0; i < size; ++i) {
            if (!name.equals(properties.get(i).getName())) continue;
            return properties.remove(i);
        }
        return null;
    }

    @Nullable
    public Property getSelectionProperty() {
        int selectedRow = this.getSelectedRow();
        if (selectedRow >= 0 && selectedRow < this.myProperties.size()) {
            return this.myProperties.get(selectedRow);
        }
        return null;
    }

    @Nullable
    private PropertiesContainer getCurrentComponent() {
        return this.myContainers.size() == 1 ? this.myContainers.get(0) : null;
    }

    private List<Property> getChildren(Property property) {
        return property.getChildren(this.getCurrentComponent());
    }

    private List<Property> getFilterChildren(Property property) {
        ArrayList<Property> properties = new ArrayList<Property>(this.getChildren(property));
        Iterator I = properties.iterator();
        while (I.hasNext()) {
            Property child = (Property)I.next();
            if (!child.isExpert() || this.myShowExpertProperties) continue;
            I.remove();
        }
        return properties;
    }

    public boolean isDefault(Property property) throws Exception {
        for (PropertiesContainer component : this.myContainers) {
            if (property.isDefaultRecursively(component)) continue;
            return false;
        }
        return true;
    }

    @Nullable
    protected final Object getValue(Property property) throws Exception {
        int size = this.myContainers.size();
        if (size == 0) {
            return null;
        }
        Object value = property.getValue(this.myContainers.get(0));
        for (int i = 1; i < size; ++i) {
            if (Comparing.equal((Object)value, (Object)property.getValue(this.myContainers.get(i)))) continue;
            return null;
        }
        return value;
    }

    private boolean isExpanded(Property property) {
        return this.myExpandedProperties.contains(property.getPath());
    }

    private void collapse(int rowIndex) {
        int selectedRow = this.getSelectedRow();
        Property property = this.myProperties.get(rowIndex);
        int size = this.collapse(property, rowIndex + 1);
        LOG.assertTrue(size > 0);
        this.myModel.fireTableDataChanged();
        if (selectedRow != -1) {
            if (selectedRow > rowIndex) {
                selectedRow -= size;
            }
            this.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
        }
    }

    private int collapse(Property property, int startIndex) {
        int totalSize = 0;
        if (this.myExpandedProperties.remove(property.getPath())) {
            int size = this.getFilterChildren(property).size();
            totalSize += size;
            for (int i = 0; i < size; ++i) {
                totalSize += this.collapse(this.myProperties.remove(startIndex), startIndex);
            }
        }
        return totalSize;
    }

    private void expand(int rowIndex) {
        int selectedRow = this.getSelectedRow();
        Property property = this.myProperties.get(rowIndex);
        String path = property.getPath();
        if (this.myExpandedProperties.contains(path)) {
            return;
        }
        this.myExpandedProperties.add(path);
        List<Property> properties = this.getFilterChildren(property);
        this.myProperties.addAll(rowIndex + 1, properties);
        this.myModel.fireTableDataChanged();
        if (selectedRow != -1) {
            if (selectedRow > rowIndex) {
                selectedRow += properties.size();
            }
            this.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
        }
        Rectangle rectStart = this.getCellRect(selectedRow, 0, true);
        Rectangle rectEnd = this.getCellRect(selectedRow + properties.size(), 0, true);
        this.scrollRectToVisible(new Rectangle(rectStart.x, rectStart.y, rectEnd.x + rectEnd.width - rectStart.x, rectEnd.y + rectEnd.height - rectStart.y));
    }

    public void setValueAt(Object aValue, int row, int column) {
        Property property = this.myProperties.get(row);
        super.setValueAt(aValue, row, column);
        if (property.needRefreshPropertyList()) {
            this.update();
        }
        this.repaint();
    }

    public TableCellEditor getCellEditor(int row, int column) {
        PropertyEditor editor = this.myProperties.get(row).getEditor();
        editor.removePropertyEditorListener(this.myPropertyEditorListener);
        editor.addPropertyEditorListener(this.myPropertyEditorListener);
        this.myCellEditor.setEditor(editor);
        return this.myCellEditor;
    }

    public boolean editCellAt(int row, int column, EventObject e) {
        boolean result = super.editCellAt(row, column, e);
        this.repaint(this.getCellRect(row, column, true));
        return result;
    }

    private void startEditing(int index) {
        this.startEditing(index, false);
    }

    private void startEditing(int index, boolean startedWithKeyboard) {
        final PropertyEditor editor = this.myProperties.get(index).getEditor();
        if (editor == null) {
            return;
        }
        this.editCellAt(index, this.convertColumnIndexToView(1));
        LOG.assertTrue(this.editorComp != null);
        JComponent preferredComponent = editor.getPreferredFocusedComponent();
        if (preferredComponent == null) {
            preferredComponent = IdeFocusTraversalPolicy.getPreferredFocusedComponent((JComponent)this.editorComp);
        }
        if (preferredComponent != null) {
            preferredComponent.requestFocusInWindow();
        }
        if (startedWithKeyboard) {
            IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(new Runnable(){

                @Override
                public void run() {
                    editor.activate();
                }
            });
        }
    }

    private void finishEditing() {
        if (this.editingRow != -1) {
            this.editingStopped(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void editingStopped(@Nullable ChangeEvent event) {
        if (this.myStoppingEditing) {
            return;
        }
        this.myStoppingEditing = true;
        LOG.assertTrue(this.isEditing());
        LOG.assertTrue(this.editingRow != -1);
        PropertyEditor editor = this.myProperties.get(this.editingRow).getEditor();
        editor.removePropertyEditorListener(this.myPropertyEditorListener);
        try {
            this.setValueAt(editor.getValue(), this.editingRow, this.editingColumn);
        }
        catch (Exception e) {
            PropertyTable.showInvalidInput(e);
        }
        finally {
            this.removeEditor();
            this.myStoppingEditing = false;
        }
    }

    public void removeEditor() {
        super.removeEditor();
        this.updateEditActions();
    }

    protected void updateEditActions() {
    }

    private boolean setValueAtRow(int row, final Object newValue) {
        final Property property = this.myProperties.get(row);
        final Object[] oldValue = new Object[1];
        try {
            boolean isNewValue;
            oldValue[0] = this.getValue(property);
            boolean bl = isNewValue = !Comparing.equal((Object)oldValue[0], (Object)newValue);
            if (newValue != null) break block4;
            if (!(oldValue[0] instanceof String)) break block5;
            if (((String)oldValue[0]).length() == 0) {
                isNewValue = false;
            }
        }
        finally {
            boolean isSetValue = true;
        }
        {
            block4: {
                block5: {
                }
            }
        }
    }

    protected abstract boolean doSetValue(ThrowableRunnable<Exception> var1);

    private static void showInvalidInput(Exception e) {
        String message;
        Throwable cause = e.getCause();
        String string = message = cause == null ? e.getMessage() : cause.getMessage();
        if (message == null || message.length() == 0) {
            message = "No message";
        }
        Messages.showMessageDialog((String)MessageFormat.format("Error setting value: {0}", message), (String)"Invalid Input", (Icon)Messages.getErrorIcon());
    }

    private static int getDepth(@NotNull Property property) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/designer/propertyTable/PropertyTable", "getDepth"));
        }
        int result = 0;
        Property each = property.getParent();
        while (each != null) {
            each = each.getParent();
            ++result;
        }
        return result;
    }

    @NotNull
    private static Couple<Integer> getBeforeIconAndAfterIndents(@NotNull Property property, @NotNull Icon icon) {
        if (property == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "property", "com/intellij/designer/propertyTable/PropertyTable", "getBeforeIconAndAfterIndents"));
        }
        if (icon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "icon", "com/intellij/designer/propertyTable/PropertyTable", "getBeforeIconAndAfterIndents"));
        }
        int nodeIndent = UIUtil.getTreeLeftChildIndent() + UIUtil.getTreeRightChildIndent();
        int beforeIcon = nodeIndent * PropertyTable.getDepth(property);
        int leftIconOffset = Math.max(0, UIUtil.getTreeLeftChildIndent() - icon.getIconWidth() / 2);
        int afterIcon = Math.max(0, nodeIndent - leftIconOffset - icon.getIconWidth());
        Couple couple = Couple.of((Object)(beforeIcon += leftIconOffset), (Object)afterIcon);
        if (couple == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/propertyTable/PropertyTable", "getBeforeIconAndAfterIndents"));
        }
        return couple;
    }

    public static void updateRenderer(JComponent component, boolean selected) {
        if (selected) {
            component.setForeground(UIUtil.getTableSelectionForeground());
            component.setBackground(UIUtil.getTableSelectionBackground());
        } else {
            component.setForeground(UIUtil.getTableForeground());
            component.setBackground(UIUtil.getTableBackground());
        }
    }

    @NotNull
    protected abstract TextAttributesKey getErrorAttributes(@NotNull HighlightSeverity var1);

    private static class GroupProperty
    extends Property {
        public GroupProperty(@Nullable String name) {
            super(null, StringUtil.notNullize((String)name));
        }

        @Override
        @NotNull
        public PropertyRenderer getRenderer() {
            LabelPropertyRenderer labelPropertyRenderer = new LabelPropertyRenderer(null);
            if (labelPropertyRenderer == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/designer/propertyTable/PropertyTable$GroupProperty", "getRenderer"));
            }
            return labelPropertyRenderer;
        }

        @Override
        public PropertyEditor getEditor() {
            return null;
        }
    }

    private class PropertyCellRenderer
    implements TableCellRenderer {
        private final ColoredTableCellRenderer myCellRenderer = new MyCellRenderer();
        private final ColoredTableCellRenderer myGroupRenderer;

        private PropertyCellRenderer() {
            this.myGroupRenderer = new MyCellRenderer(){
                private boolean mySelected;
                public boolean myDrawTopLine;

                @Override
                protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                    super.customizeCellRenderer(table, value, selected, hasFocus, row, column);
                    this.mySelected = selected;
                    this.myDrawTopLine = row > 0;
                }

                protected void paintBackground(Graphics2D g, int x, int width, int height) {
                    if (this.mySelected) {
                        super.paintBackground(g, x, width, height);
                    } else {
                        UIUtil.drawHeader((Graphics)g, (int)x, (int)width, (int)height, (boolean)true, (boolean)this.myDrawTopLine);
                    }
                }
            };
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean selected, boolean cellHasFocus, int row, int column) {
            column = table.convertColumnIndexToModel(column);
            Property property = (Property)value;
            Color background = table.getBackground();
            Component focusOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
            boolean tableHasFocus = focusOwner != null && SwingUtilities.isDescendingFrom(focusOwner, table);
            ColoredTableCellRenderer renderer = property instanceof GroupProperty ? this.myGroupRenderer : this.myCellRenderer;
            renderer.getTableCellRendererComponent(table, value, selected, cellHasFocus, row, column);
            renderer.setBackground(selected ? UIUtil.getTreeSelectionBackground((boolean)tableHasFocus) : background);
            if (property instanceof GroupProperty) {
                renderer.setIpad(new Insets(0, 5, 0, 0));
                if (column == 0) {
                    renderer.append(property.getName());
                }
                return renderer;
            }
            boolean isDefault = true;
            try {
                for (PropertiesContainer container : PropertyTable.this.myContainers) {
                    if (property.showAsDefault(container)) continue;
                    isDefault = false;
                    break;
                }
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
            }
            renderer.clear();
            if (column == 0) {
                ErrorInfo errorInfo;
                SimpleTextAttributes attr = SimpleTextAttributes.REGULAR_ATTRIBUTES;
                if (!selected && !isDefault) {
                    attr = attr.derive(-1, FileStatus.MODIFIED.getColor(), null, null);
                }
                if (property.isImportant()) {
                    attr = attr.derive(attr.getStyle() | 1, null, null, null);
                }
                if (property.isExpert()) {
                    attr = attr.derive(attr.getStyle() | 2, null, null, null);
                }
                if (property.isDeprecated()) {
                    attr = attr.derive(attr.getStyle() | 4, null, null, null);
                }
                if ((errorInfo = PropertyTable.this.getErrorInfoForRow(row)) != null) {
                    SimpleTextAttributes template = SimpleTextAttributes.fromTextAttributes((TextAttributes)EditorColorsManager.getInstance().getGlobalScheme().getAttributes(PropertyTable.this.getErrorAttributes(errorInfo.getLevel().getSeverity())));
                    int style = ((template.getStyle() & 8) != 0 ? 8 : 0) | ((template.getStyle() & 0x10) != 0 ? 16 : 0);
                    attr = attr.derive(attr.getStyle() | style, template.getFgColor(), null, template.getWaveColor());
                }
                SearchUtil.appendFragments(PropertyTable.this.mySpeedSearch.getEnteredPrefix(), property.getName(), attr.getStyle(), attr.getFgColor(), attr.getBgColor(), (SimpleColoredComponent)renderer);
                Icon icon = UIUtil.getTreeNodeIcon((boolean)PropertyTable.this.isExpanded(property), (boolean)selected, (boolean)tableHasFocus);
                boolean hasChildren = !PropertyTable.this.getChildren(property).isEmpty();
                renderer.setIcon(hasChildren ? icon : null);
                Couple indents = PropertyTable.getBeforeIconAndAfterIndents(property, icon);
                int indent = (Integer)indents.first;
                if (hasChildren) {
                    renderer.setIconTextGap(((Integer)indents.second).intValue());
                } else {
                    indent += icon.getIconWidth() + (Integer)indents.second;
                }
                renderer.setIpad(new Insets(0, indent, 0, 0));
                return renderer;
            }
            try {
                PropertyRenderer valueRenderer = property.getRenderer();
                JComponent component = valueRenderer.getComponent(PropertyTable.this.getCurrentComponent(), PropertyTable.this.getPropertyContext(), PropertyTable.this.getValue(property), selected, tableHasFocus);
                component.setBackground(selected ? UIUtil.getTreeSelectionBackground((boolean)tableHasFocus) : background);
                component.setFont(table.getFont());
                if (component instanceof JCheckBox) {
                    component.putClientProperty("JComponent.sizeVariant", UIUtil.isUnderAquaLookAndFeel() ? "small" : null);
                }
                return component;
            }
            catch (Exception e) {
                LOG.debug((Throwable)e);
                renderer.append(MessageFormat.format("Error getting value: {0}", e.getMessage()), SimpleTextAttributes.ERROR_ATTRIBUTES);
                return renderer;
            }
        }

        private class MyCellRenderer
        extends ColoredTableCellRenderer {
            private MyCellRenderer() {
            }

            protected void customizeCellRenderer(JTable table, Object value, boolean selected, boolean hasFocus, int row, int column) {
                this.setPaintFocusBorder(false);
                this.setFocusBorderAroundIcon(true);
            }
        }
    }

    private class PropertyCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private PropertyEditor myEditor;

        private PropertyCellEditor() {
        }

        public void setEditor(PropertyEditor editor) {
            this.myEditor = editor;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            JComponent jComponent;
            try {
                JComponent component = this.myEditor.getComponent(PropertyTable.this.getCurrentComponent(), PropertyTable.this.getPropertyContext(), PropertyTable.this.getValue((Property)value), null);
                if (component instanceof JComboBox) {
                    ComboBox.registerTableCellEditor((JComboBox)((JComboBox)component), (TableCellEditor)this);
                } else if (component instanceof JCheckBox) {
                    component.putClientProperty("JComponent.sizeVariant", UIUtil.isUnderAquaLookAndFeel() ? "small" : null);
                }
                jComponent = component;
            }
            catch (Throwable e) {
                SimpleColoredComponent simpleColoredComponent;
                try {
                    LOG.debug(e);
                    SimpleColoredComponent errComponent = new SimpleColoredComponent();
                    errComponent.append(MessageFormat.format("Error getting value: {0}", e.getMessage()), SimpleTextAttributes.ERROR_ATTRIBUTES);
                    simpleColoredComponent = errComponent;
                }
                catch (Throwable throwable) {
                    ApplicationManager.getApplication().invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            PropertyTable.this.updateEditActions();
                        }
                    });
                    throw throwable;
                }
                ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */);
                return simpleColoredComponent;
            }
            ApplicationManager.getApplication().invokeLater(new /* invalid duplicate definition of identical inner class */);
            return jComponent;
        }

        @Override
        public Object getCellEditorValue() {
            try {
                return this.myEditor.getValue();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private class PropertyCellEditorListener
    implements PropertyEditorListener {
        private PropertyCellEditorListener() {
        }

        @Override
        public void valueCommitted(PropertyEditor source, boolean continueEditing, boolean closeEditorOnError) {
            if (PropertyTable.this.isEditing()) {
                Object value;
                TableCellEditor tableCellEditor = PropertyTable.this.cellEditor;
                try {
                    value = tableCellEditor.getCellEditorValue();
                }
                catch (Exception e) {
                    PropertyTable.showInvalidInput(e);
                    return;
                }
                if (PropertyTable.this.setValueAtRow(PropertyTable.this.editingRow, value)) {
                    if (!continueEditing && PropertyTable.this.editingRow != -1) {
                        PropertyEditor editor = PropertyTable.this.myProperties.get(PropertyTable.this.editingRow).getEditor();
                        editor.removePropertyEditorListener(PropertyTable.this.myPropertyEditorListener);
                        PropertyTable.this.removeEditor();
                    }
                } else if (closeEditorOnError) {
                    tableCellEditor.cancelCellEditing();
                }
            }
        }

        @Override
        public void editingCanceled(PropertyEditor source) {
            if (PropertyTable.this.isEditing()) {
                PropertyTable.this.cellEditor.cancelCellEditing();
            }
        }

        @Override
        public void preferredSizeChanged(PropertyEditor source) {
        }
    }

    private class PropertyTableModel
    extends AbstractTableModel {
        private PropertyTableModel() {
        }

        @Override
        public int getColumnCount() {
            return PropertyTable.this.myColumnNames.length;
        }

        @Override
        public String getColumnName(int column) {
            return PropertyTable.this.myColumnNames[column];
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 1 && PropertyTable.this.myProperties.get(row).isEditable(PropertyTable.this.getCurrentComponent());
        }

        @Override
        public int getRowCount() {
            return PropertyTable.this.myProperties.size();
        }

        @Override
        public Object getValueAt(int rowIndex, int columnIndex) {
            return PropertyTable.this.myProperties.get(rowIndex);
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            PropertyTable.this.setValueAtRow(rowIndex, aValue);
        }
    }

    private class MouseTableListener
    extends MouseAdapter {
        private MouseTableListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            int row = PropertyTable.this.rowAtPoint(e.getPoint());
            if (row == -1) {
                return;
            }
            Property property = PropertyTable.this.myProperties.get(row);
            if (PropertyTable.this.getChildren(property).isEmpty()) {
                return;
            }
            Icon icon = UIUtil.getTreeNodeIcon((boolean)false, (boolean)true, (boolean)true);
            Rectangle rect = PropertyTable.this.getCellRect(row, PropertyTable.this.convertColumnIndexToView(0), false);
            int indent = (Integer)PropertyTable.getBeforeIconAndAfterIndents((Property)property, (Icon)icon).first;
            if (e.getX() < rect.x + indent || e.getX() > rect.x + indent + icon.getIconWidth() || e.getY() < rect.y || e.getY() > rect.y + rect.height) {
                return;
            }
            if (PropertyTable.this.isExpanded(property)) {
                PropertyTable.this.collapse(row);
            } else {
                PropertyTable.this.expand(row);
            }
        }
    }

    private class MyRestoreDefaultAction
    extends AbstractAction {
        private MyRestoreDefaultAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            PropertyTable.this.restoreDefaultValue();
        }
    }

    private class MyExpandCurrentAction
    extends AbstractAction {
        private final boolean myExpand;
        private final boolean mySelect;

        public MyExpandCurrentAction(boolean expand, boolean select) {
            this.myExpand = expand;
            this.mySelect = select;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Property parent;
            int selectedRow = PropertyTable.this.getSelectedRow();
            if (PropertyTable.this.isEditing() || selectedRow == -1) {
                return;
            }
            Property property = PropertyTable.this.myProperties.get(selectedRow);
            List children2 = PropertyTable.this.getChildren(property);
            if (!children2.isEmpty()) {
                Property parent2;
                if (this.myExpand) {
                    if (!PropertyTable.this.isExpanded(property)) {
                        PropertyTable.this.expand(selectedRow);
                    } else if (this.mySelect) {
                        PropertyTable.this.restoreSelection((Property)children2.get(0));
                    }
                } else if (PropertyTable.this.isExpanded(property)) {
                    PropertyTable.this.collapse(selectedRow);
                } else if (this.mySelect && (parent2 = property.getParent()) != null) {
                    PropertyTable.this.restoreSelection(parent2);
                }
            } else if (!this.myExpand && this.mySelect && (parent = property.getParent()) != null) {
                PropertyTable.this.restoreSelection(parent);
            }
        }
    }

    private class MyEnterAction
    extends AbstractAction {
        private MyEnterAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedRow = PropertyTable.this.getSelectedRow();
            if (PropertyTable.this.isEditing() || selectedRow == -1) {
                return;
            }
            Property property = PropertyTable.this.myProperties.get(selectedRow);
            if (!PropertyTable.this.getChildren(property).isEmpty()) {
                if (PropertyTable.this.isExpanded(property)) {
                    PropertyTable.this.collapse(selectedRow);
                } else {
                    PropertyTable.this.expand(selectedRow);
                }
            } else {
                PropertyTable.this.startEditing(selectedRow, true);
            }
        }
    }

    private class MyStartEditingAction
    extends AbstractAction {
        private MyStartEditingAction() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int selectedRow = PropertyTable.this.getSelectedRow();
            if (selectedRow == -1 || PropertyTable.this.isEditing()) {
                return;
            }
            PropertyTable.this.startEditing(selectedRow, true);
        }
    }

    private class MySelectNextPreviousRowAction
    extends AbstractAction {
        private boolean selectNext;

        private MySelectNextPreviousRowAction(boolean selectNext) {
            this.selectNext = selectNext;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            int rowCount = PropertyTable.this.getRowCount();
            LOG.assertTrue(rowCount > 0);
            int selectedRow = PropertyTable.this.getSelectedRow();
            selectedRow = selectedRow == -1 ? 0 : (this.selectNext ? Math.min(rowCount - 1, PropertyTable.this.getSelectedRow() + 1) : Math.max(0, selectedRow - 1));
            if (PropertyTable.this.isEditing()) {
                PropertyTable.this.finishEditing();
                PropertyTable.this.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
                PropertyTable.this.scrollRectToVisible(PropertyTable.this.getCellRect(selectedRow, 0, true));
                PropertyTable.this.startEditing(selectedRow);
            } else {
                PropertyTable.this.getSelectionModel().setSelectionInterval(selectedRow, selectedRow);
                PropertyTable.this.scrollRectToVisible(PropertyTable.this.getCellRect(selectedRow, 0, true));
            }
        }
    }
}

