/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.contents;

import com.intellij.diff.contents.DocumentContentImpl;
import com.intellij.diff.contents.FileContent;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LineSeparator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FileDocumentContentImpl
extends DocumentContentImpl
implements FileContent {
    @Nullable
    private final Project myProject;
    @NotNull
    private final VirtualFile myFile;

    public FileDocumentContentImpl(@Nullable Project project2, @NotNull Document document, @NotNull VirtualFile file2) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/diff/contents/FileDocumentContentImpl", "<init>"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/contents/FileDocumentContentImpl", "<init>"));
        }
        super(document, file2.getFileType(), file2, FileDocumentContentImpl.getSeparator(file2), file2.getCharset());
        this.myProject = project2;
        this.myFile = file2;
    }

    @Override
    @Nullable
    public OpenFileDescriptor getOpenFileDescriptor(int offset) {
        if (this.myProject == null || this.myProject.isDefault() || !this.myFile.isValid()) {
            return null;
        }
        return new OpenFileDescriptor(this.myProject, this.myFile, offset);
    }

    @Nullable
    private static LineSeparator getSeparator(@NotNull VirtualFile file2) {
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/diff/contents/FileDocumentContentImpl", "getSeparator"));
        }
        String s = LoadTextUtil.detectLineSeparator(file2, true);
        if (s == null) {
            return null;
        }
        return LineSeparator.fromString((String)s);
    }

    @NotNull
    public VirtualFile getFile() {
        VirtualFile virtualFile = this.myFile;
        if (virtualFile == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/FileDocumentContentImpl", "getFile"));
        }
        return virtualFile;
    }
}

