/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diff.contents;

import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.contents.DocumentContentImpl;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.LineSeparator;
import com.intellij.util.containers.Convertor;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimpleContentBuilder {
    @NotNull
    private final String myText;
    @Nullable
    private FileType myFileType;
    @Nullable
    private VirtualFile myHighlightFile;
    @Nullable
    private LineSeparator mySeparator;
    @Nullable
    private Charset myCharset;
    @Nullable
    private Convertor<Integer, OpenFileDescriptor> myOpenFileDescriptor;
    private boolean myReadOnly;

    public SimpleContentBuilder(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/diff/contents/SimpleContentBuilder", "<init>"));
        }
        this.myText = text;
    }

    @NotNull
    public SimpleContentBuilder setFileType(@Nullable FileType type) {
        this.myFileType = type;
        SimpleContentBuilder simpleContentBuilder = this;
        if (simpleContentBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/SimpleContentBuilder", "setFileType"));
        }
        return simpleContentBuilder;
    }

    @NotNull
    public SimpleContentBuilder setHighlightFile(@Nullable VirtualFile highlightFile) {
        this.myHighlightFile = highlightFile;
        SimpleContentBuilder simpleContentBuilder = this;
        if (simpleContentBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/SimpleContentBuilder", "setHighlightFile"));
        }
        return simpleContentBuilder;
    }

    @NotNull
    public SimpleContentBuilder setSeparator(@Nullable LineSeparator separator) {
        this.mySeparator = separator;
        SimpleContentBuilder simpleContentBuilder = this;
        if (simpleContentBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/SimpleContentBuilder", "setSeparator"));
        }
        return simpleContentBuilder;
    }

    @NotNull
    public SimpleContentBuilder setCharset(@Nullable Charset charset) {
        this.myCharset = charset;
        SimpleContentBuilder simpleContentBuilder = this;
        if (simpleContentBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/SimpleContentBuilder", "setCharset"));
        }
        return simpleContentBuilder;
    }

    @NotNull
    public SimpleContentBuilder setOpenFileDescriptor(@Nullable Convertor<Integer, OpenFileDescriptor> openFileDescriptor) {
        this.myOpenFileDescriptor = openFileDescriptor;
        SimpleContentBuilder simpleContentBuilder = this;
        if (simpleContentBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/SimpleContentBuilder", "setOpenFileDescriptor"));
        }
        return simpleContentBuilder;
    }

    @NotNull
    public SimpleContentBuilder setReadOnly(boolean readOnly) {
        this.myReadOnly = readOnly;
        SimpleContentBuilder simpleContentBuilder = this;
        if (simpleContentBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/SimpleContentBuilder", "setReadOnly"));
        }
        return simpleContentBuilder;
    }

    @NotNull
    public DocumentContent build() {
        Document document = EditorFactory.getInstance().createDocument((CharSequence)this.myText);
        if (this.myReadOnly) {
            document.setReadOnly(true);
        }
        DocumentContentImpl documentContentImpl = new DocumentContentImpl(document, this.myFileType, this.myHighlightFile, this.mySeparator, this.myCharset){

            @Override
            @Nullable
            public OpenFileDescriptor getOpenFileDescriptor(int offset) {
                if (SimpleContentBuilder.this.myOpenFileDescriptor == null) {
                    return null;
                }
                return (OpenFileDescriptor)SimpleContentBuilder.this.myOpenFileDescriptor.convert((Object)offset);
            }
        };
        if (documentContentImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/diff/contents/SimpleContentBuilder", "build"));
        }
        return documentContentImpl;
    }
}

