/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dvcs.ui;

import com.intellij.dvcs.repo.Repository;
import com.intellij.dvcs.ui.VcsLogAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsFullCommitDetails;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class VcsLogOneCommitPerRepoAction<Repo extends Repository>
extends VcsLogAction<Repo> {
    @Override
    protected void actionPerformed(@NotNull Project project2, @NotNull MultiMap<Repo, VcsFullCommitDetails> grouped) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/dvcs/ui/VcsLogOneCommitPerRepoAction", "actionPerformed"));
        }
        if (grouped == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grouped", "com/intellij/dvcs/ui/VcsLogOneCommitPerRepoAction", "actionPerformed"));
        }
        Map<Repo, VcsFullCommitDetails> singleElementMap = this.convertToSingleElementMap(grouped);
        assert (singleElementMap != null);
        this.actionPerformed(project2, singleElementMap);
    }

    @Override
    protected boolean isEnabled(@NotNull MultiMap<Repo, Hash> grouped) {
        if (grouped == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grouped", "com/intellij/dvcs/ui/VcsLogOneCommitPerRepoAction", "isEnabled"));
        }
        return this.allValuesAreSingletons(grouped);
    }

    @Override
    protected abstract void actionPerformed(@NotNull Project var1, @NotNull Map<Repo, VcsFullCommitDetails> var2);

    private boolean allValuesAreSingletons(@NotNull MultiMap<Repo, Hash> grouped) {
        if (grouped == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grouped", "com/intellij/dvcs/ui/VcsLogOneCommitPerRepoAction", "allValuesAreSingletons"));
        }
        return !ContainerUtil.exists((Iterable)grouped.entrySet(), (Condition)new Condition<Map.Entry<Repo, Collection<Hash>>>(){

            public boolean value(Map.Entry<Repo, Collection<Hash>> entry) {
                return entry.getValue().size() != 1;
            }
        });
    }

    @Nullable
    private Map<Repo, VcsFullCommitDetails> convertToSingleElementMap(@NotNull MultiMap<Repo, VcsFullCommitDetails> groupedCommits) {
        if (groupedCommits == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "groupedCommits", "com/intellij/dvcs/ui/VcsLogOneCommitPerRepoAction", "convertToSingleElementMap"));
        }
        HashMap map = ContainerUtil.newHashMap();
        for (Map.Entry entry : groupedCommits.entrySet()) {
            Collection commits = (Collection)entry.getValue();
            if (commits.size() != 1) {
                return null;
            }
            map.put(entry.getKey(), commits.iterator().next());
        }
        return map;
    }
}

