/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.junit2.info;

import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMethod;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodLocation
extends Location<PsiMethod> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.junit2.info.MethodLocation");
    private final Project myProject;
    @NotNull
    private final PsiMethod myMethod;
    private final Location<PsiClass> myClassLocation;

    public MethodLocation(@NotNull Project project2, @NotNull PsiMethod method, @NotNull Location<PsiClass> classLocation) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/execution/junit2/info/MethodLocation", "<init>"));
        }
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "com/intellij/execution/junit2/info/MethodLocation", "<init>"));
        }
        if (classLocation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "classLocation", "com/intellij/execution/junit2/info/MethodLocation", "<init>"));
        }
        this.myProject = project2;
        this.myMethod = method;
        this.myClassLocation = classLocation;
    }

    public static MethodLocation elementInClass(PsiMethod psiElement, PsiClass psiClass) {
        Location classLocation = PsiLocation.fromPsiElement((PsiElement)psiClass);
        return new MethodLocation(classLocation.getProject(), psiElement, (Location<PsiClass>)classLocation);
    }

    @NotNull
    public PsiMethod getPsiElement() {
        PsiMethod psiMethod = this.myMethod;
        if (psiMethod == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit2/info/MethodLocation", "getPsiElement"));
        }
        return psiMethod;
    }

    @NotNull
    public Project getProject() {
        Project project2 = this.myProject;
        if (project2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit2/info/MethodLocation", "getProject"));
        }
        return project2;
    }

    @Nullable
    public Module getModule() {
        return ModuleUtil.findModuleForPsiElement((PsiElement)this.myMethod);
    }

    public PsiClass getContainingClass() {
        return (PsiClass)this.myClassLocation.getPsiElement();
    }

    @NotNull
    public <T extends PsiElement> Iterator<Location<T>> getAncestors(final Class<T> ancestorClass, boolean strict) {
        final Iterator fromClass = this.myClassLocation.getAncestors(ancestorClass, false);
        if (strict) {
            Iterator iterator = fromClass;
            if (iterator == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit2/info/MethodLocation", "getAncestors"));
            }
            return iterator;
        }
        Iterator iterator = new Iterator<Location<T>>(){
            private boolean myFirstStep;
            {
                this.myFirstStep = ancestorClass.isInstance(MethodLocation.this.myMethod);
            }

            @Override
            public boolean hasNext() {
                return this.myFirstStep || fromClass.hasNext();
            }

            @Override
            public Location<T> next() {
                MethodLocation location = this.myFirstStep ? MethodLocation.this : (Location)fromClass.next();
                this.myFirstStep = false;
                return location;
            }

            @Override
            public void remove() {
                LOG.assertTrue(false);
            }
        };
        if (iterator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/junit2/info/MethodLocation", "getAncestors"));
        }
        return iterator;
    }
}

