/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.HashSet;
import com.intellij.util.graph.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class SourceScope {
    public abstract GlobalSearchScope getGlobalSearchScope();

    public abstract Project getProject();

    public abstract GlobalSearchScope getLibrariesScope();

    public static Map<Module, Collection<Module>> buildAllDependencies(Project project2) {
        Graph graph = ModuleManager.getInstance((Project)project2).moduleGraph();
        HashMap result = new HashMap();
        for (Module module2 : graph.getNodes()) {
            SourceScope.buildDependenciesForModule(module2, (Graph<Module>)graph, (Map<Module, Collection<Module>>)result);
        }
        return result;
    }

    private static void buildDependenciesForModule(Module module2, final Graph<Module> graph, Map<Module, Collection<Module>> map) {
        HashSet deps = new HashSet();
        map.put(module2, (Collection<Module>)deps);
        new Object((Set)deps){
            final /* synthetic */ Set val$deps;
            {
                this.val$deps = set;
            }

            void traverse(Module m) {
                Iterator iterator = graph.getIn((Object)m);
                while (iterator.hasNext()) {
                    Module dep = (Module)iterator.next();
                    if (this.val$deps.contains(dep)) continue;
                    this.val$deps.add(dep);
                    this.traverse(dep);
                }
            }
        }.traverse(module2);
    }

    public static SourceScope wholeProject(final Project project2) {
        return new SourceScope(){

            @Override
            public GlobalSearchScope getGlobalSearchScope() {
                return GlobalSearchScope.allScope((Project)project2);
            }

            @Override
            public Project getProject() {
                return project2;
            }

            @Override
            public Module[] getModulesToCompile() {
                return ModuleManager.getInstance((Project)project2).getModules();
            }

            @Override
            public GlobalSearchScope getLibrariesScope() {
                return this.getGlobalSearchScope();
            }
        };
    }

    public static SourceScope modulesWithDependencies(final Module[] modules) {
        if (modules == null || modules.length == 0) {
            return null;
        }
        return new ModuleSourceScope(modules[0].getProject()){

            @Override
            public GlobalSearchScope getGlobalSearchScope() {
                return SourceScope.evaluateScopesAndUnite(modules, new ScopeForModuleEvaluator(){

                    @Override
                    public GlobalSearchScope evaluate(Module module2) {
                        return GlobalSearchScope.moduleWithDependenciesScope((Module)module2);
                    }
                });
            }

            @Override
            public GlobalSearchScope getLibrariesScope() {
                return SourceScope.evaluateScopesAndUnite(modules, new ScopeForModuleEvaluator(){

                    @Override
                    public GlobalSearchScope evaluate(Module module2) {
                        return new ModuleWithDependenciesAndLibsDependencies(module2);
                    }
                });
            }

            @Override
            public Module[] getModulesToCompile() {
                return modules;
            }
        };
    }

    private static GlobalSearchScope evaluateScopesAndUnite(Module[] modules, ScopeForModuleEvaluator evaluator) {
        GlobalSearchScope scope = evaluator.evaluate(modules[0]);
        for (int i = 1; i < modules.length; ++i) {
            Module module2 = modules[i];
            GlobalSearchScope otherscope = evaluator.evaluate(module2);
            scope = scope.uniteWith(otherscope);
        }
        return scope;
    }

    public static SourceScope modules(final Module[] modules) {
        if (modules == null || modules.length == 0) {
            return null;
        }
        return new ModuleSourceScope(modules[0].getProject()){

            @Override
            public GlobalSearchScope getGlobalSearchScope() {
                return SourceScope.evaluateScopesAndUnite(modules, new ScopeForModuleEvaluator(){

                    @Override
                    public GlobalSearchScope evaluate(Module module2) {
                        return GlobalSearchScope.moduleScope((Module)module2);
                    }
                });
            }

            @Override
            public GlobalSearchScope getLibrariesScope() {
                return SourceScope.evaluateScopesAndUnite(modules, new ScopeForModuleEvaluator(){

                    @Override
                    public GlobalSearchScope evaluate(Module module2) {
                        return GlobalSearchScope.moduleWithLibrariesScope((Module)module2);
                    }
                });
            }

            @Override
            public Module[] getModulesToCompile() {
                return modules;
            }
        };
    }

    public abstract Module[] getModulesToCompile();

    private static class ModuleWithDependenciesAndLibsDependencies
    extends GlobalSearchScope {
        private final GlobalSearchScope myMainScope;
        private final List<GlobalSearchScope> myScopes = new ArrayList<GlobalSearchScope>();

        public ModuleWithDependenciesAndLibsDependencies(Module module2) {
            super(module2.getProject());
            this.myMainScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module2);
            Map<Module, Collection<Module>> map = SourceScope.buildAllDependencies(module2.getProject());
            if (map == null) {
                return;
            }
            Collection<Module> modules = map.get(module2);
            for (Module dependency : modules) {
                this.myScopes.add(GlobalSearchScope.moduleWithLibrariesScope((Module)dependency));
            }
        }

        public boolean contains(@NotNull VirtualFile file2) {
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/execution/testframework/SourceScope$ModuleWithDependenciesAndLibsDependencies", "contains"));
            }
            return this.findScopeFor(file2) != null;
        }

        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/execution/testframework/SourceScope$ModuleWithDependenciesAndLibsDependencies", "compare"));
            }
            if (file2 == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/execution/testframework/SourceScope$ModuleWithDependenciesAndLibsDependencies", "compare"));
            }
            GlobalSearchScope scope = this.findScopeFor(file1);
            assert (scope != null);
            if (scope.contains(file2)) {
                return scope.compare(file1, file2);
            }
            return 0;
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/execution/testframework/SourceScope$ModuleWithDependenciesAndLibsDependencies", "isSearchInModuleContent"));
            }
            return this.myMainScope.isSearchInModuleContent(aModule);
        }

        public boolean isSearchInLibraries() {
            return true;
        }

        @Nullable
        private GlobalSearchScope findScopeFor(VirtualFile file2) {
            if (this.myMainScope.contains(file2)) {
                return this.myMainScope;
            }
            int size = this.myScopes.size();
            for (int i = 0; i < size; ++i) {
                GlobalSearchScope scope = this.myScopes.get(i);
                if (!scope.contains(file2)) continue;
                return scope;
            }
            return null;
        }
    }

    private static interface ScopeForModuleEvaluator {
        public GlobalSearchScope evaluate(Module var1);
    }

    private static abstract class ModuleSourceScope
    extends SourceScope {
        private final Project myProject;

        protected ModuleSourceScope(Project project2) {
            this.myProject = project2;
        }

        @Override
        public Project getProject() {
            return this.myProject;
        }
    }
}

