/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.sm.runner.events;

import com.intellij.execution.testframework.sm.runner.events.TreeNodeEvent;
import com.intellij.openapi.util.text.StringUtil;
import jetbrains.buildServer.messages.serviceMessages.MessageWithAttributes;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessage;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class BaseStartedNodeEvent
extends TreeNodeEvent {
    private final int myParentId;
    private final String myLocationUrl;
    private final String myNodeType;
    private final String myNodeArgs;
    private final boolean myRunning;

    protected BaseStartedNodeEvent(@Nullable String name, int id, int parentId, @Nullable String locationUrl, @Nullable String nodeType, @Nullable String nodeArgs, boolean running) {
        super(name, id);
        this.myParentId = parentId;
        this.myLocationUrl = locationUrl;
        this.myNodeType = nodeType;
        this.myNodeArgs = nodeArgs;
        this.myRunning = running;
    }

    public int getParentId() {
        return this.myParentId;
    }

    @Nullable
    public String getLocationUrl() {
        return this.myLocationUrl;
    }

    @Nullable
    public String getNodeType() {
        return this.myNodeType;
    }

    @Nullable
    public String getNodeArgs() {
        return this.myNodeArgs;
    }

    public boolean isRunning() {
        return this.myRunning;
    }

    @Override
    protected void appendToStringInfo(@NotNull StringBuilder buf) {
        if (buf == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "buf", "com/intellij/execution/testframework/sm/runner/events/BaseStartedNodeEvent", "appendToStringInfo"));
        }
        BaseStartedNodeEvent.append(buf, "parentId", this.myParentId);
        BaseStartedNodeEvent.append(buf, "locationUrl", this.myLocationUrl);
        BaseStartedNodeEvent.append(buf, "running", this.myRunning);
    }

    public static int getParentNodeId(@NotNull MessageWithAttributes message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/execution/testframework/sm/runner/events/BaseStartedNodeEvent", "getParentNodeId"));
        }
        return TreeNodeEvent.getIntAttribute((ServiceMessage)message, "parentNodeId");
    }

    @Nullable
    public static String getNodeType(@NotNull MessageWithAttributes message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/execution/testframework/sm/runner/events/BaseStartedNodeEvent", "getNodeType"));
        }
        return (String)message.getAttributes().get("nodeType");
    }

    @Nullable
    public static String getNodeArgs(@NotNull MessageWithAttributes message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/execution/testframework/sm/runner/events/BaseStartedNodeEvent", "getNodeArgs"));
        }
        return (String)message.getAttributes().get("nodeArgs");
    }

    public static boolean isRunning(@NotNull MessageWithAttributes message) {
        if (message == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/execution/testframework/sm/runner/events/BaseStartedNodeEvent", "isRunning"));
        }
        String runningStr = (String)message.getAttributes().get("running");
        if (StringUtil.isEmpty((String)runningStr)) {
            return true;
        }
        return Boolean.parseBoolean(runningStr);
    }
}

