/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.find.actions;

import com.intellij.codeInsight.hint.HintManager;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.find.FindManager;
import com.intellij.find.FindSettings;
import com.intellij.find.UsagesPreviewPanelProvider;
import com.intellij.find.actions.CompositeActiveComponent;
import com.intellij.find.actions.FindUsagesAction;
import com.intellij.find.actions.FindUsagesInFileAction;
import com.intellij.find.actions.PingEDT;
import com.intellij.find.actions.ShowUsagesTableCellRenderer;
import com.intellij.find.actions.UsageListCellRenderer;
import com.intellij.find.findUsages.AbstractFindUsagesDialog;
import com.intellij.find.findUsages.FindUsagesHandler;
import com.intellij.find.findUsages.FindUsagesManager;
import com.intellij.find.findUsages.FindUsagesOptions;
import com.intellij.find.findUsages.PsiElement2UsageTargetAdapter;
import com.intellij.find.impl.FindManagerImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.gotoByName.ModelDiff;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.PopupAction;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.preview.PreviewManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.PopupChooserBuilder;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.search.SearchScope;
import com.intellij.ui.ActiveComponent;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.InplaceButton;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.SpeedSearchBase;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableUtil;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.AbstractPopup;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.table.JBTable;
import com.intellij.usageView.UsageInfo;
import com.intellij.usageView.UsageViewBundle;
import com.intellij.usageView.UsageViewUtil;
import com.intellij.usages.PsiElementUsageTarget;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.usages.UsageTarget;
import com.intellij.usages.UsageToPsiElementProvider;
import com.intellij.usages.UsageView;
import com.intellij.usages.UsageViewManager;
import com.intellij.usages.UsageViewPresentation;
import com.intellij.usages.UsageViewSettings;
import com.intellij.usages.impl.GroupNode;
import com.intellij.usages.impl.NullUsage;
import com.intellij.usages.impl.UsageAdapter;
import com.intellij.usages.impl.UsageGroupingRuleProviderImpl;
import com.intellij.usages.impl.UsageNode;
import com.intellij.usages.impl.UsageViewImpl;
import com.intellij.usages.impl.UsageViewManagerImpl;
import com.intellij.usages.impl.UsageViewTreeModelBuilder;
import com.intellij.usages.rules.UsageFilteringRuleProvider;
import com.intellij.util.Alarm;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.Processor;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import javax.swing.tree.MutableTreeNode;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ShowUsagesAction
extends AnAction
implements PopupAction {
    public static final String ID = "ShowUsages";
    public static final int USAGES_PAGE_SIZE = 100;
    static final Usage MORE_USAGES_SEPARATOR = NullUsage.INSTANCE;
    static final Usage USAGES_OUTSIDE_SCOPE_SEPARATOR = new UsageAdapter();
    private static final UsageNode MORE_USAGES_SEPARATOR_NODE = UsageViewImpl.NULL_NODE;
    private static final UsageNode USAGES_OUTSIDE_SCOPE_NODE = new UsageNode(USAGES_OUTSIDE_SCOPE_SEPARATOR, new UsageViewTreeModelBuilder(new UsageViewPresentation(), UsageTarget.EMPTY_ARRAY));
    private static final Comparator<UsageNode> USAGE_NODE_COMPARATOR = new Comparator<UsageNode>(){

        @Override
        public int compare(UsageNode c1, UsageNode c2) {
            VirtualFile v2;
            String name2;
            int weight2;
            int weight1;
            if (c1 instanceof StringNode) {
                return 1;
            }
            if (c2 instanceof StringNode) {
                return -1;
            }
            Usage o1 = c1.getUsage();
            Usage o2 = c2.getUsage();
            int n = o1 == USAGES_OUTSIDE_SCOPE_SEPARATOR ? 2 : (weight1 = o1 == MORE_USAGES_SEPARATOR ? 1 : 0);
            int n2 = o2 == USAGES_OUTSIDE_SCOPE_SEPARATOR ? 2 : (weight2 = o2 == MORE_USAGES_SEPARATOR ? 1 : 0);
            if (weight1 != weight2) {
                return weight1 - weight2;
            }
            VirtualFile v1 = UsageListCellRenderer.getVirtualFile(o1);
            String name1 = v1 == null ? null : v1.getName();
            int i = Comparing.compare((Comparable)((Object)name1), (Comparable)((Object)(name2 = (v2 = UsageListCellRenderer.getVirtualFile(o2)) == null ? null : v2.getName())));
            if (i != 0) {
                return i;
            }
            if (o1 instanceof Comparable && o2 instanceof Comparable) {
                return ((Comparable)o1).compareTo(o2);
            }
            FileEditorLocation loc1 = o1.getLocation();
            FileEditorLocation loc2 = o2.getLocation();
            return Comparing.compare((Comparable)loc1, (Comparable)loc2);
        }
    };
    private static final Runnable HIDE_HINTS_ACTION = new Runnable(){

        @Override
        public void run() {
            ShowUsagesAction.hideHints();
        }
    };
    private final boolean myShowSettingsDialogBefore;
    private final UsageViewSettings myUsageViewSettings;
    private Runnable mySearchEverywhereRunnable;
    private int myWidth;

    public ShowUsagesAction() {
        this(false);
    }

    private ShowUsagesAction(boolean showDialogBefore) {
        this.setInjectedContext(true);
        this.myShowSettingsDialogBefore = showDialogBefore;
        UsageViewSettings usageViewSettings = UsageViewSettings.getInstance();
        this.myUsageViewSettings = new UsageViewSettings();
        this.myUsageViewSettings.loadState(usageViewSettings);
        this.myUsageViewSettings.GROUP_BY_FILE_STRUCTURE = false;
        this.myUsageViewSettings.GROUP_BY_MODULE = false;
        this.myUsageViewSettings.GROUP_BY_PACKAGE = false;
        this.myUsageViewSettings.GROUP_BY_USAGE_TYPE = false;
        this.myUsageViewSettings.GROUP_BY_SCOPE = false;
    }

    public void update(@NotNull AnActionEvent e) {
        Object[] usageTargets;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/actions/ShowUsagesAction", "update"));
        }
        FindUsagesInFileAction.updateFindUsagesAction(e);
        if (e.getPresentation().isEnabled() && (usageTargets = (UsageTarget[])e.getData(UsageView.USAGE_TARGETS_KEY)) != null && !(ArrayUtil.getFirstElement((Object[])usageTargets) instanceof PsiElementUsageTarget)) {
            e.getPresentation().setEnabled(false);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        PsiElement element;
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/actions/ShowUsagesAction", "actionPerformed"));
        }
        Project project2 = e.getProject();
        if (project2 == null) {
            return;
        }
        Runnable searchEverywhere = this.mySearchEverywhereRunnable;
        this.mySearchEverywhereRunnable = null;
        ShowUsagesAction.hideHints();
        if (searchEverywhere != null) {
            searchEverywhere.run();
            return;
        }
        final RelativePoint popupPosition = JBPopupFactory.getInstance().guessBestPopupLocation(e.getDataContext());
        PsiDocumentManager.getInstance((Project)project2).commitAllDocuments();
        FeatureUsageTracker.getInstance().triggerFeatureUsed("navigation.goto.usages");
        Object[] usageTargets = (UsageTarget[])e.getData(UsageView.USAGE_TARGETS_KEY);
        final Editor editor = (Editor)e.getData(CommonDataKeys.EDITOR);
        if (usageTargets == null) {
            FindUsagesAction.chooseAmbiguousTargetAndPerform(project2, editor, new PsiElementProcessor<PsiElement>(){

                public boolean execute(@NotNull PsiElement element) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/actions/ShowUsagesAction$3", "execute"));
                    }
                    ShowUsagesAction.this.startFindUsages(element, popupPosition, editor, 100);
                    return false;
                }
            });
        } else if (ArrayUtil.getFirstElement((Object[])usageTargets) instanceof PsiElementUsageTarget && (element = ((PsiElementUsageTarget)usageTargets[0]).getElement()) != null) {
            this.startFindUsages(element, popupPosition, editor, 100);
        }
    }

    private static void hideHints() {
        HintManager.getInstance().hideHints(2, false, false);
    }

    public void startFindUsages(@NotNull PsiElement element, @NotNull RelativePoint popupPosition, Editor editor, int maxUsages) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/actions/ShowUsagesAction", "startFindUsages"));
        }
        if (popupPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "startFindUsages"));
        }
        Project project2 = element.getProject();
        FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)project2)).getFindUsagesManager();
        FindUsagesHandler handler2 = findUsagesManager.getFindUsagesHandler(element, false);
        if (handler2 == null) {
            return;
        }
        if (this.myShowSettingsDialogBefore) {
            this.showDialogAndFindUsages(handler2, popupPosition, editor, maxUsages);
            return;
        }
        this.showElementUsages(editor, popupPosition, handler2, maxUsages, handler2.getFindUsagesOptions(DataManager.getInstance().getDataContext()));
    }

    private void showElementUsages(final Editor editor, final @NotNull RelativePoint popupPosition, final @NotNull FindUsagesHandler handler2, final int maxUsages, final @NotNull FindUsagesOptions options) {
        JBPopup popup;
        if (popupPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "showElementUsages"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/actions/ShowUsagesAction", "showElementUsages"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/actions/ShowUsagesAction", "showElementUsages"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        final UsageViewSettings usageViewSettings = UsageViewSettings.getInstance();
        final UsageViewSettings savedGlobalSettings = new UsageViewSettings();
        savedGlobalSettings.loadState(usageViewSettings);
        usageViewSettings.loadState(this.myUsageViewSettings);
        final Project project2 = handler2.getProject();
        UsageViewManager manager = UsageViewManager.getInstance((Project)project2);
        FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)project2)).getFindUsagesManager();
        final UsageViewPresentation presentation = findUsagesManager.createPresentation(handler2, options);
        presentation.setDetachedMode(true);
        final UsageViewImpl usageView = (UsageViewImpl)manager.createUsageView(UsageTarget.EMPTY_ARRAY, Usage.EMPTY_ARRAY, presentation, null);
        Disposer.register((Disposable)usageView, (Disposable)new Disposable(){

            public void dispose() {
                ShowUsagesAction.this.myUsageViewSettings.loadState(usageViewSettings);
                usageViewSettings.loadState(savedGlobalSettings);
            }
        });
        final AtomicInteger outOfScopeUsages = new AtomicInteger();
        final ArrayList<Usage> usages = new ArrayList<Usage>();
        final LinkedHashSet<UsageNode> visibleNodes = new LinkedHashSet<UsageNode>();
        final MyTable table = new MyTable();
        final AsyncProcessIcon processIcon = new AsyncProcessIcon("xxx");
        ShowUsagesAction.addUsageNodes(usageView.getRoot(), usageView, new ArrayList<UsageNode>());
        List<UsageNode> data = ShowUsagesAction.collectData(usages, visibleNodes, usageView, presentation);
        ShowUsagesAction.setTableModel((JTable)((Object)table), usageView, data, outOfScopeUsages, options.searchScope);
        boolean isPreviewMode = Boolean.TRUE == PreviewManager.SERVICE.preview(handler2.getProject(), UsagesPreviewPanelProvider.ID, Pair.create((Object)usageView, (Object)((Object)table)), false);
        Runnable itemChosenCallback = this.prepareTable(table, editor, popupPosition, handler2, maxUsages, options, isPreviewMode);
        JBPopup jBPopup = popup = isPreviewMode ? null : this.createUsagePopup(usages, visibleNodes, handler2, editor, popupPosition, maxUsages, usageView, options, (JTable)((Object)table), itemChosenCallback, presentation, processIcon);
        if (popup != null) {
            Disposer.register(popup, (Disposable)usageView);
            Alarm alarm = new Alarm((Disposable)usageView);
            alarm.addRequest(new Runnable(){

                @Override
                public void run() {
                    ShowUsagesAction.showPopupIfNeedTo(popup, popupPosition);
                }
            }, 300);
        }
        final PingEDT pingEDT = new PingEDT("Rebuild popup in EDT", new Condition<Object>(){

            public boolean value(Object o) {
                return popup != null && popup.isDisposed();
            }
        }, 100, new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ArrayList copy;
                if (popup != null && popup.isDisposed()) {
                    return;
                }
                ArrayList nodes = new ArrayList();
                List list = usages;
                synchronized (list) {
                    if (!(popup == null || popup.isVisible() || usages.size() > 1 && ShowUsagesAction.showPopupIfNeedTo(popup, popupPosition))) {
                        return;
                    }
                    ShowUsagesAction.addUsageNodes(usageView.getRoot(), usageView, nodes);
                    copy = new ArrayList(usages);
                }
                ShowUsagesAction.this.rebuildTable(usageView, copy, nodes, (JTable)((Object)table), popup, presentation, popupPosition, !processIcon.isDisposed(), outOfScopeUsages, options.searchScope);
            }
        });
        MessageBusConnection messageBusConnection = project2.getMessageBus().connect((Disposable)usageView);
        messageBusConnection.subscribe(UsageFilteringRuleProvider.RULES_CHANGED, (Object)new Runnable(){

            @Override
            public void run() {
                pingEDT.ping();
            }
        });
        final UsageTarget[] myUsageTarget = new UsageTarget[]{new PsiElement2UsageTargetAdapter(handler2.getPsiElement())};
        Processor<Usage> collect = new Processor<Usage>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean process(final @NotNull Usage usage) {
                if (usage == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/find/actions/ShowUsagesAction$9", "process"));
                }
                if (!UsageViewManagerImpl.isInScope((Usage)usage, (SearchScope)options.searchScope)) {
                    if (outOfScopeUsages.getAndIncrement() == 0) {
                        visibleNodes.add(USAGES_OUTSIDE_SCOPE_NODE);
                        usages.add(USAGES_OUTSIDE_SCOPE_SEPARATOR);
                    }
                    return true;
                }
                List list = usages;
                synchronized (list) {
                    if (visibleNodes.size() >= maxUsages) {
                        return false;
                    }
                    if (UsageViewManager.isSelfUsage((Usage)usage, (UsageTarget[])myUsageTarget)) {
                        return true;
                    }
                    UsageNode node = (UsageNode)ApplicationManager.getApplication().runReadAction((Computable)new Computable<UsageNode>(){

                        public UsageNode compute() {
                            return usageView.doAppendUsage(usage);
                        }
                    });
                    usages.add(usage);
                    if (node != null) {
                        visibleNodes.add(node);
                        boolean continueSearch = true;
                        if (visibleNodes.size() == maxUsages) {
                            visibleNodes.add(MORE_USAGES_SEPARATOR_NODE);
                            usages.add(MORE_USAGES_SEPARATOR);
                            continueSearch = false;
                        }
                        pingEDT.ping();
                        return continueSearch;
                    }
                }
                return true;
            }
        };
        final ProgressIndicator indicator = FindUsagesManager.startProcessUsages(handler2, handler2.getPrimaryElements(), handler2.getSecondaryElements(), collect, options, new Runnable(){

            @Override
            public void run() {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Disposer.dispose((Disposable)processIcon);
                        Container parent = processIcon.getParent();
                        if (parent != null) {
                            parent.remove((Component)processIcon);
                            parent.repaint();
                        }
                        pingEDT.ping();
                        List list = usages;
                        synchronized (list) {
                            if (visibleNodes.isEmpty()) {
                                if (usages.isEmpty()) {
                                    String text = UsageViewBundle.message((String)"no.usages.found.in", (Object[])new Object[]{ShowUsagesAction.searchScopePresentableName(options)});
                                    ShowUsagesAction.this.hint(editor, text, handler2, popupPosition, maxUsages, options, false);
                                    ShowUsagesAction.cancel(new JBPopup[]{popup});
                                }
                            } else if (visibleNodes.size() == 1) {
                                if (usages.size() == 1) {
                                    Usage usage = ((UsageNode)visibleNodes.iterator().next()).getUsage();
                                    if (usage == USAGES_OUTSIDE_SCOPE_SEPARATOR) {
                                        ShowUsagesAction.this.hint(editor, UsageViewManagerImpl.outOfScopeMessage((int)outOfScopeUsages.get(), (SearchScope)options.searchScope), handler2, popupPosition, maxUsages, options, true);
                                    } else {
                                        String message = UsageViewBundle.message((String)"show.usages.only.usage", (Object[])new Object[]{ShowUsagesAction.searchScopePresentableName(options)});
                                        ShowUsagesAction.this.navigateAndHint(usage, message, handler2, popupPosition, maxUsages, options);
                                    }
                                    ShowUsagesAction.cancel(new JBPopup[]{popup});
                                } else {
                                    assert (usages.size() > 1) : usages;
                                    Usage visibleUsage = ((UsageNode)visibleNodes.iterator().next()).getUsage();
                                    if (ShowUsagesAction.areAllUsagesInOneLine(visibleUsage, usages)) {
                                        String hint = UsageViewBundle.message((String)"all.usages.are.in.this.line", (Object[])new Object[]{usages.size(), ShowUsagesAction.searchScopePresentableName(options)});
                                        ShowUsagesAction.this.navigateAndHint(visibleUsage, hint, handler2, popupPosition, maxUsages, options);
                                        ShowUsagesAction.cancel(new JBPopup[]{popup});
                                    }
                                }
                            } else if (popup != null) {
                                String title = presentation.getTabText();
                                boolean shouldShowMoreSeparator = visibleNodes.contains(MORE_USAGES_SEPARATOR_NODE);
                                String fullTitle = ShowUsagesAction.getFullTitle(usages, title, shouldShowMoreSeparator, visibleNodes.size() - (shouldShowMoreSeparator ? 1 : 0), false);
                                ((AbstractPopup)popup).setCaption(fullTitle);
                            }
                        }
                    }
                }, project2.getDisposed());
            }
        });
        if (popup != null) {
            Disposer.register((Disposable)popup, (Disposable)new Disposable(){

                public void dispose() {
                    indicator.cancel();
                }
            });
        }
    }

    @NotNull
    private static UsageNode createStringNode(@NotNull Object string) {
        if (string == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/find/actions/ShowUsagesAction", "createStringNode"));
        }
        StringNode stringNode = new StringNode(string);
        if (stringNode == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesAction", "createStringNode"));
        }
        return stringNode;
    }

    private static boolean showPopupIfNeedTo(@NotNull JBPopup popup, @NotNull RelativePoint popupPosition) {
        if (popup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/find/actions/ShowUsagesAction", "showPopupIfNeedTo"));
        }
        if (popupPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "showPopupIfNeedTo"));
        }
        if (!popup.isDisposed() && !popup.isVisible()) {
            popup.show(popupPosition);
            return true;
        }
        return false;
    }

    @NotNull
    private JComponent createHintComponent(@NotNull String text, final @NotNull FindUsagesHandler handler2, final @NotNull RelativePoint popupPosition, final Editor editor, @NotNull Runnable cancelAction, final int maxUsages, final @NotNull FindUsagesOptions options, boolean isWarning) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/find/actions/ShowUsagesAction", "createHintComponent"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/actions/ShowUsagesAction", "createHintComponent"));
        }
        if (popupPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "createHintComponent"));
        }
        if (cancelAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cancelAction", "com/intellij/find/actions/ShowUsagesAction", "createHintComponent"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/actions/ShowUsagesAction", "createHintComponent"));
        }
        JComponent label = HintUtil.createInformationLabel(ShowUsagesAction.suggestSecondInvocation(options, handler2, text + "&nbsp;"));
        if (isWarning) {
            label.setBackground(MessageType.WARNING.getPopupBackground());
        }
        InplaceButton button = this.createSettingsButton(handler2, popupPosition, editor, maxUsages, cancelAction);
        JPanel panel = new JPanel(new BorderLayout()){

            @Override
            public void addNotify() {
                ShowUsagesAction.this.mySearchEverywhereRunnable = new Runnable(){

                    @Override
                    public void run() {
                        ShowUsagesAction.this.searchEverywhere(options, handler2, editor, popupPosition, maxUsages);
                    }
                };
                super.addNotify();
            }

            @Override
            public void removeNotify() {
                ShowUsagesAction.this.mySearchEverywhereRunnable = null;
                super.removeNotify();
            }
        };
        button.setBackground(label.getBackground());
        panel.setBackground(label.getBackground());
        label.setOpaque(false);
        label.setBorder(null);
        panel.setBorder(HintUtil.createHintBorder());
        panel.add((Component)label, "Center");
        panel.add((Component)button, "East");
        JPanel jPanel = panel;
        if (jPanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesAction", "createHintComponent"));
        }
        return jPanel;
    }

    @NotNull
    private InplaceButton createSettingsButton(final @NotNull FindUsagesHandler handler2, final @NotNull RelativePoint popupPosition, final Editor editor, final int maxUsages, final @NotNull Runnable cancelAction) {
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/actions/ShowUsagesAction", "createSettingsButton"));
        }
        if (popupPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "createSettingsButton"));
        }
        if (cancelAction == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cancelAction", "com/intellij/find/actions/ShowUsagesAction", "createSettingsButton"));
        }
        String shortcutText = "";
        KeyboardShortcut shortcut = UsageViewImpl.getShowUsagesWithSettingsShortcut();
        if (shortcut != null) {
            shortcutText = "(" + KeymapUtil.getShortcutText((Shortcut)shortcut) + ")";
        }
        InplaceButton inplaceButton = new InplaceButton("Settings..." + shortcutText, AllIcons.General.Settings, new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        ShowUsagesAction.this.showDialogAndFindUsages(handler2, popupPosition, editor, maxUsages);
                    }
                });
                cancelAction.run();
            }
        });
        if (inplaceButton == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesAction", "createSettingsButton"));
        }
        return inplaceButton;
    }

    private void showDialogAndFindUsages(@NotNull FindUsagesHandler handler2, @NotNull RelativePoint popupPosition, Editor editor, int maxUsages) {
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/actions/ShowUsagesAction", "showDialogAndFindUsages"));
        }
        if (popupPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "showDialogAndFindUsages"));
        }
        AbstractFindUsagesDialog dialog = handler2.getFindUsagesDialog(false, false, false);
        if (dialog.showAndGet()) {
            dialog.calcFindUsagesOptions();
            FindUsagesOptions options = handler2.getFindUsagesOptions(DataManager.getInstance().getDataContext());
            this.showElementUsages(editor, popupPosition, handler2, maxUsages, options);
        }
    }

    @NotNull
    private static String searchScopePresentableName(@NotNull FindUsagesOptions options) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/actions/ShowUsagesAction", "searchScopePresentableName"));
        }
        String string = options.searchScope.getDisplayName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesAction", "searchScopePresentableName"));
        }
        return string;
    }

    @NotNull
    private Runnable prepareTable(final MyTable table, final Editor editor, final RelativePoint popupPosition, final FindUsagesHandler handler2, final int maxUsages, final @NotNull FindUsagesOptions options, boolean previewMode) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/actions/ShowUsagesAction", "prepareTable"));
        }
        MySpeedSearch speedSearch = new MySpeedSearch(table);
        speedSearch.setComparator(new SpeedSearchComparator(false));
        table.setRowHeight(PlatformIcons.CLASS_ICON.getIconHeight() + 2);
        table.setShowGrid(false);
        table.setShowVerticalLines(false);
        table.setShowHorizontalLines(false);
        table.setTableHeader(null);
        table.setAutoResizeMode(3);
        table.setIntercellSpacing(new Dimension(0, 0));
        final AtomicReference selectedUsages = new AtomicReference();
        final AtomicBoolean moreUsagesSelected = new AtomicBoolean();
        final AtomicBoolean outsideScopeUsagesSelected = new AtomicBoolean();
        table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                selectedUsages.set(null);
                outsideScopeUsagesSelected.set(false);
                moreUsagesSelected.set(false);
                ArrayList<Usage> usages = null;
                for (int i : table.getSelectedRows()) {
                    Object value = table.getValueAt(i, 0);
                    if (!(value instanceof UsageNode)) continue;
                    Usage usage = ((UsageNode)value).getUsage();
                    if (usage == USAGES_OUTSIDE_SCOPE_SEPARATOR) {
                        outsideScopeUsagesSelected.set(true);
                        usages = null;
                        break;
                    }
                    if (usage == MORE_USAGES_SEPARATOR) {
                        moreUsagesSelected.set(true);
                        usages = null;
                        break;
                    }
                    if (usages == null) {
                        usages = new ArrayList<Usage>();
                    }
                    usages.add((Usage)(usage instanceof UsageInfo2UsageAdapter ? ((UsageInfo2UsageAdapter)usage).getUsageInfo().copy() : usage));
                }
                selectedUsages.set(usages);
            }
        });
        final Runnable itemChosenCallback = new Runnable(){

            @Override
            public void run() {
                if (moreUsagesSelected.get()) {
                    ShowUsagesAction.this.appendMoreUsages(editor, popupPosition, handler2, maxUsages, options);
                    return;
                }
                if (outsideScopeUsagesSelected.get()) {
                    options.searchScope = GlobalSearchScope.projectScope((Project)handler2.getProject());
                    ShowUsagesAction.this.showElementUsages(editor, popupPosition, handler2, maxUsages, options);
                    return;
                }
                List usages = (List)selectedUsages.get();
                if (usages != null) {
                    for (Object usage : usages) {
                        if (usage instanceof UsageInfo) {
                            UsageViewUtil.navigateTo((UsageInfo)usage, true);
                            continue;
                        }
                        if (!(usage instanceof Navigatable)) continue;
                        ((Navigatable)usage).navigate(true);
                    }
                }
            }
        };
        if (previewMode) {
            table.addMouseListener(new MouseAdapter(){

                @Override
                public void mouseReleased(MouseEvent e) {
                    if (UIUtil.isActionClick((MouseEvent)e, (int)502) && !UIUtil.isSelectionButtonDown((MouseEvent)e) && !e.isConsumed()) {
                        itemChosenCallback.run();
                    }
                }
            });
            table.addKeyListener(new KeyAdapter(){

                @Override
                public void keyPressed(KeyEvent e) {
                    if (e.getKeyCode() == 10) {
                        itemChosenCallback.run();
                    }
                }
            });
        }
        Runnable runnable2 = itemChosenCallback;
        if (runnable2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesAction", "prepareTable"));
        }
        return runnable2;
    }

    @NotNull
    private JBPopup createUsagePopup(@NotNull List<Usage> usages, @NotNull Set<UsageNode> visibleNodes, final @NotNull FindUsagesHandler handler2, final Editor editor, final @NotNull RelativePoint popupPosition, final int maxUsages, @NotNull UsageViewImpl usageView, final @NotNull FindUsagesOptions options, @NotNull JTable table, @NotNull Runnable itemChoseCallback, @NotNull UsageViewPresentation presentation, final @NotNull AsyncProcessIcon processIcon) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/find/actions/ShowUsagesAction", "createUsagePopup"));
        }
        if (visibleNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleNodes", "com/intellij/find/actions/ShowUsagesAction", "createUsagePopup"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/actions/ShowUsagesAction", "createUsagePopup"));
        }
        if (popupPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "createUsagePopup"));
        }
        if (usageView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/intellij/find/actions/ShowUsagesAction", "createUsagePopup"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/actions/ShowUsagesAction", "createUsagePopup"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/find/actions/ShowUsagesAction", "createUsagePopup"));
        }
        if (itemChoseCallback == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "itemChoseCallback", "com/intellij/find/actions/ShowUsagesAction", "createUsagePopup"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/find/actions/ShowUsagesAction", "createUsagePopup"));
        }
        if (processIcon == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processIcon", "com/intellij/find/actions/ShowUsagesAction", "createUsagePopup"));
        }
        PopupChooserBuilder builder = new PopupChooserBuilder(table);
        String title = presentation.getTabText();
        if (title != null) {
            String result = ShowUsagesAction.getFullTitle(usages, title, false, visibleNodes.size() - 1, true);
            builder.setTitle(result);
            builder.setAdText(ShowUsagesAction.getSecondInvocationTitle(options, handler2));
        }
        builder.setMovable(true).setResizable(true);
        builder.setMovable(true).setResizable(true);
        builder.setItemChoosenCallback(itemChoseCallback);
        final JBPopup[] popup = new JBPopup[1];
        KeyboardShortcut shortcut = UsageViewImpl.getShowUsagesWithSettingsShortcut();
        if (shortcut != null) {
            new DumbAwareAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/actions/ShowUsagesAction$18", "actionPerformed"));
                    }
                    ShowUsagesAction.cancel(popup);
                    ShowUsagesAction.this.showDialogAndFindUsages(handler2, popupPosition, editor, maxUsages);
                }
            }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcut.getFirstKeyStroke()), (JComponent)table);
        }
        if ((shortcut = ShowUsagesAction.getShowUsagesShortcut()) != null) {
            new DumbAwareAction(){

                public void actionPerformed(@NotNull AnActionEvent e) {
                    if (e == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/actions/ShowUsagesAction$19", "actionPerformed"));
                    }
                    ShowUsagesAction.cancel(popup);
                    ShowUsagesAction.this.searchEverywhere(options, handler2, editor, popupPosition, maxUsages);
                }
            }.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(shortcut.getFirstKeyStroke()), (JComponent)table);
        }
        InplaceButton settingsButton = this.createSettingsButton(handler2, popupPosition, editor, maxUsages, new Runnable(){

            @Override
            public void run() {
                ShowUsagesAction.cancel(popup);
            }
        });
        ActiveComponent.Adapter spinningProgress = new ActiveComponent.Adapter(){

            public JComponent getComponent() {
                return processIcon;
            }
        };
        DefaultActionGroup pinGroup = new DefaultActionGroup();
        ActiveComponent pin = this.createPinButton(handler2, usageView, options, popup, pinGroup);
        builder.setCommandButton((ActiveComponent)new CompositeActiveComponent(new ActiveComponent[]{spinningProgress, settingsButton, pin}));
        DefaultActionGroup toolbar = new DefaultActionGroup();
        usageView.addFilteringActions(toolbar);
        toolbar.add((AnAction)UsageGroupingRuleProviderImpl.createGroupByFileStructureAction((UsageViewImpl)usageView));
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("UsageViewToolbar", (ActionGroup)toolbar, true);
        actionToolbar.setReservePlaceAutoPopupIcon(false);
        JComponent toolBar = actionToolbar.getComponent();
        toolBar.setOpaque(false);
        builder.setSettingButton((Component)toolBar);
        builder.setCancelKeyEnabled(false);
        popup[0] = builder.createPopup();
        JComponent content = popup[0].getContent();
        this.myWidth = (int)(toolBar.getPreferredSize().getWidth() + new JLabel(ShowUsagesAction.getFullTitle(usages, title, false, visibleNodes.size() - 1, true)).getPreferredSize().getWidth() + settingsButton.getPreferredSize().getWidth());
        this.myWidth = -1;
        for (AnAction action : toolbar.getChildren(null)) {
            action.unregisterCustomShortcutSet(usageView.getComponent());
            action.registerCustomShortcutSet(action.getShortcutSet(), content);
        }
        for (AnAction action : pinGroup.getChildren(null)) {
            action.unregisterCustomShortcutSet(usageView.getComponent());
            action.registerCustomShortcutSet(action.getShortcutSet(), content);
        }
        JBPopup jBPopup = popup[0];
        if (jBPopup == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesAction", "createUsagePopup"));
        }
        return jBPopup;
    }

    private ActiveComponent createPinButton(final @NotNull FindUsagesHandler handler2, final @NotNull UsageViewImpl usageView, final @NotNull FindUsagesOptions options, final @NotNull JBPopup[] popup, @NotNull DefaultActionGroup pinGroup) {
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/actions/ShowUsagesAction", "createPinButton"));
        }
        if (usageView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/intellij/find/actions/ShowUsagesAction", "createPinButton"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/actions/ShowUsagesAction", "createPinButton"));
        }
        if (popup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/find/actions/ShowUsagesAction", "createPinButton"));
        }
        if (pinGroup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pinGroup", "com/intellij/find/actions/ShowUsagesAction", "createPinButton"));
        }
        AnAction pinAction = new AnAction("Open Find Usages Toolwindow", "Show all usages in a separate toolwindow", AllIcons.General.AutohideOff){
            {
                super(arg0, arg1, arg2);
                AnAction action = ActionManager.getInstance().getAction("FindUsages");
                this.setShortcutSet(action.getShortcutSet());
            }

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/find/actions/ShowUsagesAction$22", "actionPerformed"));
                }
                ShowUsagesAction.hideHints();
                ShowUsagesAction.cancel(popup);
                FindUsagesManager findUsagesManager = ((FindManagerImpl)FindManager.getInstance((Project)usageView.getProject())).getFindUsagesManager();
                findUsagesManager.findUsages(handler2.getPrimaryElements(), handler2.getSecondaryElements(), handler2, options, FindSettings.getInstance().isSkipResultsWithOneUsage());
            }
        };
        pinGroup.add(pinAction);
        ActionToolbar pinToolbar = ActionManager.getInstance().createActionToolbar("UsageViewToolbar", (ActionGroup)pinGroup, true);
        pinToolbar.setReservePlaceAutoPopupIcon(false);
        final JComponent pinToolBar = pinToolbar.getComponent();
        pinToolBar.setBorder(null);
        pinToolBar.setOpaque(false);
        return new ActiveComponent.Adapter(){

            public JComponent getComponent() {
                return pinToolBar;
            }
        };
    }

    private static void cancel(JBPopup ... popup) {
        if (popup != null && popup.length > 0 && popup[0] != null) {
            popup[0].cancel();
        }
    }

    @NotNull
    private static String getFullTitle(@NotNull List<Usage> usages, @NotNull String title, boolean hadMoreSeparator, int visibleNodesCount, boolean findUsagesInProgress) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/find/actions/ShowUsagesAction", "getFullTitle"));
        }
        if (title == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/find/actions/ShowUsagesAction", "getFullTitle"));
        }
        String s = hadMoreSeparator ? "<b>Some</b> " + title + " " + "<b>(Only " + visibleNodesCount + " usages shown" + (findUsagesInProgress ? " so far" : "") + ")</b>" : title + " (" + UsageViewBundle.message((String)"usages.n", (Object[])new Object[]{usages.size()}) + (findUsagesInProgress ? " so far" : "") + ")";
        String string = "<html><nobr>" + s + "</nobr></html>";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesAction", "getFullTitle"));
        }
        return string;
    }

    @NotNull
    private static String suggestSecondInvocation(@NotNull FindUsagesOptions options, @NotNull FindUsagesHandler handler2, @NotNull String text) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/actions/ShowUsagesAction", "suggestSecondInvocation"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/actions/ShowUsagesAction", "suggestSecondInvocation"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/find/actions/ShowUsagesAction", "suggestSecondInvocation"));
        }
        String title = ShowUsagesAction.getSecondInvocationTitle(options, handler2);
        if (title != null) {
            text = text + "<br><small> " + title + "</small>";
        }
        String string = XmlStringUtil.wrapInHtml((CharSequence)text);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesAction", "suggestSecondInvocation"));
        }
        return string;
    }

    @Nullable
    private static String getSecondInvocationTitle(@NotNull FindUsagesOptions options, @NotNull FindUsagesHandler handler2) {
        GlobalSearchScope maximalScope;
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/actions/ShowUsagesAction", "getSecondInvocationTitle"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/actions/ShowUsagesAction", "getSecondInvocationTitle"));
        }
        if (ShowUsagesAction.getShowUsagesShortcut() != null && !options.searchScope.equals(maximalScope = FindUsagesManager.getMaximalScope(handler2))) {
            return "Press " + KeymapUtil.getShortcutText((Shortcut)ShowUsagesAction.getShowUsagesShortcut()) + " again to search in " + maximalScope.getDisplayName();
        }
        return null;
    }

    private void searchEverywhere(@NotNull FindUsagesOptions options, @NotNull FindUsagesHandler handler2, Editor editor, @NotNull RelativePoint popupPosition, int maxUsages) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/actions/ShowUsagesAction", "searchEverywhere"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/actions/ShowUsagesAction", "searchEverywhere"));
        }
        if (popupPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "searchEverywhere"));
        }
        FindUsagesOptions cloned = options.clone();
        cloned.searchScope = FindUsagesManager.getMaximalScope(handler2);
        this.showElementUsages(editor, popupPosition, handler2, maxUsages, cloned);
    }

    @Nullable
    private static KeyboardShortcut getShowUsagesShortcut() {
        return ActionManager.getInstance().getKeyboardShortcut(ID);
    }

    private static int filtered(@NotNull List<Usage> usages, @NotNull UsageViewImpl usageView) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/find/actions/ShowUsagesAction", "filtered"));
        }
        if (usageView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/intellij/find/actions/ShowUsagesAction", "filtered"));
        }
        int count = 0;
        for (Usage usage : usages) {
            if (usageView.isVisible(usage)) continue;
            ++count;
        }
        return count;
    }

    private static int getUsageOffset(@NotNull Usage usage) {
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/find/actions/ShowUsagesAction", "getUsageOffset"));
        }
        if (!(usage instanceof UsageInfo2UsageAdapter)) {
            return -1;
        }
        PsiElement element = ((UsageInfo2UsageAdapter)usage).getElement();
        if (element == null) {
            return -1;
        }
        return element.getTextRange().getStartOffset();
    }

    private static boolean areAllUsagesInOneLine(@NotNull Usage visibleUsage, @NotNull List<Usage> usages) {
        if (visibleUsage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleUsage", "com/intellij/find/actions/ShowUsagesAction", "areAllUsagesInOneLine"));
        }
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/find/actions/ShowUsagesAction", "areAllUsagesInOneLine"));
        }
        Editor editor = ShowUsagesAction.getEditorFor(visibleUsage);
        if (editor == null) {
            return false;
        }
        int offset = ShowUsagesAction.getUsageOffset(visibleUsage);
        if (offset == -1) {
            return false;
        }
        int lineNumber = editor.getDocument().getLineNumber(offset);
        for (Usage other : usages) {
            Editor otherEditor = ShowUsagesAction.getEditorFor(other);
            if (otherEditor != editor) {
                return false;
            }
            int otherOffset = ShowUsagesAction.getUsageOffset(other);
            if (otherOffset == -1) {
                return false;
            }
            int otherLine = otherEditor.getDocument().getLineNumber(otherOffset);
            if (otherLine == lineNumber) continue;
            return false;
        }
        return true;
    }

    @NotNull
    private static MyModel setTableModel(@NotNull JTable table, @NotNull UsageViewImpl usageView, @NotNull List<UsageNode> data, @NotNull AtomicInteger outOfScopeUsages, @NotNull SearchScope searchScope) {
        MyModel model;
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/find/actions/ShowUsagesAction", "setTableModel"));
        }
        if (usageView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/intellij/find/actions/ShowUsagesAction", "setTableModel"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/find/actions/ShowUsagesAction", "setTableModel"));
        }
        if (outOfScopeUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outOfScopeUsages", "com/intellij/find/actions/ShowUsagesAction", "setTableModel"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/find/actions/ShowUsagesAction", "setTableModel"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        int columnCount = ShowUsagesAction.calcColumnCount(data);
        MyModel myModel = model = table.getModel() instanceof MyModel ? (MyModel)((Object)table.getModel()) : null;
        if (model == null || model.getColumnCount() != columnCount) {
            model = new MyModel(data, columnCount);
            table.setModel((TableModel)((Object)model));
            ShowUsagesTableCellRenderer renderer = new ShowUsagesTableCellRenderer(usageView, outOfScopeUsages, searchScope);
            for (int i = 0; i < table.getColumnModel().getColumnCount(); ++i) {
                TableColumn column = table.getColumnModel().getColumn(i);
                column.setPreferredWidth(0);
                column.setCellRenderer(renderer);
            }
        }
        MyModel myModel2 = model;
        if (myModel2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesAction", "setTableModel"));
        }
        return myModel2;
    }

    private static int calcColumnCount(@NotNull List<UsageNode> data) {
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/find/actions/ShowUsagesAction", "calcColumnCount"));
        }
        return data.isEmpty() || data.get(0) instanceof StringNode ? 1 : 3;
    }

    @NotNull
    private static List<UsageNode> collectData(@NotNull List<Usage> usages, @NotNull Collection<UsageNode> visibleNodes, @NotNull UsageViewImpl usageView, @NotNull UsageViewPresentation presentation) {
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/find/actions/ShowUsagesAction", "collectData"));
        }
        if (visibleNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visibleNodes", "com/intellij/find/actions/ShowUsagesAction", "collectData"));
        }
        if (usageView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/intellij/find/actions/ShowUsagesAction", "collectData"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/find/actions/ShowUsagesAction", "collectData"));
        }
        ArrayList<UsageNode> data = new ArrayList<UsageNode>();
        int filtered = ShowUsagesAction.filtered(usages, usageView);
        if (filtered != 0) {
            data.add(ShowUsagesAction.createStringNode(UsageViewBundle.message((String)"usages.were.filtered.out", (Object[])new Object[]{filtered})));
        }
        data.addAll(visibleNodes);
        if (data.isEmpty()) {
            String progressText = StringUtil.escapeXml((String)UsageViewManagerImpl.getProgressTitle((UsageViewPresentation)presentation));
            data.add(ShowUsagesAction.createStringNode(progressText));
        }
        Collections.sort(data, USAGE_NODE_COMPARATOR);
        ArrayList<UsageNode> arrayList = data;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesAction", "collectData"));
        }
        return arrayList;
    }

    private static int calcMaxWidth(JTable table) {
        int colsNum = table.getColumnModel().getColumnCount();
        int totalWidth = 0;
        for (int col = 0; col < colsNum - 1; ++col) {
            TableColumn column = table.getColumnModel().getColumn(col);
            int preferred = column.getPreferredWidth();
            int width = Math.max(preferred, ShowUsagesAction.columnMaxWidth(table, col));
            totalWidth += width;
            column.setMinWidth(width);
            column.setMaxWidth(width);
            column.setWidth(width);
            column.setPreferredWidth(width);
        }
        return totalWidth += ShowUsagesAction.columnMaxWidth(table, colsNum - 1);
    }

    private static int columnMaxWidth(@NotNull JTable table, int col) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/find/actions/ShowUsagesAction", "columnMaxWidth"));
        }
        TableColumn column = table.getColumnModel().getColumn(col);
        int width = 0;
        for (int row = 0; row < table.getRowCount(); ++row) {
            Component component = table.prepareRenderer(column.getCellRenderer(), row, col);
            int rendererWidth = component.getPreferredSize().width;
            width = Math.max(width, rendererWidth + table.getIntercellSpacing().width);
        }
        return width;
    }

    private void rebuildTable(@NotNull UsageViewImpl usageView, @NotNull List<Usage> usages, @NotNull List<UsageNode> nodes, @NotNull JTable table, @Nullable JBPopup popup, @NotNull UsageViewPresentation presentation, @NotNull RelativePoint popupPosition, boolean findUsagesInProgress, @NotNull AtomicInteger outOfScopeUsages, @NotNull SearchScope searchScope) {
        int row;
        List existingData;
        List<UsageNode> data;
        MyModel tableModel;
        int newSelection;
        boolean hasOutsideScopeUsages;
        if (usageView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/intellij/find/actions/ShowUsagesAction", "rebuildTable"));
        }
        if (usages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usages", "com/intellij/find/actions/ShowUsagesAction", "rebuildTable"));
        }
        if (nodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nodes", "com/intellij/find/actions/ShowUsagesAction", "rebuildTable"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/find/actions/ShowUsagesAction", "rebuildTable"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "presentation", "com/intellij/find/actions/ShowUsagesAction", "rebuildTable"));
        }
        if (popupPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "rebuildTable"));
        }
        if (outOfScopeUsages == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outOfScopeUsages", "com/intellij/find/actions/ShowUsagesAction", "rebuildTable"));
        }
        if (searchScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchScope", "com/intellij/find/actions/ShowUsagesAction", "rebuildTable"));
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        boolean shouldShowMoreSeparator = usages.contains(MORE_USAGES_SEPARATOR);
        if (shouldShowMoreSeparator) {
            nodes.add(MORE_USAGES_SEPARATOR_NODE);
        }
        if ((hasOutsideScopeUsages = usages.contains(USAGES_OUTSIDE_SCOPE_SEPARATOR)) && !shouldShowMoreSeparator) {
            nodes.add(USAGES_OUTSIDE_SCOPE_NODE);
        }
        String title = presentation.getTabText();
        String fullTitle = ShowUsagesAction.getFullTitle(usages, title, shouldShowMoreSeparator || hasOutsideScopeUsages, nodes.size() - (shouldShowMoreSeparator || hasOutsideScopeUsages ? 1 : 0), findUsagesInProgress);
        if (popup != null) {
            ((AbstractPopup)popup).setCaption(fullTitle);
        }
        if ((newSelection = ShowUsagesAction.updateModel(tableModel = ShowUsagesAction.setTableModel(table, usageView, data = ShowUsagesAction.collectData(usages, nodes, usageView, presentation), outOfScopeUsages, searchScope), existingData = tableModel.getItems(), data, (row = table.getSelectedRow()) == -1 ? 0 : row)) < 0 || newSelection >= tableModel.getRowCount()) {
            ScrollingUtil.ensureSelectionExists((JTable)table);
            newSelection = table.getSelectedRow();
        } else {
            table.getSelectionModel().setSelectionInterval(newSelection, newSelection);
        }
        ScrollingUtil.ensureIndexIsVisible((JTable)table, (int)newSelection, (int)0);
        if (popup != null) {
            this.setSizeAndDimensions(table, popup, popupPosition, data);
        }
    }

    private static int updateModel(@NotNull MyModel tableModel, @NotNull List<UsageNode> listOld, @NotNull List<UsageNode> listNew, int oldSelection) {
        if (tableModel == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tableModel", "com/intellij/find/actions/ShowUsagesAction", "updateModel"));
        }
        if (listOld == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listOld", "com/intellij/find/actions/ShowUsagesAction", "updateModel"));
        }
        if (listNew == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listNew", "com/intellij/find/actions/ShowUsagesAction", "updateModel"));
        }
        Object[] oa = listOld.toArray(new UsageNode[listOld.size()]);
        Object[] na = listNew.toArray(new UsageNode[listNew.size()]);
        List<ModelDiff.Cmd> cmds = ModelDiff.createDiffCmds(tableModel, oa, na);
        int selection = oldSelection;
        if (cmds != null) {
            for (ModelDiff.Cmd cmd : cmds) {
                selection = cmd.translateSelection(selection);
                cmd.apply();
            }
        }
        return selection;
    }

    private void setSizeAndDimensions(@NotNull JTable table, @NotNull JBPopup popup, @NotNull RelativePoint popupPosition, @NotNull List<UsageNode> data) {
        int newWidth;
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/find/actions/ShowUsagesAction", "setSizeAndDimensions"));
        }
        if (popup == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popup", "com/intellij/find/actions/ShowUsagesAction", "setSizeAndDimensions"));
        }
        if (popupPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "setSizeAndDimensions"));
        }
        if (data == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/find/actions/ShowUsagesAction", "setSizeAndDimensions"));
        }
        JComponent content = popup.getContent();
        Window window = SwingUtilities.windowForComponent(content);
        Dimension d = window.getSize();
        int width = ShowUsagesAction.calcMaxWidth(table);
        width = (int)Math.max(d.getWidth(), (double)width);
        Dimension headerSize = ((AbstractPopup)popup).getHeaderPreferredSize();
        width = Math.max((int)headerSize.getWidth(), width);
        width = Math.max(this.myWidth, width);
        if (this.myWidth == -1) {
            this.myWidth = width;
        }
        this.myWidth = newWidth = Math.max(width, d.width + width - this.myWidth);
        int rowsToShow = Math.min(30, data.size());
        Dimension dimension = new Dimension(newWidth, table.getRowHeight() * rowsToShow);
        Rectangle rectangle = ShowUsagesAction.fitToScreen(dimension, popupPosition, table);
        if (!data.isEmpty()) {
            ScrollingUtil.ensureSelectionExists((JTable)table);
        }
        table.setSize(rectangle.getSize());
        Dimension footerSize = ((AbstractPopup)popup).getFooterPreferredSize();
        int footer = footerSize.height;
        int footerBorder = footer == 0 ? 0 : 1;
        Insets insets = ((AbstractPopup)popup).getPopupBorder().getBorderInsets((Component)content);
        rectangle.height += headerSize.height + footer + footerBorder + insets.top + insets.bottom;
        ScreenUtil.fitToScreen((Rectangle)rectangle);
        Dimension newDim = rectangle.getSize();
        window.setBounds(rectangle);
        window.setMinimumSize(newDim);
        window.setMaximumSize(newDim);
        window.validate();
        window.repaint();
    }

    private static Rectangle fitToScreen(@NotNull Dimension newDim, @NotNull RelativePoint popupPosition, JTable table) {
        if (newDim == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newDim", "com/intellij/find/actions/ShowUsagesAction", "fitToScreen"));
        }
        if (popupPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "fitToScreen"));
        }
        Rectangle rectangle = new Rectangle(popupPosition.getScreenPoint(), newDim);
        ScreenUtil.fitToScreen((Rectangle)rectangle);
        if (rectangle.getHeight() != newDim.getHeight()) {
            int newHeight = (int)rectangle.getHeight();
            int roundedHeight = newHeight - newHeight % table.getRowHeight();
            rectangle.setSize((int)rectangle.getWidth(), Math.max(roundedHeight, table.getRowHeight()));
        }
        return rectangle;
    }

    private void appendMoreUsages(Editor editor, @NotNull RelativePoint popupPosition, @NotNull FindUsagesHandler handler2, int maxUsages, @NotNull FindUsagesOptions options) {
        if (popupPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "appendMoreUsages"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/actions/ShowUsagesAction", "appendMoreUsages"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/actions/ShowUsagesAction", "appendMoreUsages"));
        }
        this.showElementUsages(editor, popupPosition, handler2, maxUsages + 100, options);
    }

    private static void addUsageNodes(@NotNull GroupNode root, @NotNull UsageViewImpl usageView, @NotNull List<UsageNode> outNodes) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "root", "com/intellij/find/actions/ShowUsagesAction", "addUsageNodes"));
        }
        if (usageView == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usageView", "com/intellij/find/actions/ShowUsagesAction", "addUsageNodes"));
        }
        if (outNodes == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "outNodes", "com/intellij/find/actions/ShowUsagesAction", "addUsageNodes"));
        }
        for (UsageNode node : root.getUsageNodes()) {
            Usage usage = node.getUsage();
            if (!usageView.isVisible(usage)) continue;
            node.setParent((MutableTreeNode)root);
            outNodes.add(node);
        }
        for (GroupNode groupNode : root.getSubGroups()) {
            groupNode.setParent((MutableTreeNode)root);
            ShowUsagesAction.addUsageNodes(groupNode, usageView, outNodes);
        }
    }

    private void navigateAndHint(@NotNull Usage usage, @Nullable String hint, @NotNull FindUsagesHandler handler2, @NotNull RelativePoint popupPosition, int maxUsages, @NotNull FindUsagesOptions options) {
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/find/actions/ShowUsagesAction", "navigateAndHint"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/actions/ShowUsagesAction", "navigateAndHint"));
        }
        if (popupPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "navigateAndHint"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/actions/ShowUsagesAction", "navigateAndHint"));
        }
        usage.navigate(true);
        if (hint == null) {
            return;
        }
        Editor newEditor = ShowUsagesAction.getEditorFor(usage);
        if (newEditor == null) {
            return;
        }
        this.hint(newEditor, hint, handler2, popupPosition, maxUsages, options, false);
    }

    private void showHint(@Nullable Editor editor, @NotNull String hint, @NotNull FindUsagesHandler handler2, @NotNull RelativePoint popupPosition, int maxUsages, @NotNull FindUsagesOptions options, boolean isWarning) {
        if (hint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hint", "com/intellij/find/actions/ShowUsagesAction", "showHint"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/actions/ShowUsagesAction", "showHint"));
        }
        if (popupPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "showHint"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/actions/ShowUsagesAction", "showHint"));
        }
        JComponent label = this.createHintComponent(hint, handler2, popupPosition, editor, HIDE_HINTS_ACTION, maxUsages, options, isWarning);
        if (editor == null || editor.isDisposed() || !editor.getComponent().isShowing()) {
            HintManager.getInstance().showHint(label, popupPosition, 42, 0);
        } else {
            HintManager.getInstance().showInformationHint(editor, label);
        }
    }

    private void hint(final @Nullable Editor editor, final @NotNull String hint, final @NotNull FindUsagesHandler handler2, final @NotNull RelativePoint popupPosition, final int maxUsages, final @NotNull FindUsagesOptions options, final boolean isWarning) {
        if (hint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hint", "com/intellij/find/actions/ShowUsagesAction", "hint"));
        }
        if (handler2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/find/actions/ShowUsagesAction", "hint"));
        }
        if (popupPosition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "popupPosition", "com/intellij/find/actions/ShowUsagesAction", "hint"));
        }
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/find/actions/ShowUsagesAction", "hint"));
        }
        final Project project2 = handler2.getProject();
        IdeFocusManager.getInstance((Project)project2).doWhenFocusSettlesDown(new Runnable(){

            @Override
            public void run() {
                Runnable runnable2 = new Runnable(){

                    @Override
                    public void run() {
                        IdeFocusManager.getInstance((Project)project2).doWhenFocusSettlesDown(new Runnable(){

                            @Override
                            public void run() {
                                ShowUsagesAction.this.showHint(editor, hint, handler2, popupPosition, maxUsages, options, isWarning);
                            }
                        });
                    }
                };
                if (editor == null) {
                    runnable2.run();
                } else {
                    editor.getScrollingModel().runActionOnScrollingFinished(runnable2);
                }
            }
        });
    }

    @Nullable
    private static Editor getEditorFor(@NotNull Usage usage) {
        if (usage == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "usage", "com/intellij/find/actions/ShowUsagesAction", "getEditorFor"));
        }
        FileEditorLocation location = usage.getLocation();
        FileEditor newFileEditor = location == null ? null : location.getEditor();
        return newFileEditor instanceof TextEditor ? ((TextEditor)newFileEditor).getEditor() : null;
    }

    private static class MySpeedSearch
    extends SpeedSearchBase<JTable> {
        public MySpeedSearch(@NotNull MyTable table) {
            if (table == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/find/actions/ShowUsagesAction$MySpeedSearch", "<init>"));
            }
            super(table);
        }

        @Override
        protected int getSelectedIndex() {
            return this.getTable().getSelectedRow();
        }

        @Override
        protected int convertIndexToModel(int viewIndex) {
            return this.getTable().convertRowIndexToModel(viewIndex);
        }

        @Override
        @NotNull
        protected Object[] getAllElements() {
            Object[] objectArray = ((MyModel)((Object)this.getTable().getModel())).getItems().toArray();
            if (objectArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesAction$MySpeedSearch", "getAllElements"));
            }
            return objectArray;
        }

        @Override
        protected String getElementText(@NotNull Object element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/find/actions/ShowUsagesAction$MySpeedSearch", "getElementText"));
            }
            if (!(element instanceof UsageNode)) {
                return element.toString();
            }
            UsageNode node = (UsageNode)element;
            if (node instanceof StringNode) {
                return "";
            }
            Usage usage = node.getUsage();
            if (usage == MORE_USAGES_SEPARATOR || usage == USAGES_OUTSIDE_SCOPE_SEPARATOR) {
                return "";
            }
            GroupNode group = (GroupNode)node.getParent();
            return group + usage.getPresentation().getPlainText();
        }

        @Override
        protected void selectElement(Object element, String selectedText) {
            List data = ((MyModel)((Object)this.getTable().getModel())).getItems();
            int i = data.indexOf(element);
            if (i == -1) {
                return;
            }
            int viewRow = this.getTable().convertRowIndexToView(i);
            this.getTable().getSelectionModel().setSelectionInterval(viewRow, viewRow);
            TableUtil.scrollSelectionToVisible((JTable)((Object)this.getTable()));
        }

        private MyTable getTable() {
            return (MyTable)((Object)this.myComponent);
        }
    }

    static class StringNode
    extends UsageNode {
        @NotNull
        private final Object myString;

        public StringNode(@NotNull Object string) {
            if (string == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "string", "com/intellij/find/actions/ShowUsagesAction$StringNode", "<init>"));
            }
            super((Usage)NullUsage.INSTANCE, new UsageViewTreeModelBuilder(new UsageViewPresentation(), UsageTarget.EMPTY_ARRAY));
            this.myString = string;
        }

        public String toString() {
            return this.myString.toString();
        }
    }

    private static class MyTable
    extends JBTable
    implements DataProvider {
        private static final int MARGIN = 2;

        public MyTable() {
            ScrollingUtil.installActions((JTable)((Object)this));
            HintUpdateSupply.installSimpleHintUpdateSupply((JComponent)((Object)this));
        }

        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        public Object getData(@NonNls String dataId) {
            int[] selected;
            if (CommonDataKeys.PSI_ELEMENT.is(dataId) && (selected = this.getSelectedRows()).length == 1) {
                return MyTable.getPsiElementForHint(this.getValueAt(selected[0], 0));
            }
            return null;
        }

        public int getRowHeight() {
            return super.getRowHeight() + 4;
        }

        @NotNull
        public Component prepareRenderer(@NotNull TableCellRenderer renderer, int row, int column) {
            if (renderer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/find/actions/ShowUsagesAction$MyTable", "prepareRenderer"));
            }
            Component component = super.prepareRenderer(renderer, row, column);
            if (component instanceof JComponent) {
                ((JComponent)component).setBorder(IdeBorderFactory.createEmptyBorder((int)2, (int)2, (int)2, (int)0));
            }
            Component component2 = component;
            if (component2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesAction$MyTable", "prepareRenderer"));
            }
            return component2;
        }

        @Nullable
        private static PsiElement getPsiElementForHint(Object selectedValue) {
            PsiElement element;
            Usage usage;
            if (selectedValue instanceof UsageNode && (usage = ((UsageNode)selectedValue).getUsage()) instanceof UsageInfo2UsageAdapter && (element = ((UsageInfo2UsageAdapter)usage).getElement()) != null) {
                PsiElement view = UsageToPsiElementProvider.findAppropriateParentFrom((PsiElement)element);
                return view == null ? element : view;
            }
            return null;
        }
    }

    private static class MyModel
    extends ListTableModel<UsageNode>
    implements ModelDiff.Model<Object> {
        private MyModel(@NotNull List<UsageNode> data, int cols) {
            if (data == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "data", "com/intellij/find/actions/ShowUsagesAction$MyModel", "<init>"));
            }
            super(MyModel.cols(cols), data, 0);
        }

        @NotNull
        private static ColumnInfo[] cols(int cols) {
            ColumnInfo<UsageNode, UsageNode> o = new ColumnInfo<UsageNode, UsageNode>(""){

                @Nullable
                public UsageNode valueOf(UsageNode node) {
                    return node;
                }
            };
            List<1> list = Collections.nCopies(cols, o);
            ColumnInfo[] columnInfoArray = list.toArray(new ColumnInfo[list.size()]);
            if (columnInfoArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/find/actions/ShowUsagesAction$MyModel", "cols"));
            }
            return columnInfoArray;
        }

        @Override
        public void addToModel(int idx, Object element) {
            UsageNode node;
            UsageNode usageNode = node = element instanceof UsageNode ? (UsageNode)element : ShowUsagesAction.createStringNode(element);
            if (idx < this.getRowCount()) {
                this.insertRow(idx, node);
            } else {
                this.addRow(node);
            }
        }

        @Override
        public void removeRangeFromModel(int start, int end) {
            for (int i = end; i >= start; --i) {
                this.removeRow(i);
            }
        }
    }
}

