/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.formatting;

import com.intellij.formatting.LeafBlockWrapper;
import com.intellij.formatting.Wrap;
import com.intellij.formatting.WrapType;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

class WrapImpl
extends Wrap {
    private LeafBlockWrapper myChopStartBlock = null;
    private int myWrapOffset = -1;
    private int myFlags;
    private static int ourId = 0;
    private static final Set<WrapImpl> emptyParentsSet = Collections.emptySet();
    private Set<WrapImpl> myParents = emptyParentsSet;
    private Map<WrapImpl, Collection<LeafBlockWrapper>> myIgnoredWraps;
    private static final int IGNORE_PARENT_WRAPS_MASK = 1;
    private static final int ACTIVE_MASK = 2;
    private static final int WRAP_FIRST_ELEMENT_MASK = 4;
    private static final int TYPE_MASK = 24;
    private static final int TYPE_SHIFT = 3;
    private static final int ID_SHIFT = 5;
    private static final int ID_MAX = 0x4000000;
    private static final Type[] myTypes = Type.values();

    public boolean isChildOf(@Nullable WrapImpl wrap, LeafBlockWrapper leaf) {
        Collection<LeafBlockWrapper> leaves;
        if (this.getIgnoreParentWraps()) {
            return false;
        }
        if (leaf != null && this.myIgnoredWraps != null && (leaves = this.myIgnoredWraps.get((Object)wrap)) != null && leaves.contains(leaf)) {
            return false;
        }
        for (WrapImpl parent : this.myParents) {
            if (parent == wrap) {
                return true;
            }
            if (!parent.isChildOf(wrap, leaf)) continue;
            return true;
        }
        return false;
    }

    void registerParent(@Nullable WrapImpl parent) {
        if (parent == this) {
            return;
        }
        if (parent == null) {
            return;
        }
        if (parent.isChildOf(this, null)) {
            return;
        }
        if (this.myParents == emptyParentsSet) {
            this.myParents = new HashSet<WrapImpl>(5);
        }
        this.myParents.add(parent);
    }

    public void reset() {
        this.myChopStartBlock = null;
        this.myWrapOffset = -1;
        this.myFlags &= 0xFFFFFFFD;
    }

    public WrapImpl getParent() {
        if (this.myParents != null && this.myParents.size() == 1) {
            return this.myParents.iterator().next();
        }
        return null;
    }

    public final boolean getIgnoreParentWraps() {
        return (this.myFlags & 1) != 0;
    }

    public void ignoreParentWrap(@Nullable WrapImpl wrap, LeafBlockWrapper currentBlock) {
        if (this.myIgnoredWraps == null) {
            this.myIgnoredWraps = new HashMap<WrapImpl, Collection<LeafBlockWrapper>>(5);
        }
        if (this.myIgnoredWraps.get((Object)wrap) == null) {
            this.myIgnoredWraps.put(wrap, new HashSet(2));
        }
        this.myIgnoredWraps.get((Object)wrap).add(currentBlock);
    }

    LeafBlockWrapper getChopStartBlock() {
        return this.myChopStartBlock;
    }

    void setActive() {
        this.myChopStartBlock = null;
        this.myFlags |= 2;
    }

    void setWrapOffset(int startOffset) {
        if (this.myWrapOffset < 0) {
            this.myWrapOffset = startOffset;
        }
    }

    int getWrapOffset() {
        return this.myWrapOffset;
    }

    public WrapImpl(WrapType type, boolean wrapFirstElement) {
        Type myType;
        switch (type) {
            case NORMAL: {
                myType = Type.WRAP_AS_NEEDED;
                break;
            }
            case NONE: {
                myType = Type.DO_NOT_WRAP;
                break;
            }
            case ALWAYS: {
                myType = Type.WRAP_ALWAYS;
                break;
            }
            default: {
                myType = Type.CHOP_IF_NEEDED;
            }
        }
        int myId = ourId++;
        assert (myId < 0x4000000);
        this.myFlags |= (wrapFirstElement ? 4 : 0) | myType.ordinal() << 3 | myId << 5;
    }

    final Type getType() {
        return myTypes[(this.myFlags & 0x18) >>> 3];
    }

    final boolean isWrapFirstElement() {
        return (this.myFlags & 4) != 0;
    }

    void saveChopBlock(LeafBlockWrapper current) {
        if (this.myChopStartBlock == null) {
            this.myChopStartBlock = current;
        }
    }

    final boolean isActive() {
        return (this.myFlags & 2) != 0;
    }

    public String toString() {
        return this.getType().toString();
    }

    public String getId() {
        return String.valueOf(this.myFlags >>> 5);
    }

    public void ignoreParentWraps() {
        this.myFlags |= 1;
    }

    static enum Type {
        DO_NOT_WRAP,
        WRAP_AS_NEEDED,
        CHOP_IF_NEEDED,
        WRAP_ALWAYS;

    }
}

