/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.revertion;

import com.intellij.history.LocalHistory;
import com.intellij.history.core.Content;
import com.intellij.history.core.Paths;
import com.intellij.history.core.changes.Change;
import com.intellij.history.core.changes.ChangeVisitor;
import com.intellij.history.core.changes.ContentChange;
import com.intellij.history.core.changes.CreateEntryChange;
import com.intellij.history.core.changes.DeleteChange;
import com.intellij.history.core.changes.MoveChange;
import com.intellij.history.core.changes.ROStatusChange;
import com.intellij.history.core.changes.RenameChange;
import com.intellij.history.core.tree.Entry;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.openapi.command.impl.DocumentUndoProvider;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashSet;
import com.intellij.util.io.ReadOnlyAttributeUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class UndoChangeRevertingVisitor
extends ChangeVisitor {
    private final IdeaGateway myGateway;
    private final Set<DelayedApply> myDelayedApplies;
    private final long myFromChangeId;
    private final long myToChangeId;
    private boolean isReverting;

    public UndoChangeRevertingVisitor(IdeaGateway gw, @NotNull Long fromChangeId, @Nullable Long toChangeId) {
        if (fromChangeId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fromChangeId", "com/intellij/history/integration/revertion/UndoChangeRevertingVisitor", "<init>"));
        }
        this.myDelayedApplies = new HashSet();
        this.myGateway = gw;
        this.myFromChangeId = fromChangeId;
        this.myToChangeId = toChangeId == null ? -1L : toChangeId;
    }

    protected boolean shouldRevert(Change c) {
        if (c.getId() == this.myFromChangeId) {
            this.isReverting = true;
        }
        return this.isReverting && !(c instanceof ContentChange);
    }

    protected void checkShouldStop(Change c) throws ChangeVisitor.StopVisitingException {
        if (c.getId() == this.myToChangeId) {
            this.stop();
        }
    }

    @Override
    public void visit(CreateEntryChange c) throws ChangeVisitor.StopVisitingException {
        VirtualFile f;
        if (this.shouldRevert(c) && (f = this.myGateway.findVirtualFile(c.getPath())) != null) {
            this.unregisterDelayedApplies(f);
            try {
                f.delete(LocalHistory.VFS_EVENT_REQUESTOR);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
        this.checkShouldStop(c);
    }

    @Override
    public void visit(ContentChange c) throws ChangeVisitor.StopVisitingException {
        if (this.shouldRevert(c)) {
            try {
                VirtualFile f = this.myGateway.findOrCreateFileSafely(c.getPath(), false);
                this.registerDelayedContentApply(f, c.getOldContent(), c.getOldTimestamp());
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
        this.checkShouldStop(c);
    }

    @Override
    public void visit(RenameChange c) throws ChangeVisitor.StopVisitingException {
        VirtualFile f;
        if (this.shouldRevert(c) && (f = this.myGateway.findVirtualFile(c.getPath())) != null) {
            VirtualFile existing = f.getParent().findChild(c.getOldName());
            try {
                if (existing != null && !Comparing.equal((Object)existing, (Object)f)) {
                    existing.delete(LocalHistory.VFS_EVENT_REQUESTOR);
                }
                f.rename(LocalHistory.VFS_EVENT_REQUESTOR, c.getOldName());
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
        this.checkShouldStop(c);
    }

    @Override
    public void visit(ROStatusChange c) throws ChangeVisitor.StopVisitingException {
        VirtualFile f;
        if (this.shouldRevert(c) && (f = this.myGateway.findVirtualFile(c.getPath())) != null) {
            this.registerDelayedROStatusApply(f, c.getOldStatus());
        }
        this.checkShouldStop(c);
    }

    @Override
    public void visit(MoveChange c) throws ChangeVisitor.StopVisitingException {
        VirtualFile f;
        if (this.shouldRevert(c) && (f = this.myGateway.findVirtualFile(c.getPath())) != null) {
            try {
                VirtualFile parent = this.myGateway.findOrCreateFileSafely(c.getOldParent(), true);
                VirtualFile existing = parent.findChild(f.getName());
                if (existing != null) {
                    existing.delete(LocalHistory.VFS_EVENT_REQUESTOR);
                }
                f.move(LocalHistory.VFS_EVENT_REQUESTOR, parent);
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
        this.checkShouldStop(c);
    }

    @Override
    public void visit(DeleteChange c) throws ChangeVisitor.StopVisitingException {
        if (this.shouldRevert(c)) {
            try {
                VirtualFile parent = this.myGateway.findOrCreateFileSafely(Paths.getParentOf(c.getPath()), true);
                this.revertDeletion(parent, c.getDeletedEntry());
            }
            catch (IOException e) {
                throw new RuntimeIOException(e);
            }
        }
        this.checkShouldStop(c);
    }

    private void revertDeletion(VirtualFile parent, Entry e) throws IOException {
        VirtualFile f = this.myGateway.findOrCreateFileSafely(parent, e.getName(), e.isDirectory());
        if (e.isDirectory()) {
            for (Entry child : e.getChildren()) {
                this.revertDeletion(f, child);
            }
        } else {
            this.registerDelayedContentApply(f, e.getContent(), e.getTimestamp());
            this.registerDelayedROStatusApply(f, e.isReadOnly());
        }
    }

    private void registerDelayedContentApply(VirtualFile f, Content content, long timestamp) {
        this.registerDelayedApply(new DelayedContentApply(f, content, timestamp));
    }

    private void registerDelayedROStatusApply(VirtualFile f, boolean isReadOnly) {
        this.registerDelayedApply(new DelayedROStatusApply(f, isReadOnly));
    }

    private void registerDelayedApply(DelayedApply a) {
        this.myDelayedApplies.remove(a);
        this.myDelayedApplies.add(a);
    }

    private void unregisterDelayedApplies(VirtualFile fileOrDir) {
        ArrayList<DelayedApply> toRemove = new ArrayList<DelayedApply>();
        for (DelayedApply a : this.myDelayedApplies) {
            if (!VfsUtil.isAncestor((VirtualFile)fileOrDir, (VirtualFile)a.getFile(), (boolean)false)) continue;
            toRemove.add(a);
        }
        for (DelayedApply a : toRemove) {
            this.myDelayedApplies.remove(a);
        }
    }

    @Override
    public void finished() {
        try {
            for (DelayedApply a : this.myDelayedApplies) {
                a.apply();
            }
        }
        catch (IOException e) {
            throw new RuntimeIOException(e);
        }
    }

    public static class RuntimeIOException
    extends RuntimeException {
        public RuntimeIOException(Throwable cause) {
            super(cause);
        }
    }

    private static class DelayedROStatusApply
    extends DelayedApply {
        private final boolean isReadOnly;

        private DelayedROStatusApply(VirtualFile f, boolean isReadOnly) {
            super(f);
            this.isReadOnly = isReadOnly;
        }

        @Override
        public void apply() throws IOException {
            ReadOnlyAttributeUtil.setReadOnlyAttribute((VirtualFile)this.myFile, (boolean)this.isReadOnly);
        }
    }

    private static class DelayedContentApply
    extends DelayedApply {
        private final Content myContent;
        private final long myTimestamp;

        public DelayedContentApply(VirtualFile f, Content content, long timestamp) {
            super(f);
            this.myContent = content;
            this.myTimestamp = timestamp;
        }

        @Override
        public void apply() throws IOException {
            if (!this.myContent.isAvailable()) {
                return;
            }
            boolean isReadOnly = !this.myFile.isWritable();
            ReadOnlyAttributeUtil.setReadOnlyAttribute((VirtualFile)this.myFile, (boolean)false);
            Document doc = FileDocumentManager.getInstance().getCachedDocument(this.myFile);
            DocumentUndoProvider.startDocumentUndo(doc);
            try {
                this.myFile.setBinaryContent(this.myContent.getBytes(), -1L, this.myTimestamp);
            }
            finally {
                DocumentUndoProvider.finishDocumentUndo(doc);
            }
            ReadOnlyAttributeUtil.setReadOnlyAttribute((VirtualFile)this.myFile, (boolean)isReadOnly);
        }
    }

    private static abstract class DelayedApply {
        protected VirtualFile myFile;

        protected DelayedApply(VirtualFile f) {
            this.myFile = f;
        }

        public VirtualFile getFile() {
            return this.myFile;
        }

        public abstract void apply() throws IOException;

        public boolean equals(Object o) {
            if (!this.getClass().equals(o.getClass())) {
                return false;
            }
            return this.myFile.equals(((DelayedApply)o).myFile);
        }

        public int hashCode() {
            return this.getClass().hashCode() + 32 * this.myFile.hashCode();
        }
    }
}

