/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.history.integration.ui.actions;

import com.intellij.history.core.LocalHistoryFacade;
import com.intellij.history.integration.IdeaGateway;
import com.intellij.history.integration.LocalHistoryImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.Nullable;

public abstract class LocalHistoryAction
extends AnAction
implements DumbAware {
    public void update(AnActionEvent e) {
        Presentation p = e.getPresentation();
        if (LocalHistoryAction.getEventProject((AnActionEvent)e) == null) {
            p.setVisible(false);
            p.setEnabled(false);
            return;
        }
        p.setVisible(true);
        p.setText(this.getText(e), true);
        LocalHistoryFacade vcs = this.getVcs();
        IdeaGateway gateway = this.getGateway();
        p.setEnabled(vcs != null && gateway != null && this.isEnabled(vcs, gateway, this.getFile(e), e));
    }

    protected String getText(AnActionEvent e) {
        return e.getPresentation().getTextWithMnemonic();
    }

    protected boolean isEnabled(LocalHistoryFacade vcs, IdeaGateway gw, VirtualFile f, AnActionEvent e) {
        return true;
    }

    protected LocalHistoryFacade getVcs() {
        return LocalHistoryImpl.getInstanceImpl().getFacade();
    }

    protected IdeaGateway getGateway() {
        return LocalHistoryImpl.getInstanceImpl().getGateway();
    }

    @Nullable
    protected VirtualFile getFile(AnActionEvent e) {
        VirtualFile[] ff = (VirtualFile[])e.getData(CommonDataKeys.VIRTUAL_FILE_ARRAY);
        if (ff == null || ff.length == 0) {
            return null;
        }
        VirtualFile commonParent = ff[0];
        for (int i = 1; i < ff.length && (commonParent = VfsUtil.getCommonAncestor((VirtualFile)commonParent, (VirtualFile)ff[i])) != null; ++i) {
        }
        return commonParent;
    }
}

