/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.browsers;

import com.google.common.base.CharMatcher;
import com.intellij.ide.browsers.WebBrowser;
import com.intellij.ide.browsers.WebBrowserReferenceConverter;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xmlb.SerializationFilter;
import com.intellij.util.xmlb.SkipDefaultValuesSerializationFilters;
import com.intellij.util.xmlb.XmlSerializer;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Tag(value="browser")
public class StartBrowserSettings {
    private boolean mySelected;
    private WebBrowser myBrowser;
    private String myUrl;
    private boolean myStartJavaScriptDebugger;

    @Attribute(value="start")
    public boolean isSelected() {
        return this.mySelected;
    }

    public void setSelected(boolean selected) {
        this.mySelected = selected;
    }

    @Attribute(value="name", converter=WebBrowserReferenceConverter.class)
    @Nullable
    public WebBrowser getBrowser() {
        return this.myBrowser;
    }

    public void setBrowser(@Nullable WebBrowser value) {
        this.myBrowser = value;
    }

    @Attribute
    @Nullable
    public String getUrl() {
        return this.myUrl;
    }

    public void setUrl(@Nullable String value) {
        String normalized = StringUtil.nullize((String)value, (boolean)true);
        if (normalized != null) {
            normalized = CharMatcher.WHITESPACE.trimFrom((CharSequence)normalized);
        }
        this.myUrl = normalized;
    }

    @Attribute(value="with-js-debugger")
    public boolean isStartJavaScriptDebugger() {
        return this.myStartJavaScriptDebugger;
    }

    public void setStartJavaScriptDebugger(boolean value) {
        this.myStartJavaScriptDebugger = value;
    }

    @NotNull
    public static StartBrowserSettings readExternal(@NotNull Element parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/ide/browsers/StartBrowserSettings", "readExternal"));
        }
        Element state = parent.getChild("browser");
        StartBrowserSettings settings = new StartBrowserSettings();
        if (state != null) {
            XmlSerializer.deserializeInto((Object)settings, (Element)state);
        }
        StartBrowserSettings startBrowserSettings = settings;
        if (startBrowserSettings == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/browsers/StartBrowserSettings", "readExternal"));
        }
        return startBrowserSettings;
    }

    public void writeExternal(@NotNull Element parent) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/ide/browsers/StartBrowserSettings", "writeExternal"));
        }
        Element state = XmlSerializer.serialize((Object)this, (SerializationFilter)new SkipDefaultValuesSerializationFilters());
        if (!JDOMUtil.isEmpty((Element)state)) {
            parent.addContent(state);
        }
    }
}

