/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.fileTemplates.impl;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateDefaultExtension;
import com.intellij.ide.fileTemplates.FileTemplateDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateGroupDescriptor;
import com.intellij.ide.fileTemplates.FileTemplateGroupDescriptorFactory;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.FileTemplateUtil;
import com.intellij.ide.fileTemplates.FileTemplatesScheme;
import com.intellij.ide.fileTemplates.InternalTemplateBean;
import com.intellij.ide.fileTemplates.impl.BundledFileTemplate;
import com.intellij.ide.fileTemplates.impl.ChangeSchemaCombo;
import com.intellij.ide.fileTemplates.impl.CustomFileTemplate;
import com.intellij.ide.fileTemplates.impl.FileTemplateConfigurable;
import com.intellij.ide.fileTemplates.impl.FileTemplateManagerImpl;
import com.intellij.ide.fileTemplates.impl.FileTemplateTab;
import com.intellij.ide.fileTemplates.impl.FileTemplateTabAsList;
import com.intellij.ide.fileTemplates.impl.FileTemplateTabAsTree;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonShortcuts;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.DefaultCompactActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TabbedPaneWrapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AllFileTemplatesConfigurable
implements SearchableConfigurable,
Configurable.NoMargin,
Configurable.NoScroll {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.ide.fileTemplates.impl.AllFileTemplatesConfigurable");
    private static final String TEMPLATES_TITLE = IdeBundle.message((String)"tab.filetemplates.templates", (Object[])new Object[0]);
    private static final String INCLUDES_TITLE = IdeBundle.message((String)"tab.filetemplates.includes", (Object[])new Object[0]);
    private static final String CODE_TITLE = IdeBundle.message((String)"tab.filetemplates.code", (Object[])new Object[0]);
    private static final String OTHER_TITLE = IdeBundle.message((String)"tab.filetemplates.j2ee", (Object[])new Object[0]);
    private final Project myProject;
    private final FileTemplateManager myManager;
    private JPanel myMainPanel;
    private FileTemplateTab myCurrentTab;
    private FileTemplateTab myTemplatesList;
    private FileTemplateTab myIncludesList;
    private FileTemplateTab myCodeTemplatesList;
    @Nullable
    private FileTemplateTab myOtherTemplatesList;
    private JComponent myToolBar;
    private TabbedPaneWrapper myTabbedPane;
    private FileTemplateConfigurable myEditor;
    private boolean myModified = false;
    private JComponent myEditorComponent;
    private JPanel myLeftPanel;
    private FileTemplateTab[] myTabs;
    private Disposable myUIDisposable;
    private final Set<String> myInternalTemplateNames;
    private FileTemplatesScheme myScheme;
    private final Map<FileTemplatesScheme, Map<String, FileTemplate[]>> myChangesCache = new HashMap<FileTemplatesScheme, Map<String, FileTemplate[]>>();
    private static final String CURRENT_TAB = "FileTemplates.CurrentTab";
    private static final String SELECTED_TEMPLATE = "FileTemplates.SelectedTemplate";

    public AllFileTemplatesConfigurable(Project project2) {
        this.myProject = project2;
        this.myManager = FileTemplateManager.getInstance(project2);
        this.myScheme = this.myManager.getCurrentScheme();
        this.myInternalTemplateNames = ContainerUtil.map2Set((Object[])this.myManager.getInternalTemplates(), (Function)new Function<FileTemplate, String>(){

            public String fun(FileTemplate template) {
                return template.getName();
            }
        });
    }

    private void onRemove() {
        this.myCurrentTab.removeSelected();
        this.myModified = true;
    }

    private void onAdd() {
        String ext = "java";
        FileTemplateDefaultExtension[] defaultExtensions = (FileTemplateDefaultExtension[])Extensions.getExtensions(FileTemplateDefaultExtension.EP_NAME);
        if (defaultExtensions.length > 0) {
            ext = defaultExtensions[0].value;
        }
        this.createTemplate(IdeBundle.message((String)"template.unnamed", (Object[])new Object[0]), ext, "");
    }

    private FileTemplate createTemplate(@NotNull String prefName, @NotNull String extension, @NotNull String content) {
        if (prefName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "prefName", "com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable", "createTemplate"));
        }
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable", "createTemplate"));
        }
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "content", "com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable", "createTemplate"));
        }
        FileTemplate[] templates = this.myCurrentTab.getTemplates();
        FileTemplate newTemplate = FileTemplateUtil.createTemplate(prefName, extension, content, templates);
        this.myCurrentTab.addTemplate(newTemplate);
        this.myModified = true;
        this.myCurrentTab.selectTemplate(newTemplate);
        this.fireListChanged();
        this.myEditor.focusToNameField();
        return newTemplate;
    }

    private void onClone() {
        try {
            this.myEditor.apply();
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        FileTemplate selected = this.myCurrentTab.getSelectedTemplate();
        if (selected == null) {
            return;
        }
        FileTemplate[] templates = this.myCurrentTab.getTemplates();
        HashSet<String> names = new HashSet<String>();
        for (FileTemplate template : templates) {
            names.add(template.getName());
        }
        String nameTemplate = IdeBundle.message((String)"template.copy.N.of.T", (Object[])new Object[0]);
        String name = MessageFormat.format(nameTemplate, "", selected.getName());
        int i = 0;
        while (names.contains(name)) {
            name = MessageFormat.format(nameTemplate, ++i + " ", selected.getName());
        }
        CustomFileTemplate newTemplate = new CustomFileTemplate(name, selected.getExtension());
        newTemplate.setText(selected.getText());
        newTemplate.setReformatCode(selected.isReformatCode());
        newTemplate.setLiveTemplateEnabled(selected.isLiveTemplateEnabled());
        this.myCurrentTab.addTemplate(newTemplate);
        this.myModified = true;
        this.myCurrentTab.selectTemplate(newTemplate);
        this.fireListChanged();
    }

    public String getDisplayName() {
        return IdeBundle.message((String)"title.file.templates", (Object[])new Object[0]);
    }

    public String getHelpTopic() {
        int index = this.myTabbedPane.getSelectedIndex();
        switch (index) {
            case 0: {
                return "fileTemplates.templates";
            }
            case 1: {
                return "fileTemplates.includes";
            }
            case 2: {
                return "fileTemplates.code";
            }
            case 3: {
                return "fileTemplates.j2ee";
            }
        }
        throw new IllegalStateException("wrong index: " + index);
    }

    public JComponent createComponent() {
        this.myUIDisposable = Disposer.newDisposable();
        this.myTemplatesList = new FileTemplateTabAsList(TEMPLATES_TITLE){

            @Override
            public void onTemplateSelected() {
                AllFileTemplatesConfigurable.this.onListSelectionChanged();
            }
        };
        this.myIncludesList = new FileTemplateTabAsList(INCLUDES_TITLE){

            @Override
            public void onTemplateSelected() {
                AllFileTemplatesConfigurable.this.onListSelectionChanged();
            }
        };
        this.myCodeTemplatesList = new FileTemplateTabAsList(CODE_TITLE){

            @Override
            public void onTemplateSelected() {
                AllFileTemplatesConfigurable.this.onListSelectionChanged();
            }
        };
        this.myCurrentTab = this.myTemplatesList;
        ArrayList<FileTemplateTab> allTabs = new ArrayList<FileTemplateTab>(Arrays.asList(this.myTemplatesList, this.myIncludesList, this.myCodeTemplatesList));
        final FileTemplateGroupDescriptorFactory[] factories = (FileTemplateGroupDescriptorFactory[])Extensions.getExtensions((ExtensionPointName)FileTemplateGroupDescriptorFactory.EXTENSION_POINT_NAME);
        if (factories.length != 0) {
            this.myOtherTemplatesList = new FileTemplateTabAsTree(OTHER_TITLE){

                @Override
                public void onTemplateSelected() {
                    AllFileTemplatesConfigurable.this.onListSelectionChanged();
                }

                @Override
                protected FileTemplateTabAsTree.FileTemplateNode initModel() {
                    TreeSet<FileTemplateGroupDescriptor> categories = new TreeSet<FileTemplateGroupDescriptor>(new Comparator<FileTemplateGroupDescriptor>(){

                        @Override
                        public int compare(FileTemplateGroupDescriptor o1, FileTemplateGroupDescriptor o2) {
                            return o1.getTitle().compareTo(o2.getTitle());
                        }
                    });
                    for (FileTemplateGroupDescriptorFactory templateGroupFactory : factories) {
                        ContainerUtil.addIfNotNull((Object)templateGroupFactory.getFileTemplatesDescriptor(), categories);
                    }
                    return new FileTemplateTabAsTree.FileTemplateNode("ROOT", null, ContainerUtil.map2List(categories, (Function)new Function<FileTemplateGroupDescriptor, FileTemplateTabAsTree.FileTemplateNode>(){

                        public FileTemplateTabAsTree.FileTemplateNode fun(FileTemplateGroupDescriptor s) {
                            return new FileTemplateTabAsTree.FileTemplateNode((FileTemplateDescriptor)s);
                        }
                    }));
                }
            };
            allTabs.add(this.myOtherTemplatesList);
        }
        this.myEditor = new FileTemplateConfigurable(this.myProject);
        this.myEditor.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AllFileTemplatesConfigurable.this.onEditorChanged();
            }
        });
        this.myEditorComponent = this.myEditor.createComponent();
        this.myEditorComponent.setBorder((Border)JBUI.Borders.empty((int)10, (int)0, (int)10, (int)10));
        this.myTabs = allTabs.toArray(new FileTemplateTab[allTabs.size()]);
        this.myTabbedPane = new TabbedPaneWrapper(this.myUIDisposable);
        this.myTabbedPane.setTabLayoutPolicy(1);
        this.myLeftPanel = new JPanel(new CardLayout());
        this.myLeftPanel.setBorder((Border)JBUI.Borders.empty((int)10, (int)10, (int)10, (int)0));
        for (FileTemplateTab tab : this.myTabs) {
            this.myLeftPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)tab.getComponent()), tab.getTitle());
            JPanel fakePanel = new JPanel();
            fakePanel.setPreferredSize(new Dimension(0, 0));
            this.myTabbedPane.addTab(tab.getTitle(), fakePanel);
        }
        this.myTabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                AllFileTemplatesConfigurable.this.onTabChanged();
            }
        });
        DefaultActionGroup group = new DefaultActionGroup();
        AnAction removeAction = new AnAction(IdeBundle.message((String)"action.remove.template", (Object[])new Object[0]), null, AllIcons.General.Remove){

            public void actionPerformed(AnActionEvent e) {
                AllFileTemplatesConfigurable.this.onRemove();
            }

            public void update(AnActionEvent e) {
                super.update(e);
                FileTemplate selectedItem = AllFileTemplatesConfigurable.this.myCurrentTab.getSelectedTemplate();
                e.getPresentation().setEnabled(selectedItem != null && !AllFileTemplatesConfigurable.isInternalTemplate(selectedItem.getName(), AllFileTemplatesConfigurable.this.myCurrentTab.getTitle()));
            }
        };
        AnAction addAction = new AnAction(IdeBundle.message((String)"action.create.template", (Object[])new Object[0]), null, AllIcons.General.Add){

            public void actionPerformed(AnActionEvent e) {
                AllFileTemplatesConfigurable.this.onAdd();
            }

            public void update(AnActionEvent e) {
                super.update(e);
                e.getPresentation().setEnabled(AllFileTemplatesConfigurable.this.myCurrentTab != AllFileTemplatesConfigurable.this.myCodeTemplatesList && AllFileTemplatesConfigurable.this.myCurrentTab != AllFileTemplatesConfigurable.this.myOtherTemplatesList);
            }
        };
        AnAction cloneAction = new AnAction(IdeBundle.message((String)"action.copy.template", (Object[])new Object[0]), null, PlatformIcons.COPY_ICON){

            public void actionPerformed(AnActionEvent e) {
                AllFileTemplatesConfigurable.this.onClone();
            }

            public void update(AnActionEvent e) {
                super.update(e);
                e.getPresentation().setEnabled(AllFileTemplatesConfigurable.this.myCurrentTab != AllFileTemplatesConfigurable.this.myCodeTemplatesList && AllFileTemplatesConfigurable.this.myCurrentTab != AllFileTemplatesConfigurable.this.myOtherTemplatesList && AllFileTemplatesConfigurable.this.myCurrentTab.getSelectedTemplate() != null);
            }
        };
        AnAction resetAction = new AnAction(IdeBundle.message((String)"action.reset.to.default", (Object[])new Object[0]), null, AllIcons.Actions.Reset){

            public void actionPerformed(AnActionEvent e) {
                AllFileTemplatesConfigurable.this.onReset();
            }

            public void update(AnActionEvent e) {
                super.update(e);
                FileTemplate selectedItem = AllFileTemplatesConfigurable.this.myCurrentTab.getSelectedTemplate();
                e.getPresentation().setEnabled(selectedItem instanceof BundledFileTemplate && !selectedItem.isDefault());
            }
        };
        group.add(addAction);
        group.add(removeAction);
        group.add(cloneAction);
        group.add(resetAction);
        addAction.registerCustomShortcutSet(CommonShortcuts.INSERT, this.myCurrentTab.getComponent());
        removeAction.registerCustomShortcutSet(CommonShortcuts.getDelete(), this.myCurrentTab.getComponent());
        this.myToolBar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)group, true).getComponent();
        this.myToolBar.setBorder(IdeBorderFactory.createEmptyBorder());
        JPanel toolbarPanel = new JPanel(new BorderLayout());
        toolbarPanel.add((Component)this.myToolBar, "West");
        JComponent schemaComponent = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)new DefaultCompactActionGroup(new AnAction[]{new ChangeSchemaCombo(this)}), true).getComponent();
        JPanel schemaPanel = new JPanel(new BorderLayout());
        schemaPanel.add((Component)schemaComponent, "East");
        schemaPanel.add((Component)new JLabel("Schema:"), "West");
        toolbarPanel.add((Component)schemaPanel, "East");
        JPanel centerPanel = new JPanel(new BorderLayout());
        centerPanel.add((Component)this.myTabbedPane.getComponent(), "North");
        Splitter splitter = new Splitter(false, 0.3f);
        splitter.setDividerWidth(JBUI.scale((int)10));
        splitter.setFirstComponent((JComponent)this.myLeftPanel);
        splitter.setSecondComponent(this.myEditorComponent);
        centerPanel.add((Component)splitter, "Center");
        this.myMainPanel = new JPanel(new BorderLayout());
        this.myMainPanel.add((Component)toolbarPanel, "North");
        this.myMainPanel.add((Component)centerPanel, "Center");
        PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
        String tabName = propertiesComponent.getValue(CURRENT_TAB);
        if (this.selectTab(tabName)) {
            // empty if block
        }
        return this.myMainPanel;
    }

    private void onReset() {
        FileTemplate selected = this.myCurrentTab.getSelectedTemplate();
        if (selected instanceof BundledFileTemplate) {
            if (Messages.showOkCancelDialog((String)IdeBundle.message((String)"prompt.reset.to.original.template", (Object[])new Object[0]), (String)IdeBundle.message((String)"title.reset.template", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon()) != 0) {
                return;
            }
            ((BundledFileTemplate)selected).revertToDefaults();
            this.myEditor.reset();
            this.myModified = true;
        }
    }

    private void onEditorChanged() {
        this.fireListChanged();
    }

    private void onTabChanged() {
        this.applyEditor(this.myCurrentTab.getSelectedTemplate());
        int selectedIndex = this.myTabbedPane.getSelectedIndex();
        if (0 <= selectedIndex && selectedIndex < this.myTabs.length) {
            this.myCurrentTab = this.myTabs[selectedIndex];
        }
        ((CardLayout)this.myLeftPanel.getLayout()).show(this.myLeftPanel, this.myCurrentTab.getTitle());
        this.onListSelectionChanged();
    }

    private void onListSelectionChanged() {
        FileTemplate prevTemplate;
        FileTemplate selectedValue = this.myCurrentTab.getSelectedTemplate();
        FileTemplate fileTemplate = prevTemplate = this.myEditor == null ? null : this.myEditor.getTemplate();
        if (prevTemplate != selectedValue) {
            LOG.assertTrue(this.myEditor != null, (Object)("selected:" + selectedValue + "; prev:" + prevTemplate));
            if (Arrays.asList(this.myCurrentTab.getTemplates()).contains(prevTemplate) && !this.applyEditor(prevTemplate)) {
                return;
            }
            if (selectedValue == null) {
                this.myEditor.setTemplate(null, FileTemplateManagerImpl.getInstanceImpl(this.myProject).getDefaultTemplateDescription());
                this.myEditorComponent.repaint();
            } else {
                this.selectTemplate(selectedValue);
            }
        }
    }

    private boolean applyEditor(FileTemplate prevTemplate) {
        if (this.myEditor.isModified()) {
            try {
                this.myModified = true;
                this.myEditor.apply();
                this.fireListChanged();
            }
            catch (ConfigurationException e) {
                if (Arrays.asList(this.myCurrentTab.getTemplates()).contains(prevTemplate)) {
                    this.myCurrentTab.selectTemplate(prevTemplate);
                }
                Messages.showErrorDialog((Component)this.myMainPanel, (String)e.getMessage(), (String)IdeBundle.message((String)"title.cannot.save.current.template", (Object[])new Object[0]));
                return false;
            }
        }
        return true;
    }

    private void selectTemplate(FileTemplate template) {
        URL defDesc = null;
        if (this.myCurrentTab == this.myTemplatesList) {
            defDesc = FileTemplateManagerImpl.getInstanceImpl(this.myProject).getDefaultTemplateDescription();
        } else if (this.myCurrentTab == this.myIncludesList) {
            defDesc = FileTemplateManagerImpl.getInstanceImpl(this.myProject).getDefaultIncludeDescription();
        }
        if (this.myEditor.getTemplate() != template) {
            this.myEditor.setTemplate(template, defDesc);
            boolean isInternal = template != null && AllFileTemplatesConfigurable.isInternalTemplate(template.getName(), this.myCurrentTab.getTitle());
            this.myEditor.setShowInternalMessage(isInternal ? " " : null);
            this.myEditor.setShowAdjustCheckBox(this.myTemplatesList == this.myCurrentTab);
        }
    }

    public static boolean isInternalTemplate(String templateName, String templateTabTitle) {
        if (templateName == null) {
            return false;
        }
        if (Comparing.strEqual((String)templateTabTitle, (String)TEMPLATES_TITLE)) {
            return AllFileTemplatesConfigurable.isInternalTemplateName(templateName);
        }
        if (Comparing.strEqual((String)templateTabTitle, (String)CODE_TITLE)) {
            return true;
        }
        if (Comparing.strEqual((String)templateTabTitle, (String)OTHER_TITLE)) {
            return true;
        }
        if (Comparing.strEqual((String)templateTabTitle, (String)INCLUDES_TITLE)) {
            return Comparing.strEqual((String)templateName, (String)"File Header");
        }
        return false;
    }

    private static boolean isInternalTemplateName(String templateName) {
        for (InternalTemplateBean bean : (InternalTemplateBean[])Extensions.getExtensions(InternalTemplateBean.EP_NAME)) {
            if (!Comparing.strEqual((String)templateName, (String)bean.name)) continue;
            return true;
        }
        return false;
    }

    private void initLists() {
        FileTemplatesScheme scheme = this.myManager.getCurrentScheme();
        this.myManager.setCurrentScheme(this.myScheme);
        this.myTemplatesList.init(this.getTemplates("Default"));
        this.myIncludesList.init(this.getTemplates("Includes"));
        this.myCodeTemplatesList.init(this.getTemplates("Code"));
        if (this.myOtherTemplatesList != null) {
            this.myOtherTemplatesList.init(this.getTemplates("J2EE"));
        }
        this.myManager.setCurrentScheme(scheme);
    }

    private FileTemplate[] getTemplates(String category) {
        Map<String, FileTemplate[]> templates = this.myChangesCache.get(this.myScheme);
        if (templates == null) {
            return this.myManager.getTemplates(category);
        }
        return templates.get(category);
    }

    public boolean isModified() {
        return this.myScheme != this.myManager.getCurrentScheme() || !this.myChangesCache.isEmpty() || this.isSchemeModified();
    }

    private boolean isSchemeModified() {
        return this.myModified || this.myEditor != null && this.myEditor.isModified();
    }

    private void checkCanApply(FileTemplateTab list) throws ConfigurationException {
        FileTemplate[] templates = this.myCurrentTab.getTemplates();
        ArrayList<String> allNames = new ArrayList<String>();
        FileTemplate itemWithError = null;
        boolean errorInName = true;
        String errorString = null;
        for (FileTemplate template : templates) {
            String currName = template.getName();
            if (currName.length() == 0) {
                itemWithError = template;
                errorString = IdeBundle.message((String)"error.please.specify.template.name", (Object[])new Object[0]);
                break;
            }
            if (allNames.contains(currName)) {
                itemWithError = template;
                errorString = "Template with name '" + currName + "' already exists. Please specify a different template name";
                break;
            }
            allNames.add(currName);
        }
        if (itemWithError != null) {
            final boolean _errorInName = errorInName;
            this.myTabbedPane.setSelectedIndex(Arrays.asList(this.myTabs).indexOf(list));
            this.selectTemplate(itemWithError);
            list.selectTemplate(itemWithError);
            ApplicationManager.getApplication().invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (_errorInName) {
                        AllFileTemplatesConfigurable.this.myEditor.focusToNameField();
                    } else {
                        AllFileTemplatesConfigurable.this.myEditor.focusToExtensionField();
                    }
                }
            });
            throw new ConfigurationException(errorString);
        }
    }

    private void fireListChanged() {
        if (this.myCurrentTab != null) {
            this.myCurrentTab.fireDataChanged();
        }
        if (this.myMainPanel != null) {
            this.myMainPanel.revalidate();
        }
    }

    public void apply() throws ConfigurationException {
        if (this.myEditor != null && this.myEditor.isModified()) {
            this.myModified = true;
            this.myEditor.apply();
        }
        for (FileTemplateTab list : this.myTabs) {
            this.checkCanApply(list);
        }
        this.updateCache();
        for (Map.Entry entry : this.myChangesCache.entrySet()) {
            this.myManager.setCurrentScheme((FileTemplatesScheme)entry.getKey());
            this.myManager.setTemplates("Default", Arrays.asList((Object[])((Map)entry.getValue()).get("Default")));
            this.myManager.setTemplates("Internal", Arrays.asList((Object[])((Map)entry.getValue()).get("Internal")));
            this.myManager.setTemplates("Includes", Arrays.asList((Object[])((Map)entry.getValue()).get("Includes")));
            this.myManager.setTemplates("Code", Arrays.asList((Object[])((Map)entry.getValue()).get("Code")));
            this.myManager.setTemplates("J2EE", Arrays.asList((Object[])((Map)entry.getValue()).get("J2EE")));
        }
        this.myChangesCache.clear();
        this.myManager.setCurrentScheme(this.myScheme);
        if (this.myEditor != null) {
            this.myModified = false;
            this.fireListChanged();
        }
    }

    public void selectTemplatesTab() {
        this.selectTab(TEMPLATES_TITLE);
    }

    private boolean selectTab(String tabName) {
        int idx = 0;
        for (FileTemplateTab tab : this.myTabs) {
            if (Comparing.strEqual((String)tab.getTitle(), (String)tabName)) {
                this.myCurrentTab = tab;
                this.myTabbedPane.setSelectedIndex(idx);
                return true;
            }
            ++idx;
        }
        return false;
    }

    public void reset() {
        this.myEditor.reset();
        this.changeScheme(this.myManager.getCurrentScheme());
        this.myChangesCache.clear();
        this.myModified = false;
    }

    public void disposeUIResources() {
        if (this.myCurrentTab != null) {
            PropertiesComponent propertiesComponent = PropertiesComponent.getInstance();
            propertiesComponent.setValue(CURRENT_TAB, this.myCurrentTab.getTitle(), TEMPLATES_TITLE);
            FileTemplate template = this.myCurrentTab.getSelectedTemplate();
            if (template != null) {
                propertiesComponent.setValue(SELECTED_TEMPLATE, template.getName());
            }
        }
        if (this.myEditor != null) {
            this.myEditor.disposeUIResources();
            this.myEditor = null;
            this.myEditorComponent = null;
        }
        this.myMainPanel = null;
        if (this.myUIDisposable != null) {
            Disposer.dispose((Disposable)this.myUIDisposable);
            this.myUIDisposable = null;
        }
        this.myTabbedPane = null;
        this.myToolBar = null;
        this.myTabs = null;
        this.myCurrentTab = null;
        this.myTemplatesList = null;
        this.myCodeTemplatesList = null;
        this.myIncludesList = null;
        this.myOtherTemplatesList = null;
    }

    public FileTemplate createNewTemplate(@NotNull String preferredName, @NotNull String extension, @NotNull String text) {
        if (preferredName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "preferredName", "com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable", "createNewTemplate"));
        }
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "extension", "com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable", "createNewTemplate"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable", "createNewTemplate"));
        }
        return this.createTemplate(preferredName, extension, text);
    }

    @NotNull
    public String getId() {
        if ("fileTemplates" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable", "getId"));
        }
        return "fileTemplates";
    }

    @Nullable
    public Runnable enableSearch(String option) {
        return null;
    }

    public static void editCodeTemplate(final @NotNull String templateId, Project project2) {
        if (templateId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "templateId", "com/intellij/ide/fileTemplates/impl/AllFileTemplatesConfigurable", "editCodeTemplate"));
        }
        ShowSettingsUtil util = ShowSettingsUtil.getInstance();
        final AllFileTemplatesConfigurable configurable = new AllFileTemplatesConfigurable(project2);
        util.editConfigurable(project2, (Configurable)configurable, new Runnable(){

            @Override
            public void run() {
                configurable.myTabbedPane.setSelectedIndex(ArrayUtil.indexOf((Object[])configurable.myTabs, (Object)configurable.myCodeTemplatesList));
                for (FileTemplate template : configurable.myCodeTemplatesList.getTemplates()) {
                    if (!Comparing.equal((String)templateId, (String)template.getName())) continue;
                    configurable.myCodeTemplatesList.selectTemplate(template);
                    break;
                }
            }
        });
    }

    public void changeScheme(FileTemplatesScheme scheme) {
        if (this.myEditor != null && this.myEditor.isModified()) {
            this.myModified = true;
            try {
                this.myEditor.apply();
            }
            catch (ConfigurationException e) {
                Messages.showErrorDialog((Component)this.myEditorComponent, (String)e.getMessage(), (String)e.getTitle());
                return;
            }
        }
        this.updateCache();
        this.myScheme = scheme;
        this.initLists();
    }

    private void updateCache() {
        if (this.isSchemeModified() && !this.myChangesCache.containsKey(this.myScheme)) {
            HashMap<String, FileTemplate[]> templates = new HashMap<String, FileTemplate[]>();
            Object[] allTemplates = this.myTemplatesList.getTemplates();
            templates.put("Default", ContainerUtil.filter((Object[])allTemplates, (Condition)new Condition<FileTemplate>(){

                public boolean value(FileTemplate template) {
                    return !AllFileTemplatesConfigurable.this.myInternalTemplateNames.contains(template.getName());
                }
            }).toArray(FileTemplate.EMPTY_ARRAY));
            templates.put("Internal", ContainerUtil.filter((Object[])allTemplates, (Condition)new Condition<FileTemplate>(){

                public boolean value(FileTemplate template) {
                    return AllFileTemplatesConfigurable.this.myInternalTemplateNames.contains(template.getName());
                }
            }).toArray(FileTemplate.EMPTY_ARRAY));
            templates.put("Includes", this.myIncludesList.getTemplates());
            templates.put("Code", this.myCodeTemplatesList.getTemplates());
            templates.put("J2EE", this.myOtherTemplatesList == null ? FileTemplate.EMPTY_ARRAY : this.myOtherTemplatesList.getTemplates());
            this.myChangesCache.put(this.myScheme, templates);
        }
    }

    public FileTemplateManager getManager() {
        return this.myManager;
    }

    public FileTemplatesScheme getCurrentScheme() {
        return this.myScheme;
    }

    FileTemplateConfigurable getEditor() {
        return this.myEditor;
    }

    FileTemplateTab[] getTabs() {
        return this.myTabs;
    }
}

