/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.navigationToolbar;

import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.ui.ScrollingUtil;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionAdapter;
import javax.swing.BorderFactory;
import javax.swing.JList;
import javax.swing.border.Border;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

class NavBarListWrapper
extends JBScrollPane
implements DataProvider {
    private static final int MAX_SIZE = 20;
    private final JList myList;

    public NavBarListWrapper(final JList list) {
        super((Component)list);
        list.addMouseMotionListener(new MouseMotionAdapter(){
            boolean myIsEngaged = false;

            @Override
            public void mouseMoved(MouseEvent e) {
                if (this.myIsEngaged && !UIUtil.isSelectionButtonDown((MouseEvent)e)) {
                    Point point = e.getPoint();
                    int index = list.locationToIndex(point);
                    list.setSelectedIndex(index);
                } else {
                    this.myIsEngaged = true;
                }
            }
        });
        ScrollingUtil.installActions((JList)list);
        int modelSize = list.getModel().getSize();
        this.setBorder(BorderFactory.createEmptyBorder());
        if (modelSize > 0 && modelSize <= 20) {
            list.setVisibleRowCount(0);
            this.getViewport().setPreferredSize(list.getPreferredSize());
        } else {
            list.setVisibleRowCount(20);
        }
        this.myList = list;
    }

    @Nullable
    public Object getData(@NonNls String dataId) {
        if (PlatformDataKeys.SELECTED_ITEM.is(dataId)) {
            return this.myList.getSelectedValue();
        }
        if (PlatformDataKeys.SELECTED_ITEMS.is(dataId)) {
            return this.myList.getSelectedValues();
        }
        return null;
    }

    public void setBorder(Border border) {
        if (this.myList != null) {
            this.myList.setBorder(border);
        }
    }

    public void requestFocus() {
        this.myList.requestFocus();
    }

    public synchronized void addMouseListener(MouseListener l) {
        this.myList.addMouseListener(l);
    }
}

