/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.passwordSafe.impl;

import com.intellij.util.TimedReference;
import org.jetbrains.annotations.NotNull;

public abstract class PasswordSafeTimed<T>
extends TimedReference<T> {
    private int myCheckCount;

    protected PasswordSafeTimed() {
        super(null);
    }

    protected abstract T compute();

    @NotNull
    public synchronized T get() {
        Object value = super.get();
        if (value == null) {
            value = this.compute();
            this.set(value);
        }
        this.myCheckCount = 0;
        Object object = value;
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/passwordSafe/impl/PasswordSafeTimed", "get"));
        }
        return (T)object;
    }

    protected synchronized boolean checkLocked() {
        int ttlCount = this.getMinutesToLive() * 60 / 60;
        if (ttlCount >= 0 && ++this.myCheckCount > ttlCount) {
            return super.checkLocked();
        }
        return true;
    }

    protected int getMinutesToLive() {
        return 60;
    }
}

