/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.projectView.actions;

import com.intellij.icons.AllIcons;
import com.intellij.ide.projectView.actions.MarkRootActionBase;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.SourceFolder;
import com.intellij.openapi.roots.ui.configuration.ModuleSourceRootEditHandler;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.jps.model.java.JavaModuleSourceRootTypes;
import org.jetbrains.jps.model.java.JavaSourceRootProperties;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;

public class UnmarkGeneratedSourceRootAction
extends MarkRootActionBase {
    public UnmarkGeneratedSourceRootAction() {
        Presentation presentation = this.getTemplatePresentation();
        presentation.setIcon(AllIcons.Modules.SourceRoot);
        ModuleSourceRootEditHandler handler2 = ModuleSourceRootEditHandler.getEditHandler(JavaSourceRootType.SOURCE);
        if (handler2 == null) {
            return;
        }
        String typeName = handler2.getFullRootTypeName();
        presentation.setText("Unmark Generated " + typeName);
        presentation.setDescription("Mark directory as an ordinary " + typeName.toLowerCase(Locale.getDefault()));
    }

    @Override
    protected boolean isEnabled(@NotNull MarkRootActionBase.RootsSelection selection, @NotNull Module module2) {
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/intellij/ide/projectView/actions/UnmarkGeneratedSourceRootAction", "isEnabled"));
        }
        if (module2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/ide/projectView/actions/UnmarkGeneratedSourceRootAction", "isEnabled"));
        }
        for (SourceFolder root : selection.mySelectedRoots) {
            JavaSourceRootProperties properties = (JavaSourceRootProperties)root.getJpsElement().getProperties(JavaModuleSourceRootTypes.SOURCES);
            if (properties == null || !properties.isForGeneratedSources()) continue;
            return true;
        }
        return false;
    }

    @Override
    protected void modifyRoots(@NotNull VirtualFile vFile, @NotNull ContentEntry entry) {
        if (vFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "vFile", "com/intellij/ide/projectView/actions/UnmarkGeneratedSourceRootAction", "modifyRoots"));
        }
        if (entry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "entry", "com/intellij/ide/projectView/actions/UnmarkGeneratedSourceRootAction", "modifyRoots"));
        }
        entry.addSourceFolder(vFile, (JpsModuleSourceRootType)JavaSourceRootType.SOURCE);
    }
}

