/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.IdeView;
import com.intellij.ide.util.DirectoryChooser;
import com.intellij.ide.util.DirectoryChooserModuleTreeView;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.psi.PsiDirectory;
import com.intellij.refactoring.RefactoringBundle;
import java.util.ArrayList;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DirectoryChooserUtil {
    private DirectoryChooserUtil() {
    }

    @Nullable
    public static PsiDirectory getOrChooseDirectory(@NotNull IdeView view) {
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/ide/util/DirectoryChooserUtil", "getOrChooseDirectory"));
        }
        PsiDirectory[] dirs = view.getDirectories();
        if (dirs.length == 0) {
            return null;
        }
        if (dirs.length == 1) {
            return dirs[0];
        }
        Project project2 = dirs[0].getProject();
        return DirectoryChooserUtil.selectDirectory(project2, dirs, null, "");
    }

    @Nullable
    public static PsiDirectory selectDirectory(Project project2, PsiDirectory[] packageDirectories, PsiDirectory defaultDirectory, String postfixToShow) {
        ProjectFileIndex projectFileIndex = ProjectRootManager.getInstance((Project)project2).getFileIndex();
        ArrayList<PsiDirectory> possibleDirs = new ArrayList<PsiDirectory>();
        for (PsiDirectory dir : packageDirectories) {
            if (!dir.isValid() || !dir.isWritable() || possibleDirs.contains(dir) || !projectFileIndex.isInContent(dir.getVirtualFile())) continue;
            possibleDirs.add(dir);
        }
        if (possibleDirs.isEmpty()) {
            return null;
        }
        if (possibleDirs.size() == 1) {
            return (PsiDirectory)possibleDirs.get(0);
        }
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return (PsiDirectory)possibleDirs.get(0);
        }
        DirectoryChooser chooser = new DirectoryChooser(project2);
        chooser.setTitle(IdeBundle.message((String)"title.choose.destination.directory", (Object[])new Object[0]));
        chooser.fillList(possibleDirs.toArray(new PsiDirectory[possibleDirs.size()]), defaultDirectory, project2, postfixToShow);
        return chooser.showAndGet() ? chooser.getSelectedDirectory() : null;
    }

    @Nullable
    public static PsiDirectory chooseDirectory(PsiDirectory[] targetDirectories, @Nullable PsiDirectory initialDirectory, @NotNull Project project2, Map<PsiDirectory, String> relativePathsToCreate) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/ide/util/DirectoryChooserUtil", "chooseDirectory"));
        }
        DirectoryChooser chooser = new DirectoryChooser(project2, new DirectoryChooserModuleTreeView(project2));
        chooser.setTitle(RefactoringBundle.message((String)"choose.destination.directory"));
        chooser.fillList(targetDirectories, initialDirectory, project2, relativePathsToCreate);
        if (!chooser.showAndGet()) {
            return null;
        }
        return chooser.getSelectedDirectory();
    }
}

