/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.importProject;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.importProject.LibraryDescriptor;
import com.intellij.ide.util.importProject.ModuleDescriptor;
import com.intellij.ide.util.importProject.ModuleInsight;
import com.intellij.ide.util.importProject.ModulesLayoutPanel;
import com.intellij.ide.util.importProject.ProjectDescriptor;
import com.intellij.ide.util.projectWizard.AbstractStepWithProgress;
import com.intellij.ide.util.projectWizard.importSources.DetectedProjectRoot;
import com.intellij.ide.util.projectWizard.importSources.ProjectFromSourcesBuilder;
import com.intellij.ide.util.projectWizard.importSources.ProjectStructureDetector;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.text.StringUtil;
import java.awt.Component;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import org.jetbrains.annotations.NonNls;

public class ModulesDetectionStep
extends AbstractStepWithProgress<List<ModuleDescriptor>> {
    private final ProjectStructureDetector myDetector;
    private final ProjectFromSourcesBuilder myBuilder;
    private final ProjectDescriptor myProjectDescriptor;
    private final ModuleInsight myInsight;
    private final Icon myIcon;
    private final String myHelpId;
    private ModulesLayoutPanel myModulesLayoutPanel;
    int myPreviousStateHashCode = -1;

    public ModulesDetectionStep(ProjectStructureDetector detector, ProjectFromSourcesBuilder builder, ProjectDescriptor projectDescriptor, ModuleInsight insight, Icon icon, @NonNls String helpId) {
        super("Stop module analysis?");
        this.myDetector = detector;
        this.myBuilder = builder;
        this.myProjectDescriptor = projectDescriptor;
        this.myInsight = insight;
        this.myIcon = icon;
        this.myHelpId = helpId;
    }

    public void updateDataModel() {
        this.myProjectDescriptor.setModules(this.myModulesLayoutPanel.getChosenEntries());
    }

    @Override
    protected JComponent createResultsPanel() {
        this.myModulesLayoutPanel = new ModulesLayoutPanel(this.myInsight, new ModulesLayoutPanel.LibraryFilter(){

            @Override
            public boolean isLibraryChosen(LibraryDescriptor libDescriptor) {
                return ModulesDetectionStep.this.myProjectDescriptor.isLibraryChosen(libDescriptor);
            }
        });
        return this.myModulesLayoutPanel;
    }

    @Override
    protected String getProgressText() {
        return "Searching for modules. Please wait.";
    }

    @Override
    protected boolean shouldRunProgress() {
        int currentHash = this.calcStateHashCode();
        try {
            boolean bl = currentHash != this.myPreviousStateHashCode;
            return bl;
        }
        finally {
            this.myPreviousStateHashCode = currentHash;
        }
    }

    private int calcStateHashCode() {
        String contentEntryPath = this.myBuilder.getBaseProjectPath();
        int hash = contentEntryPath != null ? contentEntryPath.hashCode() : 1;
        for (DetectedProjectRoot root : this.myBuilder.getProjectRoots(this.myDetector)) {
            hash = 31 * hash + root.getDirectory().hashCode();
        }
        List<LibraryDescriptor> libs = this.myProjectDescriptor.getLibraries();
        for (LibraryDescriptor lib : libs) {
            Collection<File> files = lib.getJars();
            for (File file2 : files) {
                hash = 31 * hash + file2.hashCode();
            }
        }
        return hash;
    }

    @Override
    protected List<ModuleDescriptor> calculate() {
        this.myInsight.scanModules();
        List<ModuleDescriptor> suggestedModules = this.myInsight.getSuggestedModules();
        return suggestedModules != null ? suggestedModules : Collections.emptyList();
    }

    @Override
    public boolean validate() throws ConfigurationException {
        boolean validated = super.validate();
        if (!validated) {
            return false;
        }
        List modules = this.myModulesLayoutPanel.getChosenEntries();
        LinkedHashMap<String, ModuleDescriptor> errors = new LinkedHashMap<String, ModuleDescriptor>();
        for (ModuleDescriptor module2 : modules) {
            try {
                String moduleFilePath = module2.computeModuleFilePath();
                if (!new File(moduleFilePath).exists()) continue;
                errors.put(IdeBundle.message((String)"warning.message.the.module.file.0.already.exist.and.will.be.overwritten", (Object[])new Object[]{moduleFilePath}), module2);
            }
            catch (InvalidDataException e) {
                errors.put(e.getMessage(), module2);
            }
        }
        if (!errors.isEmpty()) {
            int answer = Messages.showYesNoCancelDialog((Component)this.getComponent(), (String)IdeBundle.message((String)"warning.text.0.do.you.want.to.overwrite.these.files", (Object[])new Object[]{StringUtil.join(errors.keySet(), (String)"\n"), errors.size()}), (String)IdeBundle.message((String)"title.file.already.exists", (Object[])new Object[0]), (String)"Overwrite", (String)"Reuse", (String)"Cancel", (Icon)Messages.getQuestionIcon());
            if (answer == 2) {
                return false;
            }
            if (answer != 0) {
                for (ModuleDescriptor moduleDescriptor : errors.values()) {
                    moduleDescriptor.reuseExisting(true);
                }
            }
        }
        return true;
    }

    @Override
    protected void onFinished(List<ModuleDescriptor> moduleDescriptors, boolean canceled) {
        this.myModulesLayoutPanel.rebuild();
    }

    @NonNls
    public String getHelpId() {
        return this.myHelpId;
    }

    public Icon getIcon() {
        return this.myIcon;
    }
}

