/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.newProjectWizard;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.newProjectWizard.AbstractProjectWizard;
import com.intellij.ide.util.newProjectWizard.StepSequence;
import com.intellij.ide.util.newProjectWizard.modes.CreateFromTemplateMode;
import com.intellij.ide.util.newProjectWizard.modes.ImportMode;
import com.intellij.ide.util.newProjectWizard.modes.WizardMode;
import com.intellij.ide.util.projectWizard.ModuleWizardStep;
import com.intellij.ide.util.projectWizard.ProjectBuilder;
import com.intellij.ide.util.projectWizard.WizardContext;
import com.intellij.ide.wizard.Step;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.DefaultModulesProvider;
import com.intellij.openapi.roots.ui.configuration.ModulesProvider;
import com.intellij.openapi.util.Condition;
import com.intellij.projectImport.ProjectImportBuilder;
import com.intellij.projectImport.ProjectImportProvider;
import com.intellij.util.Function;
import java.awt.Component;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AddModuleWizard
extends AbstractProjectWizard {
    private static final String ADD_MODULE_TITLE = IdeBundle.message((String)"title.add.module", (Object[])new Object[0]);
    private static final String NEW_PROJECT_TITLE = IdeBundle.message((String)"title.new.project", (Object[])new Object[0]);
    private ProjectImportProvider[] myImportProviders;
    private final ModulesProvider myModulesProvider;
    private WizardMode myWizardMode;

    public AddModuleWizard(@Nullable Project project2, @NotNull ModulesProvider modulesProvider, @Nullable String defaultPath) {
        if (modulesProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesProvider", "com/intellij/ide/util/newProjectWizard/AddModuleWizard", "<init>"));
        }
        super(project2 == null ? NEW_PROJECT_TITLE : ADD_MODULE_TITLE, project2, defaultPath);
        this.myModulesProvider = modulesProvider;
        this.initModuleWizard(project2, defaultPath);
    }

    public AddModuleWizard(Component parent, Project project2, @NotNull ModulesProvider modulesProvider) {
        if (modulesProvider == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "modulesProvider", "com/intellij/ide/util/newProjectWizard/AddModuleWizard", "<init>"));
        }
        super(project2 == null ? NEW_PROJECT_TITLE : ADD_MODULE_TITLE, project2, parent);
        this.myModulesProvider = modulesProvider;
        this.initModuleWizard(project2, null);
    }

    public AddModuleWizard(@Nullable Project project2, String filePath, ProjectImportProvider ... importProviders) {
        super(AddModuleWizard.getImportWizardTitle(project2, importProviders), project2, filePath);
        this.myImportProviders = importProviders;
        this.myModulesProvider = DefaultModulesProvider.createForProject((Project)project2);
        this.initModuleWizard(project2, filePath);
    }

    public AddModuleWizard(Project project2, Component dialogParent, String filePath, ProjectImportProvider ... importProviders) {
        super(AddModuleWizard.getImportWizardTitle(project2, importProviders), project2, dialogParent);
        this.myImportProviders = importProviders;
        this.myModulesProvider = DefaultModulesProvider.createForProject((Project)project2);
        this.initModuleWizard(project2, filePath);
    }

    private static String getImportWizardTitle(Project project2, ProjectImportProvider ... providers) {
        StringBuilder builder = new StringBuilder("Import ");
        builder.append(project2 == null ? "Project" : "Module");
        if (providers.length == 1) {
            builder.append(" from ").append(providers[0].getName());
        }
        return builder.toString();
    }

    private void initModuleWizard(@Nullable Project project2, @Nullable String defaultPath) {
        this.myWizardContext.addContextListener(new WizardContext.Listener(){

            public void buttonsUpdateRequested() {
                AddModuleWizard.this.updateButtons();
            }

            public void nextStepRequested() {
                AddModuleWizard.this.doNextAction();
            }
        });
        if (this.myImportProviders == null) {
            this.myWizardMode = new CreateFromTemplateMode();
            this.appendSteps(this.myWizardMode.getSteps(this.myWizardContext, this.myModulesProvider));
        } else {
            this.myWizardMode = new ImportMode(this.myImportProviders);
            StepSequence sequence = this.myWizardMode.getSteps(this.myWizardContext, DefaultModulesProvider.createForProject((Project)project2));
            this.appendSteps(sequence);
            for (ProjectImportProvider provider : this.myImportProviders) {
                provider.getBuilder().setFileToImport(defaultPath);
            }
            if (this.myImportProviders.length == 1) {
                ProjectImportBuilder builder = this.myImportProviders[0].getBuilder();
                this.myWizardContext.setProjectBuilder((ProjectBuilder)builder);
                builder.setUpdate(this.getWizardContext().getProject() != null);
            }
        }
        this.init();
    }

    private void appendSteps(@Nullable StepSequence sequence) {
        if (sequence != null) {
            for (ModuleWizardStep step : sequence.getAllSteps()) {
                this.addStep((Step)step);
            }
        }
    }

    @Override
    public StepSequence getSequence() {
        return this.myWizardMode.getSteps(this.myWizardContext, this.myModulesProvider);
    }

    @Nullable
    public static Sdk getMostRecentSuitableSdk(WizardContext context) {
        if (context.getProject() == null) {
            final ProjectBuilder projectBuilder = context.getProjectBuilder();
            return ProjectJdkTable.getInstance().findMostRecentSdk((Condition)new Condition<Sdk>(){

                public boolean value(Sdk sdk) {
                    return projectBuilder == null || projectBuilder.isSuitableSdkType(sdk.getSdkType());
                }
            });
        }
        return null;
    }

    @NotNull
    public WizardContext getWizardContext() {
        WizardContext wizardContext = this.myWizardContext;
        if (wizardContext == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ide/util/newProjectWizard/AddModuleWizard", "getWizardContext"));
        }
        return wizardContext;
    }

    protected String getDimensionServiceKey() {
        return "NewModule_or_Project.wizard";
    }

    public boolean navigateToStep(@NotNull Function<Step, Boolean> filter) {
        if (filter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filter", "com/intellij/ide/util/newProjectWizard/AddModuleWizard", "navigateToStep"));
        }
        int myStepsSize = this.mySteps.size();
        for (int i = 0; i < myStepsSize; ++i) {
            ModuleWizardStep step = (ModuleWizardStep)this.mySteps.get(i);
            if (filter.fun((Object)step) != Boolean.TRUE) continue;
            this.myCurrentStep = i;
            this.updateStep();
            return true;
        }
        return false;
    }

    public void commit() {
        this.commitStepData((ModuleWizardStep)this.getCurrentStepObject());
    }
}

