/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.projectWizard.importSources.util;

import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.NullableFunction;
import com.intellij.util.text.StringFactory;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.jetbrains.annotations.Nullable;

public abstract class CommonSourceRootDetectionUtil<F> {
    public static final CommonSourceRootDetectionUtil<File> IO_FILE = new CommonSourceRootDetectionUtil<File>(){

        @Override
        protected String getName(File file2) {
            return file2.getName();
        }

        @Override
        protected File getParentFile(File file2) {
            return file2.getParentFile();
        }

        @Override
        protected CharSequence loadText(File file2) throws IOException {
            return StringFactory.createShared((char[])CommonSourceRootDetectionUtil.loadFileTextSkippingBom(file2));
        }

        @Override
        protected boolean isFile(File file2) {
            return file2.isFile();
        }
    };
    public static final CommonSourceRootDetectionUtil<VirtualFile> VIRTUAL_FILE = new CommonSourceRootDetectionUtil<VirtualFile>(){

        @Override
        protected String getName(VirtualFile file2) {
            return file2.getName();
        }

        @Override
        protected VirtualFile getParentFile(VirtualFile file2) {
            return file2.getParent();
        }

        @Override
        protected CharSequence loadText(VirtualFile file2) throws IOException {
            return VfsUtilCore.loadText((VirtualFile)file2);
        }

        @Override
        protected boolean isFile(VirtualFile file2) {
            return !file2.isDirectory();
        }
    };

    protected CommonSourceRootDetectionUtil() {
    }

    @Nullable
    public Pair<F, String> suggestRootForFileWithPackageStatement(F file2, F topmostPossibleRoot, NullableFunction<CharSequence, String> packageNameFetcher, boolean packagePrefixSupported) {
        CharSequence chars;
        if (!this.isFile(file2)) {
            return null;
        }
        try {
            chars = this.loadText(file2);
        }
        catch (IOException e) {
            return null;
        }
        String packageName = (String)packageNameFetcher.fun((Object)chars);
        if (packageName != null) {
            F root = this.getParentFile(file2);
            int index = packageName.length();
            while (index > 0) {
                boolean equalsToToken;
                int index1 = packageName.lastIndexOf(46, index - 1);
                String token = packageName.substring(index1 + 1, index);
                String dirName = this.getName(root);
                boolean bl = equalsToToken = SystemInfo.isFileSystemCaseSensitive ? dirName.equals(token) : dirName.equalsIgnoreCase(token);
                if (!equalsToToken || root.equals(topmostPossibleRoot)) {
                    String packagePrefix = packageName.substring(0, index);
                    if (!packagePrefixSupported && packagePrefix.length() > 0) {
                        return null;
                    }
                    return Pair.create(root, (Object)packagePrefix);
                }
                if ((root = this.getParentFile(root)) == null) {
                    return null;
                }
                index = index1;
            }
            return Pair.create(root, (Object)"");
        }
        return null;
    }

    protected abstract String getName(F var1);

    @Nullable
    protected abstract F getParentFile(F var1);

    protected abstract CharSequence loadText(F var1) throws IOException;

    protected abstract boolean isFile(F var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static char[] loadFileTextSkippingBom(File file2) throws IOException {
        InputStream stream = CharsetToolkit.inputStreamSkippingBOM((InputStream)new BufferedInputStream(new FileInputStream(file2)));
        try (InputStreamReader reader = new InputStreamReader(stream);){
            char[] cArray = FileUtilRt.loadText((Reader)reader, (int)((int)file2.length()));
            return cArray;
        }
    }
}

