/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.scopeChooser;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.util.scopeChooser.ScopeChooserConfigurable;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.newEditor.SettingsDialog;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.InputValidator;
import com.intellij.openapi.ui.Messages;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class EditScopesDialog
extends SettingsDialog {
    private NamedScope mySelectedScope;
    private final Project myProject;
    private final ScopeChooserConfigurable myConfigurable;
    private final boolean myCheckShared;

    public EditScopesDialog(Project project2, ScopeChooserConfigurable configurable, boolean checkShared) {
        super(project2, "scopes", (Configurable)configurable, true, false);
        this.myProject = project2;
        this.myConfigurable = configurable;
        this.myCheckShared = checkShared;
    }

    @Override
    public void doOKAction() {
        String newName;
        Project project2;
        DependencyValidationManager manager;
        NamedScope scope;
        Object selectedObject = this.myConfigurable.getSelectedObject();
        this.mySelectedScope = selectedObject instanceof NamedScope ? (NamedScope)selectedObject : null;
        super.doOKAction();
        if (this.myCheckShared && this.mySelectedScope != null && (scope = (manager = DependencyValidationManager.getInstance((Project)(project2 = this.myProject))).getScope(this.mySelectedScope.getName())) == null && Messages.showYesNoDialog((String)IdeBundle.message((String)"scope.unable.to.save.scope.message", (Object[])new Object[0]), (String)IdeBundle.message((String)"scope.unable.to.save.scope.title", (Object[])new Object[0]), (Icon)Messages.getErrorIcon()) == 0 && (newName = Messages.showInputDialog((Project)project2, (String)IdeBundle.message((String)"add.scope.name.label", (Object[])new Object[0]), (String)IdeBundle.message((String)"scopes.save.dialog.title.shared", (Object[])new Object[0]), (Icon)Messages.getQuestionIcon(), (String)this.mySelectedScope.getName(), (InputValidator)new InputValidator(){

            public boolean checkInput(String inputString) {
                return inputString != null && inputString.length() > 0 && manager.getScope(inputString) == null;
            }

            public boolean canClose(String inputString) {
                return this.checkInput(inputString);
            }
        })) != null) {
            PackageSet packageSet = this.mySelectedScope.getValue();
            this.mySelectedScope = scope = new NamedScope(newName, packageSet != null ? packageSet.createCopy() : null);
            manager.addScope(this.mySelectedScope);
        }
    }

    public static EditScopesDialog showDialog(Project project2, @Nullable String scopeToSelect) {
        return EditScopesDialog.showDialog(project2, scopeToSelect, false);
    }

    public static EditScopesDialog showDialog(Project project2, @Nullable String scopeToSelect, boolean checkShared) {
        ScopeChooserConfigurable configurable = new ScopeChooserConfigurable(project2);
        EditScopesDialog dialog = new EditScopesDialog(project2, configurable, checkShared);
        if (scopeToSelect != null) {
            configurable.selectNodeInTree(scopeToSelect);
        }
        dialog.show();
        return dialog;
    }

    public NamedScope getSelectedScope() {
        return this.mySelectedScope;
    }
}

