/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.idea.CommandLineApplication;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.util.Disposer;
import com.intellij.testFramework.PlatformTestCase;
import org.jetbrains.annotations.Nullable;

public class IdeaTestApplication
extends CommandLineApplication
implements Disposable {
    private DataProvider myDataContext;

    private IdeaTestApplication() {
        super(true, true, true);
    }

    public void setDataProvider(@Nullable DataProvider dataContext) {
        this.myDataContext = dataContext;
    }

    @Override
    @Nullable
    public Object getData(String dataId) {
        return this.myDataContext == null ? null : this.myDataContext.getData(dataId);
    }

    public static IdeaTestApplication getInstance() {
        return IdeaTestApplication.getInstance(null);
    }

    public static synchronized IdeaTestApplication getInstance(@Nullable String configPath) {
        if (ourInstance == null) {
            PlatformTestCase.doAutodetectPlatformPrefix();
            new IdeaTestApplication();
            PluginManagerCore.getPlugins();
            ApplicationManagerEx.getApplicationEx().load(configPath);
        }
        return (IdeaTestApplication)ourInstance;
    }

    public void dispose() {
        IdeaTestApplication.disposeInstance();
    }

    private static void disposeInstance() {
        if (ourInstance == null) {
            return;
        }
        Application applicationEx = ApplicationManager.getApplication();
        if (applicationEx != null) {
            Disposer.dispose((Disposable)applicationEx);
        }
        ourInstance = null;
    }
}

