/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.idea;

import com.intellij.ide.BrowserUtil;
import com.intellij.ide.PrivacyPolicy;
import com.intellij.ide.customize.CustomizeIDEWizardDialog;
import com.intellij.ide.customize.CustomizeIDEWizardStepsProvider;
import com.intellij.ide.plugins.PluginManagerCore;
import com.intellij.ide.startupWizard.StartupWizard;
import com.intellij.idea.LoggerFactory;
import com.intellij.idea.Main;
import com.intellij.idea.SocketLock;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.ConfigImportHelper;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.ex.ApplicationEx;
import com.intellij.openapi.application.ex.ApplicationInfoEx;
import com.intellij.openapi.application.ex.ApplicationManagerEx;
import com.intellij.openapi.application.impl.ApplicationImpl;
import com.intellij.openapi.application.impl.ApplicationInfoImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ShutDownTracker;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.SystemInfoRt;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.io.win32.IdeaWin32;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import com.intellij.ui.HyperlinkAdapter;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.Consumer;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.PlatformUtils;
import com.intellij.util.lang.UrlClassLoader;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.SwingHelper;
import com.sun.jna.Native;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import org.apache.log4j.Appender;
import org.apache.log4j.ConsoleAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.io.BuiltInServer;

public class StartupUtil {
    public static final String NO_SPLASH = "nosplash";
    private static SocketLock ourSocketLock;

    private StartupUtil() {
    }

    public static boolean shouldShowSplash(String[] args) {
        return !Arrays.asList(args).contains(NO_SPLASH);
    }

    public static synchronized void addExternalInstanceListener(@Nullable Consumer<List<String>> consumer) {
        if (ourSocketLock != null) {
            ourSocketLock.setExternalInstanceListener(consumer);
        }
    }

    public static int getAcquiredPort() {
        BuiltInServer server = StartupUtil.getServer();
        return server == null ? -1 : server.getPort();
    }

    @Nullable
    public static synchronized BuiltInServer getServer() {
        return ourSocketLock == null ? null : ourSocketLock.getServer();
    }

    static void prepareAndStart(String[] args, AppStarter appStarter) {
        boolean newConfigFolder = false;
        if (!Main.isHeadless()) {
            AppUIUtil.updateFrameClass();
            boolean bl = newConfigFolder = !new File(PathManager.getConfigPath()).exists();
        }
        if (!StartupUtil.checkJdkVersion()) {
            System.exit(4);
        }
        System.setProperty("log4j.defaultInitOverride", "true");
        try {
            org.apache.log4j.Logger root = org.apache.log4j.Logger.getRootLogger();
            if (!root.getAllAppenders().hasMoreElements()) {
                root.setLevel(Level.WARN);
                root.addAppender((Appender)new ConsoleAppender((Layout)new PatternLayout("%m%n")));
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        if (!StartupUtil.checkSystemFolders()) {
            System.exit(5);
        }
        if (!StartupUtil.lockSystemFolders(args)) {
            System.exit(6);
        }
        if (newConfigFolder) {
            ConfigImportHelper.importConfigsTo(PathManager.getConfigPath());
        }
        Logger.setFactory(LoggerFactory.class);
        Logger log = Logger.getInstance(Main.class);
        StartupUtil.startLogging(log);
        StartupUtil.loadSystemLibraries(log);
        StartupUtil.fixProcessEnvironment(log);
        if (!Main.isHeadless()) {
            AppUIUtil.updateWindowIcon(JOptionPane.getRootFrame());
            AppUIUtil.registerBundledFonts();
            final Pair policy = PrivacyPolicy.getContent();
            if (!PrivacyPolicy.isVersionAccepted((PrivacyPolicy.Version)((PrivacyPolicy.Version)policy.getFirst()))) {
                try {
                    SwingUtilities.invokeAndWait(new Runnable(){

                        @Override
                        public void run() {
                            StartupUtil.showPrivacyPolicyAgreement((String)policy.getSecond());
                        }
                    });
                    PrivacyPolicy.setVersionAccepted((PrivacyPolicy.Version)((PrivacyPolicy.Version)policy.getFirst()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        appStarter.start(newConfigFolder);
    }

    private static boolean checkJdkVersion() {
        String jreCheck = System.getProperty("idea.jre.check");
        if (jreCheck != null && "true".equals(jreCheck)) {
            try {
                Class.forName("com.sun.jdi.Field", false, StartupUtil.class.getClassLoader());
            }
            catch (ClassNotFoundException e) {
                String message = "'tools.jar' seems to be not in " + ApplicationNamesInfo.getInstance().getProductName() + " classpath.\n" + "Please ensure JAVA_HOME points to JDK rather than JRE.";
                Main.showMessage((String)"JDK Required", (String)message, (boolean)true);
                return false;
            }
            catch (LinkageError e) {
                String message = "Cannot load a class from 'tools.jar': " + e.getMessage() + "\n" + "Please ensure JAVA_HOME points to JDK rather than JRE.";
                Main.showMessage((String)"JDK Required", (String)message, (boolean)true);
                return false;
            }
            if (StringUtil.containsIgnoreCase((String)System.getProperty("java.vm.name", ""), (String)"OpenJDK") && !SystemInfo.isJavaVersionAtLeast((String)"1.7")) {
                String message = "OpenJDK 6 is not supported. Please use Oracle Java or newer OpenJDK.";
                Main.showMessage((String)"Unsupported JVM", (String)message, (boolean)true);
                return false;
            }
        }
        if ((jreCheck = System.getProperty("idea.64bit.check")) != null && "true".equals(jreCheck) && PlatformUtils.isCidr() && !SystemInfo.is64Bit) {
            String message = "32-bit JVM is not supported. Please install 64-bit version.";
            Main.showMessage((String)"Unsupported JVM", (String)message, (boolean)true);
            return false;
        }
        return true;
    }

    private static synchronized boolean checkSystemFolders() {
        String configPath = PathManager.getConfigPath();
        PathManager.ensureConfigFolderExists();
        if (!new File(configPath).isDirectory()) {
            String message = "Config path '" + configPath + "' is invalid.\n" + "If you have modified the '" + "idea.config.path" + "' property please make sure it is correct,\n" + "otherwise please re-install the IDE.";
            Main.showMessage((String)"Invalid Config Path", (String)message, (boolean)true);
            return false;
        }
        String systemPath = PathManager.getSystemPath();
        if (!new File(systemPath).isDirectory()) {
            String message = "System path '" + systemPath + "' is invalid.\n" + "If you have modified the '" + "idea.system.path" + "' property please make sure it is correct,\n" + "otherwise please re-install the IDE.";
            Main.showMessage((String)"Invalid System Path", (String)message, (boolean)true);
            return false;
        }
        File logDir = new File(PathManager.getLogPath());
        boolean logOk = false;
        if (logDir.isDirectory() || logDir.mkdirs()) {
            try {
                File ideTempFile = new File(logDir, "idea_log_check.txt");
                StartupUtil.write(ideTempFile, "log check");
                StartupUtil.delete(ideTempFile);
                logOk = true;
            }
            catch (IOException ideTempFile) {
                // empty catch block
            }
        }
        if (!logOk) {
            String message = "Log path '" + logDir.getPath() + "' is inaccessible.\n" + "If you have modified the '" + "idea.log.path" + "' property please make sure it is correct,\n" + "otherwise please re-install the IDE.";
            Main.showMessage((String)"Invalid Log Path", (String)message, (boolean)true);
            return false;
        }
        File ideTempDir = new File(PathManager.getTempPath());
        String tempInaccessible = null;
        if (!ideTempDir.isDirectory() && !ideTempDir.mkdirs()) {
            tempInaccessible = "unable to create the directory";
        } else {
            try {
                File ideTempFile = new File(ideTempDir, "idea_tmp_check.sh");
                StartupUtil.write(ideTempFile, "#!/bin/sh\nexit 0");
                if (SystemInfo.isWindows || SystemInfo.isMac) {
                    tempInaccessible = null;
                } else if (!ideTempFile.setExecutable(true, true)) {
                    tempInaccessible = "cannot set executable permission";
                } else if (new ProcessBuilder(ideTempFile.getAbsolutePath()).start().waitFor() != 0) {
                    tempInaccessible = "cannot execute test script";
                }
                StartupUtil.delete(ideTempFile);
            }
            catch (Exception e) {
                tempInaccessible = e.getClass().getSimpleName() + ": " + e.getMessage();
            }
        }
        if (tempInaccessible != null) {
            String message = "Temp directory '" + ideTempDir + "' is inaccessible.\n" + "If you have modified the '" + "idea.system.path" + "' property please make sure it is correct,\n" + "otherwise please re-install the IDE.\n\nDetails: " + tempInaccessible;
            Main.showMessage((String)"Invalid System Path", (String)message, (boolean)true);
            return false;
        }
        return true;
    }

    private static void write(File file2, String content) throws IOException {
        try (FileWriter writer = new FileWriter(file2);){
            writer.write(content);
        }
    }

    private static void delete(File ideTempFile) {
        if (!FileUtilRt.delete((File)ideTempFile)) {
            ideTempFile.deleteOnExit();
        }
    }

    private static synchronized boolean lockSystemFolders(String[] args) {
        SocketLock.ActivateStatus status;
        if (ourSocketLock != null) {
            throw new AssertionError();
        }
        ourSocketLock = new SocketLock(PathManager.getConfigPath(), PathManager.getSystemPath());
        try {
            status = ourSocketLock.lock(args);
        }
        catch (Exception e) {
            Main.showMessage((String)"Cannot Lock System Folders", (Throwable)e);
            return false;
        }
        if (status == SocketLock.ActivateStatus.NO_INSTANCE) {
            ShutDownTracker.getInstance().registerShutdownTask(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<StartupUtil> clazz = StartupUtil.class;
                    synchronized (StartupUtil.class) {
                        ourSocketLock.dispose();
                        ourSocketLock = null;
                        // ** MonitorExit[var1_1] (shouldn't be in output)
                        return;
                    }
                }
            });
            return true;
        }
        if (Main.isHeadless() || status == SocketLock.ActivateStatus.CANNOT_ACTIVATE) {
            String message = "Only one instance of " + ApplicationNamesInfo.getInstance().getFullProductName() + " can be run at a time.";
            Main.showMessage((String)"Too Many Instances", (String)message, (boolean)true);
        }
        if (status == SocketLock.ActivateStatus.ACTIVATED) {
            System.out.println("Already running");
            System.exit(0);
        }
        return false;
    }

    private static void fixProcessEnvironment(Logger log) {
        boolean envReady;
        if (!Main.isCommandLine()) {
            System.setProperty("__idea.mac.env.lock", "unlocked");
        }
        if (!(envReady = EnvironmentUtil.isEnvironmentReady())) {
            log.info("initializing environment");
        }
    }

    private static void loadSystemLibraries(Logger log) {
        File ideTempDir = new File(PathManager.getTempPath());
        if (!ideTempDir.mkdirs() && !ideTempDir.exists()) {
            throw new RuntimeException("Unable to create temp directory '" + ideTempDir + "'");
        }
        if (System.getProperty("jna.tmpdir") == null) {
            System.setProperty("jna.tmpdir", ideTempDir.getPath());
        }
        if (System.getProperty("jna.nosys") == null) {
            System.setProperty("jna.nosys", "true");
        }
        try {
            long t = System.currentTimeMillis();
            log.info("JNA library loaded (" + Native.POINTER_SIZE * 8 + "-bit) in " + (System.currentTimeMillis() - t) + " ms");
        }
        catch (Throwable t) {
            StartupUtil.logError(log, "Unable to load JNA library", t);
        }
        if (SystemInfo.isWin2kOrNewer) {
            IdeaWin32.isAvailable();
        }
        if (SystemInfo.isWin2kOrNewer && !Main.isHeadless()) {
            try {
                UrlClassLoader.loadPlatformLibrary((String)"focusKiller");
                log.info("Using \"FocusKiller\" library to prevent focus stealing.");
            }
            catch (Throwable t) {
                log.info("\"FocusKiller\" library not found or there were problems loading it.", t);
            }
        }
        if (SystemInfo.isWindows) {
            System.setProperty("winp.unpack.dll.to.parent.dir", "false");
        }
    }

    private static void logError(Logger log, String message, Throwable t) {
        message = message + " (OS: " + SystemInfo.OS_NAME + " " + SystemInfo.OS_VERSION + ")";
        log.error(message, t);
    }

    private static void startLogging(final Logger log) {
        String extDirs;
        Runtime.getRuntime().addShutdownHook(new Thread("Shutdown hook - logging"){

            @Override
            public void run() {
                log.info("------------------------------------------------------ IDE SHUTDOWN ------------------------------------------------------");
            }
        });
        log.info("------------------------------------------------------ IDE STARTED ------------------------------------------------------");
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        ApplicationNamesInfo namesInfo = ApplicationNamesInfo.getInstance();
        String buildDate = new SimpleDateFormat("dd MMM yyyy HH:ss", Locale.US).format(appInfo.getBuildDate().getTime());
        log.info("IDE: " + namesInfo.getFullProductName() + " (build #" + appInfo.getBuild().asStringWithAllDetails() + ", " + buildDate + ")");
        log.info("OS: " + SystemInfoRt.OS_NAME + " (" + SystemInfoRt.OS_VERSION + ", " + SystemInfo.OS_ARCH + ")");
        log.info("JRE: " + System.getProperty("java.runtime.version", "-") + " (" + System.getProperty("java.vendor", "-") + ")");
        log.info("JVM: " + System.getProperty("java.vm.version", "-") + " (" + System.getProperty("java.vm.name", "-") + ")");
        List<String> arguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
        if (arguments != null) {
            log.info("JVM Args: " + StringUtil.join(arguments, (String)" "));
        }
        if ((extDirs = System.getProperty("java.ext.dirs")) != null) {
            for (String dir : StringUtil.split((String)extDirs, (String)File.pathSeparator)) {
                Object[] content = new File(dir).list();
                if (content == null || content.length <= 0) continue;
                log.info("ext: " + dir + ": " + Arrays.toString(content));
            }
        }
        log.info("JNU charset: " + System.getProperty("sun.jnu.encoding"));
    }

    public static void showPrivacyPolicyAgreement(final @NotNull String htmlText) {
        if (htmlText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "htmlText", "com/intellij/idea/StartupUtil", "showPrivacyPolicyAgreement"));
        }
        DialogWrapper dialog = new DialogWrapper(true){

            @Nullable
            protected JComponent createCenterPanel() {
                JPanel centerPanel = new JPanel(new BorderLayout(JBUI.scale((int)5), JBUI.scale((int)5)));
                final JEditorPane viewer = SwingHelper.createHtmlViewer(true, null, (Color)JBColor.WHITE, (Color)JBColor.BLACK);
                viewer.setFocusable(true);
                viewer.addHyperlinkListener((HyperlinkListener)new HyperlinkAdapter(){

                    protected void hyperlinkActivated(HyperlinkEvent e) {
                        URL url = e.getURL();
                        if (url != null) {
                            BrowserUtil.browse((URL)url);
                        } else {
                            SwingHelper.scrollToReference(viewer, e.getDescription());
                        }
                    }
                });
                viewer.setText(htmlText);
                StyleSheet styleSheet = ((HTMLDocument)viewer.getDocument()).getStyleSheet();
                styleSheet.addRule("body {font-family: \"Segoe UI\", Tahoma, sans-serif;}");
                styleSheet.addRule("body {margin-top:0;padding-top:0;}");
                styleSheet.addRule("body {font-size:" + JBUI.scaleFontSize((int)13) + "pt;}");
                styleSheet.addRule("h2, em {margin-top:" + JBUI.scaleFontSize((int)20) + "pt;}");
                styleSheet.addRule("h1, h2, h3, p, h4, em {margin-bottom:0;padding-bottom:0;}");
                styleSheet.addRule("p, h1 {margin-top:0;padding-top:" + JBUI.scaleFontSize((int)6) + "pt;}");
                styleSheet.addRule("li {margin-bottom:" + JBUI.scaleFontSize((int)6) + "pt;}");
                styleSheet.addRule("h2 {margin-top:0;padding-top:" + JBUI.scaleFontSize((int)13) + "pt;}");
                viewer.setCaretPosition(0);
                viewer.setBorder((Border)JBUI.Borders.empty((int)0, (int)5, (int)5, (int)5));
                centerPanel.add((Component)new JLabel("Please read and accept these terms and conditions:"), "North");
                centerPanel.add((Component)new JBScrollPane((Component)viewer, 20, 31), "Center");
                return centerPanel;
            }

            protected void createDefaultActions() {
                super.createDefaultActions();
                this.init();
                this.setOKButtonText("Accept");
                this.setCancelButtonText("Reject and Exit");
                this.setAutoAdjustable(false);
            }

            public void doCancelAction() {
                super.doCancelAction();
                ApplicationEx application = ApplicationManagerEx.getApplicationEx();
                if (application == null) {
                    System.exit(11);
                } else {
                    ((ApplicationImpl)application).exit(true, true, false, false);
                }
            }
        };
        dialog.setModal(true);
        dialog.setTitle(ApplicationNamesInfo.getInstance().getFullProductName() + " Privacy Policy Agreement");
        dialog.setSize(JBUI.scale((int)509), JBUI.scale((int)395));
        dialog.show();
    }

    static void runStartupWizard() {
        ApplicationInfoEx appInfo = ApplicationInfoImpl.getShadowInstance();
        String stepsProviderName = appInfo.getCustomizeIDEWizardStepsProvider();
        if (stepsProviderName != null) {
            CustomizeIDEWizardStepsProvider provider;
            try {
                Class<?> providerClass = Class.forName(stepsProviderName);
                provider = (CustomizeIDEWizardStepsProvider)providerClass.newInstance();
            }
            catch (Throwable e) {
                Main.showMessage((String)"Configuration Wizard Failed", (Throwable)e);
                return;
            }
            new CustomizeIDEWizardDialog(provider).show();
            PluginManagerCore.invalidatePlugins();
            return;
        }
        List<ApplicationInfoEx.PluginChooserPage> pages = appInfo.getPluginChooserPages();
        if (!pages.isEmpty()) {
            new StartupWizard(pages).show();
            PluginManagerCore.invalidatePlugins();
        }
    }

    static interface AppStarter {
        public void start(boolean var1);
    }
}

