/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.injected.editor;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.EditorWindow;
import com.intellij.injected.editor.RangeMarkerWindow;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingGroup;
import com.intellij.openapi.editor.ex.RangeMarkerEx;
import org.jetbrains.annotations.NotNull;

class FoldingRegionWindow
extends RangeMarkerWindow
implements FoldRegion {
    private final EditorWindow myEditorWindow;
    private final FoldRegion myHostRegion;

    FoldingRegionWindow(@NotNull DocumentWindow documentWindow, @NotNull EditorWindow editorWindow, @NotNull FoldRegion hostRegion, int startShift, int endShift) {
        if (documentWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "documentWindow", "com/intellij/injected/editor/FoldingRegionWindow", "<init>"));
        }
        if (editorWindow == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editorWindow", "com/intellij/injected/editor/FoldingRegionWindow", "<init>"));
        }
        if (hostRegion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "hostRegion", "com/intellij/injected/editor/FoldingRegionWindow", "<init>"));
        }
        super(documentWindow, (RangeMarkerEx)hostRegion, startShift, endShift);
        this.myEditorWindow = editorWindow;
        this.myHostRegion = hostRegion;
    }

    public boolean isExpanded() {
        return this.myHostRegion.isExpanded();
    }

    public void setExpanded(boolean expanded) {
        this.myHostRegion.setExpanded(expanded);
    }

    @NotNull
    public String getPlaceholderText() {
        String string = this.myHostRegion.getPlaceholderText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/injected/editor/FoldingRegionWindow", "getPlaceholderText"));
        }
        return string;
    }

    public Editor getEditor() {
        return this.myEditorWindow;
    }

    public FoldingGroup getGroup() {
        return this.myHostRegion.getGroup();
    }

    public boolean shouldNeverExpand() {
        return false;
    }

    @Override
    public RangeMarkerEx getDelegate() {
        return (RangeMarkerEx)this.myHostRegion;
    }
}

