/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.json.structureView;

import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.ide.util.treeView.smartTree.TreeElement;
import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonElement;
import com.intellij.json.psi.JsonFile;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonValue;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class JsonStructureViewElement
implements StructureViewTreeElement {
    private final JsonElement myElement;

    public JsonStructureViewElement(@NotNull JsonElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/json/structureView/JsonStructureViewElement", "<init>"));
        }
        assert (PsiTreeUtil.instanceOf((Object)element, (Class[])new Class[]{JsonFile.class, JsonProperty.class, JsonObject.class, JsonArray.class}));
        this.myElement = element;
    }

    public JsonElement getValue() {
        return this.myElement;
    }

    public void navigate(boolean requestFocus) {
        this.myElement.navigate(requestFocus);
    }

    public boolean canNavigate() {
        return this.myElement.canNavigate();
    }

    public boolean canNavigateToSource() {
        return this.myElement.canNavigateToSource();
    }

    @NotNull
    public ItemPresentation getPresentation() {
        ItemPresentation presentation = this.myElement.getPresentation();
        assert (presentation != null);
        ItemPresentation itemPresentation = presentation;
        if (itemPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/structureView/JsonStructureViewElement", "getPresentation"));
        }
        return itemPresentation;
    }

    @NotNull
    public TreeElement[] getChildren() {
        JsonElement value = null;
        if (this.myElement instanceof JsonFile) {
            value = ((JsonFile)this.myElement).getTopLevelValue();
        } else if (this.myElement instanceof JsonProperty) {
            value = ((JsonProperty)this.myElement).getValue();
        } else if (PsiTreeUtil.instanceOf((Object)this.myElement, (Class[])new Class[]{JsonObject.class, JsonArray.class})) {
            value = this.myElement;
        }
        if (value instanceof JsonObject) {
            JsonObject object = (JsonObject)value;
            TreeElement[] treeElementArray = (TreeElement[])ContainerUtil.map2Array(object.getPropertyList(), TreeElement.class, (Function)new Function<JsonProperty, TreeElement>(){

                public TreeElement fun(JsonProperty property) {
                    return new JsonStructureViewElement(property);
                }
            });
            if (treeElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/structureView/JsonStructureViewElement", "getChildren"));
            }
            return treeElementArray;
        }
        if (value instanceof JsonArray) {
            JsonArray array = (JsonArray)value;
            List childObjects = ContainerUtil.mapNotNull(array.getValueList(), (Function)new Function<JsonValue, TreeElement>(){

                public TreeElement fun(JsonValue value) {
                    if (value instanceof JsonObject && !((JsonObject)value).getPropertyList().isEmpty()) {
                        return new JsonStructureViewElement(value);
                    }
                    if (value instanceof JsonArray && PsiTreeUtil.findChildOfType((PsiElement)value, JsonProperty.class) != null) {
                        return new JsonStructureViewElement(value);
                    }
                    return null;
                }
            });
            TreeElement[] treeElementArray = (TreeElement[])ArrayUtil.toObjectArray((Collection)childObjects, TreeElement.class);
            if (treeElementArray == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/structureView/JsonStructureViewElement", "getChildren"));
            }
            return treeElementArray;
        }
        if (EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/json/structureView/JsonStructureViewElement", "getChildren"));
        }
        return EMPTY_ARRAY;
    }
}

