/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.application;

import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.ThreeState;
import java.io.File;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConfigImportSettings {
    public String getExecutableName() {
        return this.getProductName(ThreeState.NO);
    }

    public String[] getMainJarNames() {
        return new String[]{this.getProductName(ThreeState.NO)};
    }

    protected String getProductName(ThreeState full) {
        ApplicationNamesInfo namesInfo = ApplicationNamesInfo.getInstance();
        if (full == ThreeState.YES) {
            return namesInfo.getFullProductName();
        }
        if (full == ThreeState.NO) {
            return namesInfo.getProductName();
        }
        return namesInfo.getProductName().equals("IDEA") ? namesInfo.getFullProductName() : namesInfo.getProductName();
    }

    protected String getInaccessibleHomeErrorText(String instHome) {
        return ApplicationBundle.message((String)"error.no.read.permissions", (Object[])new Object[]{instHome});
    }

    protected String getInvalidHomeErrorText(String productWithVendor, String instHome) {
        return ApplicationBundle.message((String)"error.does.not.appear.to.be.installation.home", (Object[])new Object[]{instHome, productWithVendor});
    }

    protected String getCurrentHomeErrorText(String productWithVendor) {
        return ApplicationBundle.message((String)"error.selected.current.installation.home", (Object[])new Object[]{productWithVendor, productWithVendor});
    }

    protected String getEmptyHomeErrorText(String productWithVendor) {
        return ApplicationBundle.message((String)"error.please.select.previous.installation.home", (Object[])new Object[]{productWithVendor});
    }

    protected String getHomeLabel(String productName) {
        return ApplicationBundle.message((String)"editbox.installation.home", (Object[])new Object[]{productName});
    }

    protected String getAutoImportLabel(File guessedOldConfig) {
        String path = FileUtil.getLocationRelativeToUserHome((String)guessedOldConfig.getAbsolutePath());
        return ApplicationBundle.message((String)"radio.import.auto", (Object[])new Object[]{path});
    }

    protected String getDoNotImportLabel(String productName) {
        return ApplicationBundle.message((String)"radio.do.not.import", (Object[])new Object[]{productName});
    }

    protected String getTitleLabel(String productName) {
        return ApplicationBundle.message((String)"label.you.can.import", (Object[])new Object[]{productName});
    }

    @Nullable
    public String getCustomPathsSelector() {
        return null;
    }

    public String getInstallationHomeRequiredTitle() {
        return ApplicationBundle.message((String)"title.installation.home.required", (Object[])new Object[0]);
    }

    public void importFinished(String newConfigPath) {
    }

    @NotNull
    public List<File> getCustomLaunchFilesCandidates(File ideInstallationHome, File ideBinFolder) {
        List<File> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/openapi/application/ConfigImportSettings", "getCustomLaunchFilesCandidates"));
        }
        return list;
    }
}

