/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.util;

import com.intellij.compiler.impl.FileSetCompileScope;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.ex.CompileContextEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.descriptors.ConfigFile;
import gnu.trove.THashSet;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionValidatorUtil {
    private InspectionValidatorUtil() {
    }

    public static void addDescriptor(@NotNull Collection<VirtualFile> result, @Nullable ConfigFile configFile) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/compiler/util/InspectionValidatorUtil", "addDescriptor"));
        }
        if (configFile != null) {
            ContainerUtil.addIfNotNull((Object)configFile.getVirtualFile(), result);
        }
    }

    public static void addFile(@NotNull Collection<VirtualFile> result, @Nullable PsiFile psiFile) {
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "result", "com/intellij/openapi/compiler/util/InspectionValidatorUtil", "addFile"));
        }
        if (psiFile != null) {
            ContainerUtil.addIfNotNull((Object)psiFile.getVirtualFile(), result);
        }
    }

    public static Collection<VirtualFile> expandCompileScopeIfNeeded(Collection<VirtualFile> result, CompileContext context) {
        ProjectFileIndex index = ProjectRootManager.getInstance((Project)context.getProject()).getFileIndex();
        THashSet set = new THashSet();
        THashSet modules = new THashSet();
        for (VirtualFile file2 : result) {
            if (index.getSourceRootForFile(file2) != null) continue;
            set.add((Object)file2);
            ContainerUtil.addIfNotNull((Object)index.getModuleForFile(file2), (Collection)modules);
        }
        if (!set.isEmpty()) {
            ((CompileContextEx)context).addScope(new FileSetCompileScope((Collection<VirtualFile>)set, (Module[])modules.toArray((Object[])new Module[modules.size()])));
        }
        return result;
    }
}

