/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.mergeTool;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.ActionButtonPresentation;
import com.intellij.openapi.diff.DiffRequestFactory;
import com.intellij.openapi.diff.MergeRequest;
import com.intellij.openapi.diff.impl.mergeTool.MergeRequestImpl;
import com.intellij.openapi.diff.impl.mergeTool.MergeVersion;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DiffRequestFactoryImpl
extends DiffRequestFactory {
    private static final Logger LOG = Logger.getInstance(DiffRequestFactoryImpl.class);

    public MergeRequest createMergeRequest(@NotNull String leftText, @NotNull String rightText, @NotNull String originalContent, @NotNull VirtualFile file2, @Nullable Project project2, @Nullable ActionButtonPresentation okButtonPresentation, @Nullable ActionButtonPresentation cancelButtonPresentation) {
        if (leftText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftText", "com/intellij/openapi/diff/impl/mergeTool/DiffRequestFactoryImpl", "createMergeRequest"));
        }
        if (rightText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightText", "com/intellij/openapi/diff/impl/mergeTool/DiffRequestFactoryImpl", "createMergeRequest"));
        }
        if (originalContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalContent", "com/intellij/openapi/diff/impl/mergeTool/DiffRequestFactoryImpl", "createMergeRequest"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/openapi/diff/impl/mergeTool/DiffRequestFactoryImpl", "createMergeRequest"));
        }
        Document document = FileDocumentManager.getInstance().getDocument(file2);
        if (document != null) {
            return new MergeRequestImpl(leftText, (MergeVersion)new MergeVersion.MergeDocumentVersion(document, originalContent), rightText, project2, okButtonPresentation, cancelButtonPresentation);
        }
        LOG.warn("Document not found for " + file2.getPresentableUrl() + "; FileType - " + file2.getFileType().getName() + "; valid - " + file2.isValid());
        return this.create3WayDiffRequest(leftText, rightText, originalContent, file2.getFileType(), project2, okButtonPresentation, cancelButtonPresentation);
    }

    public MergeRequest create3WayDiffRequest(@NotNull String leftText, @NotNull String rightText, @NotNull String originalContent, @Nullable FileType type, @Nullable Project project2, @Nullable ActionButtonPresentation okButtonPresentation, @Nullable ActionButtonPresentation cancelButtonPresentation) {
        if (leftText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftText", "com/intellij/openapi/diff/impl/mergeTool/DiffRequestFactoryImpl", "create3WayDiffRequest"));
        }
        if (rightText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightText", "com/intellij/openapi/diff/impl/mergeTool/DiffRequestFactoryImpl", "create3WayDiffRequest"));
        }
        if (originalContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalContent", "com/intellij/openapi/diff/impl/mergeTool/DiffRequestFactoryImpl", "create3WayDiffRequest"));
        }
        return new MergeRequestImpl(leftText, originalContent, rightText, type, project2, okButtonPresentation, cancelButtonPresentation);
    }

    public MergeRequest create3WayDiffRequest(@NotNull String leftText, @NotNull String rightText, @NotNull String originalContent, @Nullable Project project2, @Nullable ActionButtonPresentation okButtonPresentation, @Nullable ActionButtonPresentation cancelButtonPresentation) {
        if (leftText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "leftText", "com/intellij/openapi/diff/impl/mergeTool/DiffRequestFactoryImpl", "create3WayDiffRequest"));
        }
        if (rightText == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rightText", "com/intellij/openapi/diff/impl/mergeTool/DiffRequestFactoryImpl", "create3WayDiffRequest"));
        }
        if (originalContent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "originalContent", "com/intellij/openapi/diff/impl/mergeTool/DiffRequestFactoryImpl", "create3WayDiffRequest"));
        }
        return this.create3WayDiffRequest(leftText, rightText, originalContent, null, project2, okButtonPresentation, cancelButtonPresentation);
    }
}

