/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.patch.formove;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.changes.ui.FilePathChangesTreeList;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.UIUtil;
import com.intellij.xml.util.XmlStringUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class UndoApplyPatchDialog
extends DialogWrapper {
    private final List<FilePath> myFailedFilePaths;
    private final Project myProject;
    private final boolean myShouldInformAboutBinaries;

    UndoApplyPatchDialog(@NotNull Project project2, @NotNull List<FilePath> filePaths, boolean shouldInformAboutBinaries) {
        if (project2 == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/openapi/diff/impl/patch/formove/UndoApplyPatchDialog", "<init>"));
        }
        if (filePaths == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "filePaths", "com/intellij/openapi/diff/impl/patch/formove/UndoApplyPatchDialog", "<init>"));
        }
        super(project2, true);
        this.myProject = project2;
        this.setTitle("Patch Applying Partly Failed");
        this.setOKButtonText("Rollback");
        this.myFailedFilePaths = filePaths;
        this.myShouldInformAboutBinaries = shouldInformAboutBinaries;
        this.init();
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        int numFiles = this.myFailedFilePaths.size();
        JPanel labelsPanel = new JPanel(new BorderLayout());
        String detailedText = numFiles == 0 ? "" : String.format("Failed to apply %s below.<br>", StringUtil.pluralize((String)"file", (int)numFiles));
        JBLabel infoLabel = new JBLabel(XmlStringUtil.wrapInHtml((CharSequence)(detailedText + "Would you like to rollback all applied?")));
        labelsPanel.add((Component)infoLabel, "North");
        if (this.myShouldInformAboutBinaries) {
            JLabel warningLabel = new JLabel("Rollback will not affect binaries");
            warningLabel.setIcon(UIUtil.getBalloonWarningIcon());
            labelsPanel.add((Component)warningLabel, "Center");
        }
        panel.add((Component)labelsPanel, "North");
        if (numFiles > 0) {
            FilePathChangesTreeList browser = new FilePathChangesTreeList(this.myProject, this.myFailedFilePaths, false, false, null, null, (JLabel)infoLabel){
                final /* synthetic */ JLabel val$infoLabel;
                {
                    this.val$infoLabel = jLabel;
                    super(project2, originalFiles, showCheckboxes, highlightProblems, inclusionListener, nodeDecorator);
                }

                @Override
                public Dimension getPreferredSize() {
                    return new Dimension(this.val$infoLabel.getPreferredSize().width, 50);
                }
            };
            browser.setChangesToDisplay(this.myFailedFilePaths);
            panel.add((Component)browser, "Center");
        }
        return panel;
    }
}

