/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.diff.impl.util;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import org.jetbrains.annotations.NonNls;

public class ContextLogger {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.openapi.diff.impl.util.ContextLogger");
    private final Logger myLogger;
    private final Context myInfo;
    private boolean myFirstError = true;

    public ContextLogger(Logger logger, Object context) {
        this(logger, new SimpleContext(context));
    }

    public ContextLogger(Logger logger, Context context) {
        this.myLogger = logger;
        this.myInfo = context;
    }

    public ContextLogger(String info) {
        this(LOG, info);
        this.assertTrue(this.isTestMode());
    }

    public void assertTrue(boolean condition) {
        this.assertTrue(condition, "");
    }

    public void assertTrue(boolean condition, String message) {
        if (condition) {
            return;
        }
        this.logError("Assertion: " + message);
    }

    private void logError(@NonNls String message) {
        if (this.myFirstError) {
            this.myLogger.error(message, this.myInfo.getDetails());
            this.myFirstError = false;
        } else {
            this.myLogger.error(message);
        }
    }

    private boolean isTestMode() {
        Application application = ApplicationManager.getApplication();
        return application == null || application.isUnitTestMode();
    }

    public void notImplemented() {
        this.throwTestException("Not implemented");
    }

    private void throwTestException(@NonNls String message) {
        if (this.isTestMode()) {
            throw new RuntimeException(message);
        }
        this.logError(message);
    }

    public void notTested() {
        this.throwTestException("Not Tested");
    }

    public void error(String message) {
        this.logError(message);
    }

    public static class SimpleContext
    implements Context {
        private final Object[] myContext;

        public SimpleContext(Object obj) {
            this(new Object[]{obj});
        }

        public SimpleContext(Object[] data) {
            this.myContext = data;
        }

        @Override
        public String[] getDetails() {
            String[] result = new String[this.myContext.length];
            for (int i = 0; i < this.myContext.length; ++i) {
                Object object = this.myContext[i];
                result[i] = String.valueOf(object);
            }
            return result;
        }
    }

    public static interface Context {
        public String[] getDetails();
    }
}

